#!/bin/sh

ksmroot=${ksmroot:-"/adds/kbmenu"}
ksmuser=${ksmuser:-"/mnt/onboard/.adds/kbmenu_user"}

set -e
stopanimation() {
  killall on-animator.sh
}
trap stopanimation EXIT


versionfilename=/mnt/onboard/.kobo/version
revinfofilename=/usr/local/Kobo/revinfo
patchbasedir=${ksmuser}/patchbase
kobolibdir=/usr/local/Kobo
patchprog=${ksmroot}/tools/patch32lsb_arm
logfile=${ksmroot}/log/khd_apply_patches.txt

if [ -e $versionfilename ]; then
  fwid=$(awk -F"," '{print $3}' $versionfilename)
else
  echo "failed_to_find_current_FW_version"
  exit
fi

if [ -e $revinfofilename ]; then
  revnum=$(awk '{print substr ($0, 0, 10)}' $revinfofilename)
else
  echo "failed_to_find_rev_number"
  exit
fi

patchdir="${patchbasedir}/${fwid}_${revnum}"
mkdir -p "${patchdir}/orig"

echo $(date) > "${logfile}"
therearepatches="false"

$ksmroot/scripts_intern/div/on-animator.sh &

for f in "${patchdir}/"*".patch"; do
  [ -e "${f}" ] && therearepatches="true" ||  break
  libtopatch=$(basename "${f}" .patch)
  [ -f "${patchdir}/org/${libtopatch}" ] || cp "${kobolibdir}/${libtopatch}" "${patchdir}/orig"
  ${patchprog} -p "${patchdir}/${libtopatch}.patch" -i "${patchdir}/orig/${libtopatch}" -o "${kobolibdir}/${libtopatch}" 2>> "${logfile}"
  if [ $? -eq 0 ]; then
    chmod -x "${kobolibdir}/${libtopatch}"
  else
    cp "${patchdir}/orig/${libtopatch}" "${kobolibdir}/${libtopatch}"
    echo "Some error occured while patching ${libtopatch}." >> "${logfile}"
  fi
done

if [ "${therearepatches}" == "false" ]; then
  echo "Found no patches for FW ${fwid} (${revnum}) on the device." >> "${logfile}"
  echo "Found_no_patches_for_currently_installed_FW_on_the_device."
  exit
fi

killall on-animator.sh
${ksmroot}/kbmessage.sh "-f ${logfile}"
