#!/usr/bin/python2
# -- coding: utf-8 --

# extract.py : extract all css streams 
# (brute force detection, takes some seconds but seems ok)
# Strings ends with null byte, so we find next \x00 and try to decode to get a valid string.

## fw 3.19.5761 => 
## 634 css streams in libnickel.so.1.0.0
##   0 css streams in librmsdk.so.1.0.0
##   1 css streams in libadobe.so
##  21 css streams in libsudoku.so
##   3 css streams in librushhour.so

# By pipcat. Thanks to: Surquizu, GeoffR, tshering, davidfor, mobileread.com

def save_file(name, data) :
	f = open(name, 'wb')
	f.write(data)
	f.close()
	print 'Saved file '+name

def zipstreams(filename) :
	with open(filename, 'rb') as fh:
		data = fh.read()

	print 'Analyzing %s ...' % filename
	pos = 0
	found = 0
	css_all = ''
	while pos < len(data) :
		try:
			pos_nextnull = data.find('\x00', pos)
			dif_pos = pos_nextnull - pos
			if pos_nextnull > 0 and dif_pos > 16 and dif_pos < 2000: #possible string with css code
				stream = data[pos:pos_nextnull]
				stream = stream.decode('utf-8').encode('utf-8') # force error if not string
				if stream.find('{') != -1 and stream.find('}') != -1 and stream.find(':') != -1: #guess css code
					found += 1
					css_all += '/* found: %d  pos: %x */\n' % (found, pos)
					css_all += stream + '\n\n'
				pos = pos_nextnull
		except:
			pos = pos
			
		pos += 1
		if pos == len(data):
			break

	print '%d css code streams found.' % found
	save_file('extracted/'+filename+'-all.css', css_all)


zipstreams('libnickel.so.1.0.0')
zipstreams('librmsdk.so.1.0.0')
zipstreams('libadobe.so')
zipstreams('libsudoku.so')
zipstreams('librushhour.so')
