#!/usr/bin/python2
# -- coding: utf-8 --

# patch.py : Second step for patching nickel css. 
# Gets changed files and compress in streams into nickel.

# By pipcat. Thanks to: Surquizu, GeoffR, tshering, davidfor, mobileread.com

SOURCE_NICKEL = 'nickel'
MODIF_NICKEL  = 'nickel-modif'
STREAM_NAME   = 'extracted/stream-'
STREAM_MODIF  = 'modified/stream-'

import zlib
import os

def make_executable(path):
	mode = os.stat(path).st_mode
	mode |= (mode & 0o444) >> 2    # copy R bits to X
	os.chmod(path, mode)

def save_file(name, data) :
	f = open(name, 'wb')
	f.write(data)
	f.close()
	print 'Saved file '+name

def zipstreams(filename) :
	with open(filename, 'rb') as fh:
		data = fh.read()

	## Patches outside compressed streams:
	#~ patch1_old = 'q#InlineDictionaryView {\n\tmin-width: 500px;\n\tmax-width: 500px;\n\tmin-height: 220px;\n\tmax-height: 220px;\n}\n#InlineDictionaryView[qApp_deviceIsPhoenix=\"true\"] {\n\tmin-width: 650px;\n\tmax-width: 650px;\n\tmin-height: 280px;\n\tmax-height: 280px;\n}\n#InlineDictionaryView[qApp_deviceIsDragon=\"true\"] {\n\tmin-width: 980px;\n\tmax-width: 980px;\n\tmin-height: 350px;\n\tmax-height: 350px;\n}\n'
	#~ patch1_new = 'q#InlineDictionaryView {\n\tmin-width: 500px;\n\tmax-width: 500px;\n\tmin-height: 220px;\n\tmax-height: 220px;\n}\n#InlineDictionaryView[qApp_deviceIsPhoenix=\"true\"] {\n\tmin-width: 650px;\n\tmax-width: 650px;\n\tmin-height: 280px;\n\tmax-height: 280px;\n}\n#InlineDictionaryView[qApp_deviceIsDragon=\"true\"] {\n\tmin-width: 980px;\n\tmax-width: 980px;\n\tmin-height: 350px;\n\tmax-height: 350px;\n}\n'
	#~ data = data.replace(patch1_old, patch1_new)
	
	## Patches inside compressed streams:
	pos = 0
	found = 0
	while pos < len(data) :
		window = data[pos:pos+2]
		if window == '\x78\x9C':
			try:
				zo = zlib.decompress(data[pos:])
				if zo[0:4] == '\x89PNG':
					ext = '.png'
				elif zo[0:4] == '\x8AMNG':
					ext = '.mng'
				elif zo[0:6] == '\x3C\xB8\x64\x18\xCA\xEF':
					ext = '.qm'
				elif found < 5:
					ext = '.txt'
				else:
					ext = '.css'

				name = STREAM_NAME + str(found) + ext
				name_modif = STREAM_MODIF + str(found) + ext
				if os.path.isfile(name_modif):
					zoco = zlib.compress(zo)
					len_zoco = len(zoco) # compressed stream length
					if zoco == data[pos:pos+len_zoco]:
						print '* Getting changes from ' + name_modif
						with open(name_modif, 'rb') as fhm:
							modif = fhm.read()
						if modif == zo:
							print 'No changes detected.'
						else:
							# compress stream and compare with original length
							modif_compressed = zlib.compress(modif)
							len_moco = len(modif_compressed)
							if len_moco == len_zoco:
								data = data[:pos]+modif_compressed+data[pos+len_zoco:]
								print 'Ok, compressed code after modification is same size.'
							elif len_moco < len_zoco:
								dif_len = len_zoco - len_moco
								data = data[:pos]+modif_compressed+('\x00' * dif_len)+data[pos+len_zoco:]
								print 'Ok, compressed code after modification is shorter. Padded with %d nulls.' % dif_len
							else:
								print 'NO patching possible! Compressed code after modification could not be longer than original.'
								print 'Original size: %d  New size: %d' % (len_zoco, len_moco)
						pos += len_zoco - 1
						
				found += 1
			except zlib.error:
				pos = pos
			
		pos += 1
		if pos == len(data):
			break

	# Save nickel
	save_file(MODIF_NICKEL, data)
	make_executable(MODIF_NICKEL)


zipstreams(SOURCE_NICKEL)
