#!/usr/bin/python2
# -- coding: utf-8 --

# extract.py : First step for patching nickel css. 
# Extract all compressed streams and save in files.

# By pipcat. Thanks to: Surquizu, GeoffR, tshering, davidfor, mobileread.com

SOURCE_NICKEL = 'nickel'
STREAM_NAME   = 'extracted/stream-'

import zlib

def save_file(name, data) :
	f = open(name, 'wb')
	f.write(data)
	f.close()
	print 'Saved file '+name

def zipstreams(filename) :
	with open(filename, 'rb') as fh:
		data = fh.read()

	pos = 0
	found = 0
	while pos < len(data) :
		window = data[pos:pos+2]
		if window == '\x78\x9C':
			try:
				zo = zlib.decompress(data[pos:])
				if zo[0:4] == '\x89PNG':
					ext = '.png'
				elif zo[0:4] == '\x8AMNG':
					ext = '.mng'
				elif zo[0:6] == '\x3C\xB8\x64\x18\xCA\xEF':
					ext = '.qm'
				elif found < 5:
					ext = '.txt'
				else:
					ext = '.css'
						
				name = STREAM_NAME + str(found) + ext
				save_file(name, zo)
				found += 1
			except zlib.error:
				pos = pos
			
		pos += 1
		if pos == len(data):
			break


zipstreams(SOURCE_NICKEL)
