# -*- coding: utf-8 -*-
from __future__ import (unicode_literals, division, absolute_import, print_function)
__license__   = 'GPL v3'
__copyright__ = '2012, Agama'
__docformat__ = 'restructuredtext en'

import os

from calibre.gui2.actions import InterfaceAction
from calibre.gui2 import error_dialog
from calibre_plugins.book_links.main import PlugUI
from calibre_plugins.book_links.config import prefs

class InterfacePlugin(InterfaceAction):

    name        = 'Book Links'
    action_spec = (name, None, 'Link book to supplementary material', 'Ctrl+L')

    def genesis(self):

        icon = get_icons('icon.png')
        self.qaction.setIcon(icon)
        self.qaction.triggered.connect(self.show_ui)

    def show_ui(self):
        #~ Heavily modified 20160527 to get it to at least show the dialog.
        #~ The biggest issue at the moment is the creation of an empty book using an invalid format, lrf .  So, hardcoded to create a .txt instead, which is unacceptable long-term.
        #~ Next step:  deal with the format issue.  Also, document in Comments what this plug-in is supposed to do and how it is supposed to do it.
        conf = self.interface_action_base_plugin.do_user_config
        rix = self.gui.library_view.currentIndex()
        if not rix.isValid():
            return error_dialog(self.gui, self.name, 'Select a book', show=True)
        bkid = self.gui.library_view.model().id(rix)
        db = self.gui.library_view.model().db
        self.lib_path = self.gui.library_view.model().db.library_path
        from calibre.library.database2 import LibraryDatabase2
        ldb2 = LibraryDatabase2(self.lib_path)
        from calibre.ebooks.oeb.polish.create import create_book
        from calibre.ptempfile import PersistentTemporaryFile
        #~ format_ = prefs['blex']  # illegal format type for an empty book...
        prefs['blex'] = "txt"      # valid_empty_formats = {'epub', 'txt', 'docx', 'azw3'}
        format_ = prefs['blex']  # no dot before create_book...
        pt = PersistentTemporaryFile(suffix='.' + format_)
        pt.close()
        try:
            id_ = bkid
            mi = db.new_api.get_metadata(id_, get_cover=False,
                                get_user_categories=False, cover_as_data=False)
            create_book(mi, pt.name, fmt=format_)
            db.add_format_with_hooks(id_, format_, pt.name, index_is_id=True, notify=True)
        finally:
            os.remove(pt.name)
        prefs['blex'] = ".txt"   # need the dot hereafter
        titl = mi.title
        path = ldb2.construct_path_name(bkid)
        fil = ldb2.construct_file_name(bkid)
        lib = ldb2.library_path
        bklf = os.path.join(lib, path, fil)
        blex = prefs['blex']
        bklf = bklf + blex
        if os.path.isfile(bklf):
            pass   # empty book at this point, so no way not to get the error_dialog...
            #~ fv = open(bklf,'r')
            #~ txt = fv.readline(15)
            #~ fv.close()
            #~ if not txt[:11] == '[booklinks]':
                #~ txt = titl + '\n\n[booklinks] not found in ' + blex
                #~ return error_dialog(self.gui, self.name, txt, show=True)
        else:
            pass  # as currently written, there will always be an empty book created just above...so skip this for now...
            #~ fil = 'booklinks' + blex
            #~ path = os.path.join(prefs['root'], fil)
            #~ if not os.path.isfile(path):
                #~ txt = 'Cannot find ' + fil
                #~ return error_dialog(self.gui, self.name, txt, show=True)
            #~ txt = blex.upper()
            #~ db.add_format_with_hooks(bkid, txt, path, index_is_id=True, notify=True)

        ui = PlugUI(self.gui, self.qaction.icon(), conf, titl, bklf)
        ui.show()

    def apply_prefs(self):
        prefs

