# -*- coding: utf-8 -*-
from __future__ import (unicode_literals, division, absolute_import, print_function)
__license__   = 'GPL v3'
__copyright__ = '2012, Agama'
__docformat__ = 'restructuredtext en'

from PyQt5.Qt import QDialog, QMessageBox, QVBoxLayout, QLabel, QLineEdit, QPushButton

class LinkEd(QDialog):

    def __init__(self, icon, bklf, blnx):

        QDialog.__init__(self)

        self.name = 'Edit Links'
        self.bklf = bklf
        self.blnx = blnx

        self.lay = QVBoxLayout()
        self.setLayout(self.lay)
        self.setWindowTitle(self.name)
        self.setWindowIcon(icon)

# Local
        self.la1 = QLabel('Local Folder:')
        self.lay.addWidget(self.la1)
        self.ed1 = QLineEdit(self)
        self.ed1.setMaxLength(128)
        self.ed1.setText(blnx[1])
        self.lay.addWidget(self.ed1)
# Web
        self.la2 = QLabel('Web Page:')
        self.lay.addWidget(self.la2)
        self.ed2 = QLineEdit(self)
        self.ed2.setMaxLength(256)
        self.ed2.setText(blnx[2])
        self.lay.addWidget(self.ed2)

        self.btn1 = QPushButton('&Update Link File', self)
        self.btn1.clicked.connect(self.update)
        self.lay.addWidget(self.btn1)

        self.resize(self.sizeHint())
        self.setMinimumWidth(250)
        self.setModal(True)

        self.blnx[0] = 'E'

    def mesg(self,txt):

        QMessageBox.about(self, self.name, txt)

    def update(self):

        self.blnx[0] = 'U'
        self.blnx[1] = str(self.ed1.text())
        self.blnx[2] = str(self.ed2.text())
        self.accept()
        return
