# -*- coding: utf-8 -*-
from __future__ import (unicode_literals, division, absolute_import, print_function)
__license__   = 'GPL v3'
__copyright__ = '2012, Agama'
__docformat__ = 'restructuredtext en'

import os

from PyQt5.Qt import QWidget, QVBoxLayout, QLabel, QLineEdit, QComboBox, QMessageBox
from calibre.utils.config import JSONConfig

prefs = JSONConfig('plugins/Book Links')

prefs.defaults['blex'] = '.lrf'
prefs.defaults['root'] = ''

class ConfigWidget(QWidget):

    def __init__(self):

        QWidget.__init__(self)

        self.extn = ['.lrf','.lit','.rar','.rtf','.txt']
        self.blex = prefs['blex']

        self.lay = QVBoxLayout()
        self.setLayout(self.lay)
# Extn
        self.la1 = QLabel('Book Links Filetype')
        self.lay.addWidget(self.la1)
        self.cb1 = QComboBox(self)
        self.cb1.addItems(self.extn)
        if self.blex in self.extn:
            ix = self.extn.index(self.blex)
        else:
            ix = 0
        self.cb1.setCurrentIndex(ix)
        self.lay.addWidget(self.cb1)

# Root
        self.la2 = QLabel('Local Folder Root')
        self.lay.addWidget(self.la2)
        self.ed2 = QLineEdit(self)
        self.ed2.setMaxLength(128)
        self.ed2.setText(prefs['root'])
        self.lay.addWidget(self.ed2)

        self.resize(self.sizeHint())
        self.setMinimumWidth(250)

    def save_settings(self):

        root = unicode(self.ed2.text())
        blex = str(self.cb1.currentText())
        prefs['blex'] = blex
        prefs['root'] = root

        if not os.path.isdir(root):
            txt = 'Warning!\n\nLocal path does not exist\n\n' + root
            QMessageBox.about(self, 'Customise Book Links', txt)
        else:
            fil = 'booklinks' + blex
            path = os.path.join(root, fil)
            fv = open(path,'w')
            fv.write('[booklinks]\n')
            fv.close()
