# -*- coding: utf-8 -*-
from __future__ import (unicode_literals, division, absolute_import, print_function)
__license__   = 'GPL v3'
__copyright__ = '2012, Agama'

from calibre.customize import InterfaceActionBase

class PlugInfo(InterfaceActionBase):

    name                = 'Book Links'
    description         = 'Link book to supplementary material'
    supported_platforms = ['windows', 'linux', 'osx']
    author              = 'Agama'
    version             = (0, 5, 6)
    minimum_calibre_version = (0, 2, 50)

    can_be_disabled = True

    actual_plugin = 'calibre_plugins.book_links.ui:InterfacePlugin'
    action_type   = 'current'

    def is_customizable(self):
        return True

    def config_widget(self):

        from calibre_plugins.book_links.config import ConfigWidget
        return ConfigWidget()

    def save_settings(self, config_widget):

        config_widget.save_settings()

