#!/bin/sh

PATH=/bin:/sbin:/usr/bin:/usr/sbin
DATA=/tmp/data 
SYSTEM=/tmp/system 

echo Starting $0 `date`

mkdir -p ${DATA}
mkdir -p ${SYSTEM}

mount /dev/mmcblk2p9 ${DATA}
mount /dev/mmcblk2p10 ${SYSTEM}

# remount read-write to create backups
mount ${UPDATE_MP} -o remount,rw

echo UPDATE_MP = ${UPDATE_MP}
mount
echo "--"

if [ -d ${UPDATE_MP} ] && [ ! -d ${UPDATE_MP}/.backup ]
then
   mkdir -p ${UPDATE_MP}/.backup
fi

if [ -d ${UPDATE_MP}/.backup ]
then
   echo "Creating backup..."

   cp -fp ${SYSTEM}/app/EbookReader.* ${UPDATE_MP}/.backup/
   cp -f ${DATA}/system/packages.xml ${UPDATE_MP}/.backup/
else
   echo "Could not create backup, maybe remount failed..."
fi

if [ -d ${UPDATE_MP}/updates/system ]
then
   echo "Updating /system"
   cd ${UPDATE_MP}/updates/system
   if [ -f app/EbookReader.apk ]
   then
      echo "Reinstall EbookReader.apk with custom signature"
      rm -rf ${SYSTEM}/app/EbookReader.odex
      sed -i '/EbookReader/,/<\/package>/ { d }' ${DATA}/system/packages.xml
   fi
   cd -
   cp -rfp ${UPDATE_MP}/updates/system/* ${SYSTEM}
fi

if [ -f ${DATA}/system/packages.xml ]
then
   echo "Get rid of preferred activities in packages.xml"
   sed -i '/<preferred-activities>/,/<\/preferred-activities>/ { /preferred-activities/b; d }' ${DATA}/system/packages.xml

   echo "System signatures"
   sed -i '/uid.system/,/perms/{/uid.system/b;/perms/b;d}' ${DATA}/system/packages.xml
   rm ${DATA}/dalvik-cache/*
fi

umount ${DATA}
umount ${SYSTEM}

echo Done $0 `date`
