#!/bin/sh

# Hide/Show books
# usage: 
# for hiding, in the search bar type: 		;log h passw
# for showing, in the search bar type:		;log s passw

LOG=/mnt/us/documents/HideBooks.log

if [ "$#" -ne 2 ]; then	
    	echo "$(date +"%Y-%m-%d %H:%M:%S"): Illegal number of parameters">>$LOG
else
	check=$(openssl aes-256-cbc -in /var/local/etc/HideBooks.dat -d -pass pass:$2)
	
	c1=$(echo $check|cut -d \; -f 1)
	pwd=$(echo $check|cut -d \; -f 2)

	if [ "$c1" =  "OK, let's go" ]; then
		
		if [ $1 = h ]; then
			# Hide
			echo "$(date +"%Y-%m-%d %H:%M:%S"): crypting..." >>$LOG
			
			i=0
			find /mnt/us/documents -name 'h_*' -type f |( while read book; do 
				openssl aes-256-cbc -in "$book" -out "$book.enc" -e -pass pass:$pwd
				echo "$book--->$book.enc" >>$LOG
				rm "$book"
				
				i=$(( i+1 ))	
			done
			echo "$(date +"%Y-%m-%d %H:%M:%S"): encrypted $i files" >>$LOG)  
			
			# refreshing book list...
			dbus-send --system /default com.lab126.powerd.resuming int32:1
	  	else
			if [ $1 = s ]; then
				# Show
				echo "$(date +"%Y-%m-%d %H:%M:%S"): decrypting..." >>$LOG
				i=0
	        		find /mnt/us/documents -name h_*.enc -type f | (while read book; do
					dec_book=${book%.*} 				
					openssl aes-256-cbc -in "$book" -out "$dec_book" -d -pass pass:$pwd	  
					echo "$book--->$dec_book" >>$LOG
		   			rm "$book"
	
					i=$(( i+1 ))	
				done
				echo "$(date +"%Y-%m-%d %H:%M:%S"): decrypted $i files" >>$LOG)
	
				# refreshing book list...
				dbus-send --system /default com.lab126.powerd.resuming int32:1
	    		else
				echo "$(date +"%Y-%m-%d %H:%M:%S"): unknown command" >>$LOG        		
			fi
		fi
	else
	  	echo "$(date +"%Y-%m-%d %H:%M:%S"): wrong password" >>$LOG
	fi
fi

