#!/usr/bin/env python
# -*- coding: utf-8 -*-
# vim:ts=4:sw=4:softtabstop=4:smarttab:expandtab

from __future__ import unicode_literals, division, absolute_import, print_function
import sys
import os
import cssutils

def unique_filename(name, namelist):
    bname = name
    ext = ''
    if '.' in name:
        bname, ext = name.rsplit('.',1)
        ext = "." + ext
    cnt = 0
    uname = bname + ext
    while uname in namelist:
        uname = bname + '%04d' % cnt + ext
        cnt += 1
    return uname

# need to find a unique prefix that does not exist
# in the currently used class names
def unique_classbase(name, classlist):
    uname = name
    cnt = 0
    unique = False
    while not unique:
        unique = True
        for cname in classlist:
            unique = unique and cname != uname
            unique = unique and not cname.startswith(uname)
            if not unique:
                break
        if not unique:
            uname = 'sgc%d_' % cnt + name
            cnt += 1
    return uname

def run(bk):
    epubversion = "2.0"
    if bk.launcher_version() >= 20160102:
        epubversion = bk.epub_version()

    # build up list of all stylesheets to prevent name clash
    namelist = []
    classlist = []
    for id, href in bk.css_iter():
        namelist.append(os.path.basename(href))
        cssdata = bk.readfile(id)
        # parse each sheet to make sure all new class names are unique as well
        try:
            sheet = cssutils.parseString(cssdata)
            for rule in sheet:
                if rule.type == rule.STYLE_RULE:
                    seltext = rule.selectorText
                    selectors = seltext.split()
                    for sel in selectors:
                        if '.' in sel:
                            elem, nclass = sel.split('.')
                            classlist.append(nclass)
        except:
            pass

    css_new_filename = unique_filename('sgc_styles.css', namelist)
    class_base = unique_classbase('rule',classlist)
    css_rules = {}
    css_rule_cnt = 0
    
    # easiest to use built in quickparser for this
    ps = bk.qp

    in_svg = False
    in_mathml = False

    for id, href in bk.text_iter():
        data = bk.readfile(id)
        ps.setContent(data)
        res = []
        has_inline_styles = False
	    
        # loop through all tags modifying if needed and converting back to xhtml
        for text, tagprefix, tname, ttype, tattr, in ps.parse_iter():
	    
            if text is not None:
                res.append(text)
                continue

            if tname == "head" and ttype == 'end':
                # inject link to new css file
                res.append('<link href="../Styles/%s" rel="stylesheet" type="text/css" />\n' % css_new_filename)
			
            # do not touch inline styles inside svg and math elements 
            if tname in ['svg:svg', 'svg'] and ttype in ['begin', 'single']:
                in_svg = True
                
            if tname in ['math', 'm:math', 'mml:math'] and ttype in ['begin', 'single']:
                in_mathml = True

            # convert any style attributes to classes
            if ttype in ['begin', 'single'] and not in_mathml and not in_svg:
                # strip out inline styles
                if 'style' in tattr.keys():
                    has_inline_styles = True
                    style = tattr.pop('style').strip()
                    ncls = None
                    rule = style
                    for sel, srule in css_rules.items():
                        if srule == rule:
                            ncls = sel
                            break
                    if ncls is None:
                        css_rule_cnt += 1
                        ncls = class_base + '_%d' % css_rule_cnt
                    css_rules[ncls] = rule
                    # now add in or extend class attribute
                    cls = tattr.get('class', '')
                    cls = cls + (' ' if cls else '') + ncls
                    tattr['class'] = cls
            
            # detect end of mathml and/or svg elements
            if tname in ['math', 'm:math', 'mml:math'] and ttype in ['end', 'single']:
                in_mathml = False

            if tname in ['svg:svg', 'svg'] and ttype in ['end', 'single']:
                in_svg = False
                
            # convert potentially modified tags back to xhtml
            res.append(ps.tag_info_to_xml(tname, ttype, tattr))

        # rebuild the xhtml text
        data = "".join(res)
        # write out the changes only if inline styles actually found and replaced
        if has_inline_styles:
            bk.writefile(id,data)
            print("Removed inline styles from: ", href)
        else:
            print("No inline styles found in: ", href)
        
    # done with all xhtml files so
    # now create the new css style sheet
    res = []
    for sel, srule in css_rules.items():
        res.append('.' + sel + ' {\n')
        properties = srule.split(';')
        for prop in properties:
            if prop is not None and prop != '':
                res.append('  ' + prop + ';\n')
        res.append('}\n')
    cssdata = "".join(res)
    # only add the new stylesheet if it is actually needed/used
    if len(cssdata) > 0:
        bk.addfile(css_new_filename, css_new_filename, cssdata, mime='text/css')
        print("Inline styles converted to new stylesheet: ", css_new_filename)
    else:
        print("No inline styles found\n")
    return 0
	

def main():
    print("I reached main when I should not have")
    return -1
    
if __name__ == "__main__":
    sys.exit(main())

    
    
