#!/bin/sh


if [ "x$fbrotatevalue" == "x" ]; then
  /bin/busybox poweroff
fi

ksmroot=${ksmroot:-"/adds/kbmenu"}
if [ "$ksmroot" == "/mnt/onboard/.adds/kbmenu" ]; then
  ksmuser="/mnt/onboard/.adds/kbmenu"
else
  ksmuser=${ksmuser:-"/mnt/onboard/.adds/kbmenu_user"}
fi
uptimelog=$ksmroot/log/uptime.txt


if [ "$fbrotatevalue" != "$(cat /sys/class/graphics/fb0/rotate)" ]; then
  echo "$fbrotatevalue" > /sys/class/graphics/fb0/rotate
  cat /sys/class/graphics/fb0/rotate > /sys/class/graphics/fb0/rotate
fi

if [ "x$poweroffRandomdir" != "x" ]; then
  pofile=$($ksmroot/helpers/getrandomfile.sh $poweroffRandomdir "*.html" "*.htm")
  export mrotation="$poweroffRotation"
fi

pofile=${pofile:-"$ksmuser/txt/poweroff_info.html"}
$ksmroot/kbmessage.sh "-f $pofile" &
usleep 400000

last=$(awk 'END {print $4}' $uptimelog)
bat="$(cat /sys/devices/platform/pmic_battery.1/power_supply/mc13892_bat/capacity)"
echo "$(date +%Y:%m:%d_%H:%M), $(awk -v last="$last" -v bat="$bat" '{printf("%d:%02d:%02d:%02d total: %d bat: %d",($1/60/60/24),($1/60/60%24),($1/60%60),($1%60),($1+last),(bat))}' /proc/uptime)" >> $uptimelog


/bin/busybox poweroff
