__license__   = 'GPL v3'
__copyright__ = '2012, Agama'
__docformat__ = 'restructuredtext en'

import os

from calibre.gui2.actions import InterfaceAction
from calibre.gui2 import error_dialog
from calibre_plugins.book_links.main import PlugUI
from calibre_plugins.book_links.config import prefs

class InterfacePlugin(InterfaceAction):

    name        = 'Book Links'
    action_spec = (name, None, 'Link book to supplementary material', 'Ctrl+L')

    def genesis(self):

        icon = get_icons('icon.png')
        self.qaction.setIcon(icon)
        self.qaction.triggered.connect(self.show_ui)

    def show_ui(self):

        conf = self.interface_action_base_plugin.do_user_config
        rix = self.gui.library_view.currentIndex()
        if not rix.isValid():
            return error_dialog(self.gui, self.name, 'Select a book', show=True)

        bkid = self.gui.library_view.model().id(rix)
        elib = self.gui.current_db
        mi = elib.get_metadata(bkid, index_is_id=True)
        titl = mi.title
        path = elib.construct_path_name(bkid)
        fil = elib.construct_file_name(bkid)
        lib = elib.library_path
        bklf = os.path.join(lib, path, fil)
        blex = prefs['blex']
        bklf = bklf + blex
        if os.path.isfile(bklf):
            fv = open(bklf,'r')
            txt = fv.readline(15)
            fv.close()
            if not txt[:11] == '[booklinks]':
                txt = titl + '\n\n[booklinks] not found in ' + blex
                return error_dialog(self.gui, self.name, txt, show=True)
        else:
            fil = 'booklinks' + blex
            path = os.path.join(prefs['root'], fil)
            if not os.path.isfile(path):
                txt = 'Cannot find ' + fil
                return error_dialog(self.gui, self.name, txt, show=True)
            txt = blex.upper()
            elib.add_format_with_hooks(bkid, txt, path, index_is_id=True, notify=True)

        ui = PlugUI(self.gui, self.qaction.icon(), conf, titl, bklf)
        ui.show()
        
    def apply_prefs(self):
        prefs

