__license__   = 'GPL v3'
__copyright__ = '2012, Agama'
__docformat__ = 'restructuredtext en'

import os

from PyQt5.Qt import QDialog, QVBoxLayout, QPushButton, QMessageBox, QLabel, QUrl
from calibre.gui2 import error_dialog, open_local_file, open_url
from calibre_plugins.book_links.config import prefs
from calibre_plugins.book_links.edit import LinkEd

class PlugUI(QDialog):

    blty = ('', 'path', 'web', 'wiki')
    blnx = ['', '', '', '', '']
    
    def __init__(self, gui, icon, conf, titl, bklf):

        QDialog.__init__(self, gui)

        self.name = 'Book Links'
        self.icon = icon
        self.conf = conf
        self.bklf = bklf

        self.lay = QVBoxLayout()
        self.setLayout(self.lay)

        self.setWindowTitle(self.name)
        self.setWindowIcon(icon)

        self.lbl = QLabel(titl)
        self.lay.addWidget(self.lbl)

        self.btn1 = QPushButton('&Open Local Folder', self)
        self.btn1.clicked.connect(self.open_local)
        self.lay.addWidget(self.btn1)

        self.btn2 = QPushButton('Open &Web Page', self)
        self.btn2.clicked.connect(self.open_web)
        self.lay.addWidget(self.btn2)

        self.btn3 = QPushButton('&Edit Book Links', self)
        self.btn3.clicked.connect(self.edit_links)
        self.lay.addWidget(self.btn3)

        self.resize(self.sizeHint())
        self.setMinimumWidth(200)
        self.setModal(True)

        self.load_bklf()

    def mesg(self,txt):

        QMessageBox.about(self, self.name, txt)

    def load_bklf(self):

        self.blnx = ['', '', '', '', '']
        fv = open(self.bklf,'r')
        txt = fv.readlines()
        fv.close()
        for lin in txt:
            ix = lin.find('\n')
            if ix > 0:
                lin = lin[:ix]
            ix = lin.find('=')
            if ix > 0:
                typ = lin[:ix]
                lnk = lin[ix+1:]
                if typ in self.blty:
                    ix = self.blty.index(typ)
                    self.blnx[ix] = lnk
        return

    def save_bklf(self):

        txt = ['[booklinks]\n', '', '', '']
        nof = len(self.blty)
        ix = 1
        while ix < nof:
            txt[ix] = self.blty[ix] + '=' + self.blnx[ix] + '\n'
            ix += 1
        fv = open(self.bklf,'w')
        fv.writelines(txt)
        fv.close()

    def open_local(self):

        lnk = os.path.join(prefs['root'], self.blnx[1])
        if os.path.isdir(lnk):
            open_local_file(lnk)
        else:
            txt = 'Local Folder not found\n\n' + lnk
            self.mesg(txt)

    def open_web(self):
        
        lnk = self.blnx[2]
        if lnk != '':
            open_url(QUrl.fromUserInput(lnk))
        else:
            txt = 'Web Link is not defined'
            self.mesg(txt)

    def edit_links(self):
    
        ui = LinkEd(self.icon, self.bklf, self.blnx)
        ui.exec_()

        if self.blnx[0] == 'U':
            self.save_bklf()
