__license__   = 'GPL v3'
__copyright__ = '2012, Agama'
__docformat__ = 'restructuredtext en'

from calibre.customize import InterfaceActionBase

class PlugInfo(InterfaceActionBase):

    name                = 'Book Links'
    description         = 'Link book to supplementary material'
    supported_platforms = ['windows', 'linux', 'osx']
    author              = 'Agama'
    version             = (0, 5, 5)
    minimum_calibre_version = (0, 8, 0)

    can_be_disabled = True

    actual_plugin = 'calibre_plugins.book_links.ui:InterfacePlugin'
    action_type   = 'current'

    def is_customizable(self):
        return True

    def config_widget(self):

        from calibre_plugins.book_links.config import ConfigWidget
        return ConfigWidget()

    def save_settings(self, config_widget):

        config_widget.save_settings()

