#!/bin/sh

ksmroot=${ksmroot:-"/adds/kbmenu"}

if [ $(grep -c 'VLASOVSOFT_FIFO1' "$vlasovsoftbasedir/launcher.sh") -lt 1 ]; then
  $ksmroot/kbmessage.sh "unsupported version of launcher"
  exit
fi


frontlightprg=$ksmroot/tools/frontlight
dontTamperwithFrontlight=${dontTamperwithFrontlight:-"true"}

if [ "$KSMdebugmode" == "true" ]; then
  debug_logfile=$ksmroot/log/ksmdebug_$(date +%Y%m%d_%H%M%S)_$(basename $0).log
  echo "started: $(date +%Y%m%d_%H%M%S)" > $debug_logfile
  echo "product: $PRODUCT" >> $debug_logfile
fi

# frontligth off
[ "$dontTamperwithFrontlight" == "true" ] && [ "$PRODUCT" != "trilogy" ] && [ "$PRODUCT" != "pixie" ] &&
(
$frontlightprg "0"
[ "$KSMdebugmode" == "true" ] && echo "on start: frontlight level set to 0" >> $debug_logfile
)



# ==== KSM variant of the launcher
# set variables
export ROOT="$vlasovsoftbasedir"

export ROOT_BAK=$ROOT/../vlasovsoft.bak
LOG=/dev/null
case `/bin/kobo_config.sh * 2>/dev/null` in
  alyssum) DEVICE=GLOHD ;;
  dahlia)  DEVICE=AURAH2O ;;
  dragon)  DEVICE=AURAHD  ;;
  phoenix) DEVICE=AURA    ;;
  kraken)  DEVICE=GLO     ;;
  trilogy) DEVICE=TOUCH   ;;
  pixie)   DEVICE=MINI    ;;
  *)       DEVICE=TOUCH   ;;
esac
export DEVICE
export TMPDIR=/tmp/vlasovsoft
export LANG=en_US.UTF-8
export VLASOVSOFT_KEY=$ROOT/key
export VLASOVSOFT_KBD=$ROOT/kbd.txt
export VLASOVSOFT_FIFO1=$TMPDIR/fifo1
export VLASOVSOFT_FIFO2=$TMPDIR/fifo2
export VLASOVSOFT_I18N=$ROOT/i18n
export VLASOVSOFT_DICT=$ROOT/dictionary
export QT_PLUGIN_PATH=$ROOT/Qt/plugins
export LD_LIBRARY_PATH=$ROOT/Qt/lib
if [ $DEVICE == AURAH2O -o $DEVICE == GLOHD ]; then
  export QWS_MOUSE_PROTO=KoboTS_h2o
else
  export QWS_MOUSE_PROTO=KoboTS
fi
export QWS_KEYBOARD=KoboKb
export QWS_DISPLAY=Transformed:KoboFB
export QT_QWS_FONTDIR=$ROOT/fonts
export STYLESHEET=$ROOT/eink.qss
export UPDATE_DELAY_PART=25
export UPDATE_DELAY_FULL=50
export SWIPE_MIN_DISTANCE=10 # mm
cd $ROOT

# kill nickel
#killall nickel
#killall hindenburg
#killall fmon

# make the temporary directory for Qt
mkdir -p $TMPDIR

# make fifos
mkfifo $VLASOVSOFT_FIFO1
mkfifo $VLASOVSOFT_FIFO2

# remount external SD card to read/write
# /bin/mount -w -o remount /mnt/sd

# upgrade
if [ -d $ROOT_BAK -a ! -f $ROOT/upgraded ]; then
  $ROOT/upgrade.sh
  touch $ROOT/upgraded
fi

# run launcher
# echo 0 > /sys/class/graphics/fb0/rotate
$ROOT/launcher -qws -stylesheet $STYLESHEET > $LOG 2>&1

# remove fifos
rm $VLASOVSOFT_FIFO1
rm $VLASOVSOFT_FIFO2

#/sbin/reboot



#set frontlight for KSM
[ $PRODUCT != trilogy ] && [ $PRODUCT != pixie ] && [ $PRODUCT != pika ] && (
$frontlightprg "$KSMfrontlightlevel"
[ "$KSMdebugmode" == "true" ] && echo "before exit: frontlight level set to $KSMfrontlightlevel" >> $debug_logfile
)
