#!/usr/bin/env python
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai
# from __future__ import (unicode_literals, division, absolute_import,
#                         print_function)

__license__   = 'GPL v3'
__copyright__ = '2015, David Forrester <davidfor@internode.on.net>'
__docformat__ = 'restructuredtext en'

# import time
# from urllib import quote
# from Queue import Queue, Empty
# 
# from calibre import as_unicode
# from calibre.ebooks.metadata import check_isbn
from calibre.ebooks.metadata.sources.base import Source
# from calibre.utils.icu import lower
# from calibre.utils.cleantext import clean_ascii_chars

from calibre.devices.usbms.driver import debug_print
# from calibre_plugins.genericidentifiers.config import ConfigWidget
# import calibre_plugins.generic_identifiers.config as cfg

class GenericIdentifiers(Source):

    name = 'Generic Identifiers'
    description = _('Define generic identifiers for any site.')
    author = 'David Forrester'
    version = (0, 0, 2)
    minimum_calibre_version = (1, 48, 0)

#    capabilities = frozenset(['identify', 'cover'])
#    touched_fields = frozenset(['title', 'authors', 'identifier:goodreads',
#        'identifier:isbn', 'rating', 'comments', 'publisher', 'pubdate',
#        'tags', 'series', 'languages'])
#    has_html_comments = True
#    supports_gzip_transfer_encoding = True

    def config_widget(self):
        '''
        Overriding the default configuration screen for our own custom configuration
        '''
        import calibre_plugins.generic_identifiers.config as cfg
        return cfg.ConfigWidget(self)

    def get_book_urls(self, identifiers):
        import calibre_plugins.generic_identifiers.config as cfg
        indentifier_mappings = cfg.plugin_prefs[cfg.STORE_NAME][cfg.KEY_IDENTIFIERS]
        debug_print("get_book_urls: indentifier_mappings=", indentifier_mappings)
        data = []
        for generic_identifier in indentifier_mappings.keys():
            debug_print("get_book_urls: generic_identifier=", generic_identifier)
            if generic_identifier in identifiers:
                identifier_map = indentifier_mappings[generic_identifier]
                debug_print("get_book_urls: identifier_map=", identifier_map)
                url = identifier_map.get('url', None)
                debug_print("get_book_urls: 1 url=", url)
                displayName = identifier_map['displayName']
                debug_print("get_book_urls: displayName=", displayName)
                if url:
                    identifier_id = identifiers[generic_identifier]
                    
                    if '%s' in url:
                        url = url % identifier_id
                    else:
                        url += identifier_id
                    debug_print("get_book_urls: 2 url=", url)
                    data.append((generic_identifier, identifier_id, url))
        return data

    def get_book_url_name(self, idtype, idval, url):
        import calibre_plugins.generic_identifiers.config as cfg
        debug_print("get_book_url_name: idtype=", idtype, " idval=", idval)
        indentifier_mappings = cfg.plugin_prefs[cfg.STORE_NAME][cfg.KEY_IDENTIFIERS]
        identifier_map = indentifier_mappings.get(idtype, None)
        if identifier_map:
            indentifier_name = identifier_map['displayName']
            debug_print("get_book_url_name: indentifier_name=", indentifier_name, " identifier_map=", identifier_map)
            if indentifier_name and len(indentifier_name) > 1:
                return indentifier_name
        return idtype
