#!/usr/bin/env python
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai
from __future__ import (unicode_literals, division, absolute_import,
                        print_function)
from datetime import datetime


__copyright__ = '2015, Terisa de Morgan <terisam@gmail.com>'
__docformat__ = 'restructuredtext en'

from functools import partial
try:
    from PyQt5.Qt import QToolButton, QMenu, QModelIndex
except ImportError:
    from PyQt4.Qt import QToolButton, QMenu

from calibre.ebooks.metadata.book.base import Metadata
from calibre.gui2 import (question_dialog, Dispatcher, error_dialog)
from calibre.gui2.actions import InterfaceAction
from calibre.gui2.dialogs.message_box import ErrorNotification
from calibre.ptempfile import PersistentTemporaryDirectory, remove_dir
from calibre.gui2.dialogs.progress import ProgressDialog
from contextlib import closing
from calibre.utils.date import now, UNDEFINED_DATE, DEFAULT_DATE, EPOCH
from calibre.utils.config import prefs, tweaks
from calibre.customize.ui import plugin_for_input_format
from calibre.db.legacy import LibraryDatabase

from calibre_plugins.norm_comment.common_utils import (set_plugin_icon_resources, get_icon, create_menu_action_unique, debug_print)

from threading import Thread

from calibre.ebooks.metadata.book.base import Metadata
from calibre.library import current_library_name

import os
import re
import time

PLUGIN_ICONS = ['images/tools.png', 'images/update_series_status.png','images/estimate.png','images/metadata.png', 'images/update_comment.png', 'images/update_metadata.png', 'images/mark_reread.png', 'images/update_conversion.png']

try:
    debug_print("NormComment::action.py - loading translations")
    load_translations()
except NameError:
    debug_print("NormComment::action.py - exception when loading translations")
    pass # load_translations() added in calibre 1.9
	
class NormCommentAction(InterfaceAction):

    name = 'Normalize Comment'
    # Create our top-level menu/toolbar action (text, icon_path, tooltip, keyboard shortcut)
    action_spec = ('Normalize Comment', None, _('Clean html formats in comment'), ())
    popup_type = QToolButton.MenuButtonPopup
    action_type = 'current'
    dont_add_to = frozenset(['context-menu-device'])

    def genesis(self):
        self.is_library_selected = True
        self.menu = QMenu(self.gui)
        self.menu_actions = []

        # Read the plugin icons and store for potential sharing with the config widget
        icon_resources = self.load_resources(PLUGIN_ICONS)
        set_plugin_icon_resources(self.name, icon_resources)

        self.build_menus()
        self.nltk_pickle = self._get_nltk_resource()

        # Assign our menu to this action and an icon
        self.qaction.setMenu(self.menu)
        self.qaction.setIcon(get_icon(PLUGIN_ICONS[0]))
        self.qaction.triggered.connect(self.toolbar_triggered)

    def library_changed(self, db):
        # We need to reapply keyboard shortcuts after switching libraries
		debug_print ("NormComment: library changed (", current_library_name(), ")")
        self.reactivate_menus()

    def location_selected(self, loc):
        self.is_library_selected = loc == 'library'

    def build_menus(self):
        m = self.menu
        m.clear()

		candidate = self.gui.library_path
		db = LibraryDatabase (candidate)

        ac = create_menu_action_unique(self, m, _('&Normalize comment'), 'images/update_comment.png',
                                  triggered=partial(self._normalize_comment),
                                  shortcut_name=_('Normalize comment'))
        self.menu_actions.append (ac)

        self.gui.keyboard.finalize()

	def reactivate_menus(self):
		candidate = self.gui.library_path
		db = LibraryDatabase (candidate)

    def toolbar_triggered(self):
        self._normalize_comment

    def _get_nltk_resource(self):
        # Retrieve the english pickle file. Can't do it from within the nltk code
        # because of our funky situation of executing a plugin from a zip file.
        # So we retrieve it here and pass it through when executing jobs.
        ENGLISH_PICKLE_FILE = 'nltk_lite/english.pickle'
        pickle_data = self.load_resources([ENGLISH_PICKLE_FILE])[ENGLISH_PICKLE_FILE]
        return pickle_data

    def _normalize_comment(self):
        if not self.is_library_selected:
            return error_dialog(self.gui, _('No selected book'),
                    _('No book selected for normalizing comments'), show=True)
            return

        rows = self.gui.library_view.selectionModel().selectedRows()
        if not rows or len(rows) == 0 :
            return error_dialog(self.gui, _('No selected book'),
                    _('No book selected for normalizing comments'), show=True)
        book_ids = self.gui.library_view.get_selected_ids()

        self._do_replace_text (book_ids)
		
	def _do_replace_text (self, book_ids):
		from calibre.utils.html2text import html2text
        # Queue all the books and kick off the job
		
        dbA = self.gui.current_db

        db = self.gui.current_db.new_api

        # Para cada uno de los libros actualiza los metadatos

        id_aux = {}
		
		regEx = {}
		regEx[0] = re.compile ("^\**(.*)\**$", re.MULTILINE)	
		regEx[1] = re.compile ("^##* (.*)$", re.MULTILINE)	
		regEx[2] = re.compile ("\**$", re.MULTILINE)	
		subS = "\g<1>"
		subS1 = ""
		
		lis_aux_id = []

        for id in book_ids:
            miA = dbA.get_metadata (id, index_is_id=True, get_cover=False)
            texto = miA.get ("comments")
			
			if texto is not None:			
				debug_print ("Texto: ", texto)
				id_aux[id] = html2text(texto)
				id_aux[id] = regEx[0].sub (subS, id_aux[id])
				id_aux[id] = regEx[1].sub (subS, id_aux[id])
				id_aux[id] = regEx[2].sub (subS1, id_aux[id])
				lis_aux_id.append (id)

        dbA.new_api.set_field('comments', {id:id_aux[id] for id in lis_aux_id})
        self.gui.iactions['Edit Metadata'].refresh_gui(book_ids, covers_changed=False)
        