#!/usr/bin/python3

import re, os, sys, glob

pref,suff='../Text/chapter','.html'

id_fichier={}
nu_fichier={}
id_nu={}
# Recherche du fichier de numéro le plus élevé
fichiers=glob.glob('%s*[0-9]%s'%(pref,suff))
def id_nu_fichier(fic):
   k=re.search('%s(\d+)%s'%(pref,suff),fic)
   if k:
      id=k.group(1)
      nu=int(id)
      if nu in id_nu :
         sys.stderr.write("\nIl existe les numéros %s et %s\n\n"%(id_nu[nu],id))
         exit(1)
      id_fichier[fic]=id
      nu_fichier[fic]=nu
      id_nu[nu]=id
for fic in fichiers: id_nu_fichier(fic)
fichiers.sort(key=lambda x:nu_fichier[x])
der=id_fichier[fichiers[-1]]
print("der=%s"%(der))

# On vérifie que le fichier de sortie n'existe pas déjà
out='%s%smodif%s'%(pref,der,suff)
if os.path.lexists(out):
   sys.stderr.write("\nAttention : le fichier %s existe déjà\n\n"%out)
   exit(1)

# Recherche de : href="fichier#ftnx" id="bodyftnx"
rec_lien=re.compile('(href="%s(?P<fil>\d+)%s#ftn(?P<id>\d+)"\s+id="bodyftn(?P=id)")'%(pref,suff))
# Recherche de : href="dernier_fichier#ftnx" id="bodyftnx"
rec_lien99=re.compile('(href="%s%s%s#ftn(?P<id>\d+)"\s+id="bodyftn(?P=id)")'%(pref,der,suff))
# Recherche de : href="dernier_fichier#bodyftnx" id="ftnx"
lien99='(href="%s)%s(%s#bodyftn%%s"\s+id="ftn%%s")'%(pref,der,suff)

# Liste des liens dans tous les fichiers sauf le dernier
liste_liens=[]
for num_fic in range(1,int(der)):
   try:
      with open('%s%s%s'%(pref,id_nu[num_fic],suff),'r') as fic: liens=rec_lien.findall(fic.read())
   except (FileNotFoundError,KeyError): continue
   for lien in liens:
      num_fil=lien[1]
      num_id=lien[2]
      if id_nu[int(num_fil)]==der: liste_liens.append((num_fic,num_fil,num_id,lien[0]))

# fichier[id] : numéro du fichier qui contient le lien de numéro id
fichier={}
for num_fic,num_fil,num_id,lien in liste_liens:
   fichier[num_id]=id_nu[num_fic]

# Modification des liens du dernier fichier
with open('%s%s%s'%(pref,der,suff),'r') as fic: f99=fic.read()
f99bis=f99
for id in fichier:
   k=re.search(lien99%(id,id),f99bis)
   if k:
      f99bis=f99bis[:k.start(0)]+k.group(1)+fichier[id]+k.group(2)+f99bis[k.end(0):]

# Écriture du résultat
with open(out,'w') as fic: fic.write(f99bis)
