#! /usr/bin/python

from __future__ import with_statement
import sys
import os
import traceback

from calibre.ebooks.lit.reader import LitReader

def touch_content(self):
    for entry in self.manifest.values():
        if 'spine' in entry.state:
            name = '/'.join(('/data', entry.internal, 'content'))
            self.get_markup_file(name).encode('utf-8')
        else:
            name = '/'.join(('/data', entry.internal))
            self.get_file(name)

LitReader.touch_content = touch_content

def main(args=sys.argv):
    if len(args) != 3:
        print "Usage: %s LOGFILE DIRECTORY" % args[0]
        sys.exit(1)
    lname, dir = args[1:]
    interesting = False
    with open(lname, 'w') as log:
        print "Scanning LIT files..."
        for root, dirs, files in os.walk(dir):
            for fname in files:
                if not fname.lower().endswith(".lit"):
                    continue
                fname = os.path.join(root, fname)
                sys.stdout.write('  * %s... ' % fname)
                sys.stdout.flush()
                try:
                    with open(fname, 'rb') as stream:
                        lr = LitReader(stream)
                        if lr.drmlevel >= 5:
                            print "DRM5"
                        else:
                            lr.touch_content()
                            print "OK"
                except Exception:
                    interesting = True
                    log.write("=== %s\n%s\n" % (fname, traceback.format_exc()))
                    print "ERROR"
    print "...done!\n"
    if interesting:
        print "Interesting!  Please send %s to <llasram@gmail.com>." % lname
    else:
        print "Nothing interesting found, but thank you for your help."

if __name__ == '__main__':
    main()
