#!/bin/sh

: << 'manifest'
$ tar --list --file=copycmp.tgz
copycmp/
copycmp/copycmp.sh
copycmp/arm/
copycmp/arm/dc3dd
copycmp/arm/dd
copycmp/x86/
copycmp/x86/dc3dd
copycmp/x86/dd
copycmp/tests-x86/
copycmp/tests-x86/copycmp.sh
copycmp/tests-x86/tests.log
copycmp/tests-x86/full-blk-ref/
copycmp/tests-x86/full-blk-ref/ones.bin
copycmp/tests-x86/full-blk-ref/lab126.bin
copycmp/tests-x86/full-blk-ref/zeros.bin
copycmp/tests-x86/full-blk-ref/rand.bin
copycmp/tests-x86/dd
copycmp/tests-x86/test-script.sh
copycmp/tests-x86/part-blk-ref/
copycmp/tests-x86/part-blk-ref/ones.bin
copycmp/tests-x86/part-blk-ref/lab126.bin
copycmp/tests-x86/part-blk-ref/zeros.bin
copycmp/tests-x86/part-blk-ref/rand.bin
manifest

tst=0
pref='test0'

echo '=== Normal output when both sizes equal'
echo '=== ending on full block or partial block'
echo

tst=$((tst+1)) ; try=$pref$tst
# *.src and *.dst different, test: c-w/r/c
echo '=== Src and Dst both 3 full blocks, test: c-w/r/c'
cp -a full-blk-ref/rand.bin   $try.src
cp -a full-blk-ref/lab126.bin $try.dst
b=`stat -c %s $try.dst`
./copycmp.sh $try.src $try.dst $1
a=`stat -c %s $try.dst`
echo "$try.dst: Before: $a; After: $b"
echo

# *.src and *.dst the same, test: compare
echo '=== Src and Dst both 3 full blocks, test: c'
b=`stat -c %s $try.dst`
./copycmp.sh $try.src $try.dst $1
a=`stat -c %s $try.dst`
echo "$try.dst: Before: $a; After: $b"
rm $try.*
echo

tst=$((tst+1)) ; try=$pref$tst
# *.src and *.dst different, test: c-w/r/c
echo '=== Src and Dst both 3-1/2 blocks, test: c-w/r/c'
cp -a part-blk-ref/ones.bin $try.src
cp -a part-blk-ref/zeros.bin $try.dst
b=`stat -c %s $try.dst`
./copycmp.sh $try.src $try.dst $1
a=`stat -c %s $try.dst`
echo "$try.dst: Before: $a; After: $b"
echo

# *.src and *.dst the same, test: compare
echo '=== Src and Dst both 3-1/2 blocks, test: c'
b=`stat -c %s $try.dst`
./copycmp.sh $try.src $try.dst $1
a=`stat -c %s $try.dst`
echo "$try.dst: Before: $a; After: $b"
rm $try.*
echo

echo '=== Following are "Notice"s because they might be intended usage.'
echo '=== That is: Changing only an initial portion of the destination.'
echo

# One block difference, on block boundaries

tst=$((tst+1)) ; try=$pref$tst
# *.src and *.dst different, *.src < *.dst, test: c-w/r/c
echo '=== Src 2 full blocks, Dst 3 full blocks, test: c-w/r/c'
dd if=full-blk-ref/rand.bin of=$try.src bs=4096 count=2 2>/dev/null
cp -a full-blk-ref/ones.bin $try.dst
b=`stat -c %s $try.dst`
./copycmp.sh $try.src $try.dst $1
a=`stat -c %s $try.dst`
echo "$try.dst: Before: $a; After: $b"
echo

# *.src and *.dst same, *.src < *.dst, test: compare
echo '=== Src 2 full blocks, Dst 3 full blocks, test: c'
b=`stat -c %s $try.dst`
./copycmp.sh $try.src $try.dst $1
a=`stat -c %s $try.dst`
echo "$try.dst: Before: $a; After: $b"
rm $try.*
echo

# One block difference, partial block boundaries

tst=$((tst+1)) ; try=$pref$tst
# *.src and *.dst different, *.src < *.dst, test: c-w/r/c
echo '=== Src 2-1/2 blocks, Dst 3-1/2 blocks, test: c-w/r/c'
dd if=full-blk-ref/ones.bin of=$try.src bs=2048 count=5 2>/dev/null
cp -a part-blk-ref/lab126.bin $try.dst
b=`stat -c %s $try.dst`
./copycmp.sh $try.src $try.dst $1
a=`stat -c %s $try.dst`
echo "$try.dst: Before: $a; After: $b"
echo

# *.src and *.dst same, *.src < *.dst, test: compare
echo '=== Src 2-1/2 blocks, Dst 3-1/2 blocks, test: c'
b=`stat -c %s $try.dst`
./copycmp.sh $try.src $try.dst $1
a=`stat -c %s $try.dst`
echo "$try.dst: Before: $a; After: $b"
rm $try.*
echo

# Less than one block difference, partial block boundaries

tst=$((tst+1)) ; try=$pref$tst
# *.src and *.dst different, test: c-w/r/c
echo '=== Src 3-1/4 blocks, Dst 3-1/2 blocks, test: c-w/r/c'
dd if=part-blk-ref/ones.bin of=$try.src bs=1024 count=13 2>/dev/null
cp -a part-blk-ref/zeros.bin $try.dst
b=`stat -c %s $try.dst`
./copycmp.sh $try.src $try.dst $1
a=`stat -c %s $try.dst`
echo "$try.dst: Before: $a; After: $b"
echo

# *.src and *.dst the same, test: compare
echo '=== Src 3-1/4 blocks, Dst 3-1/2 blocks, test: c'
b=`stat -c %s $try.dst`
./copycmp.sh $try.src $try.dst $1
a=`stat -c %s $try.dst`
echo "$try.dst: Before: $a; After: $b"
rm $try.*
echo

tst=$((tst+1)) ; try=$pref$tst
# 1+0.0+1) Src 3 blocks, Dst 2-3/4 blocks
echo '=== Src 3 blocks, Dst 2-3/4 blocks, test: c-w/r/c'
cp -a full-blk-ref/ones.bin $try.src
dd if=full-blk-ref/lab126.bin of=$try.dst bs=1024 count=11 2>/dev/null
b=`stat -c %s $try.dst`
./copycmp.sh $try.src $try.dst $1
a=`stat -c %s $try.dst`
echo "$try.dst: Before: $a; After: $b"
echo

echo '=== Src 3 blocks, Dst 2-3/4 blocks, test: c'
b=`stat -c %s $try.dst`
./copycmp.sh $try.src $try.dst $1
a=`stat -c %s $try.dst`
echo "$try.dst: Before: $a; After: $b"
rm $try.*
echo

echo '=== Typically error conditions (source and destination size mis-match).'
echo '=== But since EOF is only recognized when encountered, the destination'
echo '=== blocks prior to the current block have been modified.'
echo

tst=$((tst+1)) ; try=$pref$tst
# 1+0.0+0) Src 3 blocks, Dst 2 blocks
echo '=== Src 3 blocks, Dst 2 blocks, test: c-w/r/c'
cp -a full-blk-ref/lab126.bin $try.src
dd if=full-blk-ref/zeros.bin of=$try.dst bs=4096 count=2 2>/dev/null
b=`stat -c %s $try.dst`
./copycmp.sh $try.src $try.dst $1
a=`stat -c %s $try.dst`
echo "$try.dst: Before: $a; After: $b"
echo

echo '=== Src 3 blocks, Dst 2 blocks, test: c'
b=`stat -c %s $try.dst`
./copycmp.sh $try.src $try.dst $1
a=`stat -c %s $try.dst`
echo "$try.dst: Before: $a; After: $b"
rm $try.*
echo

tst=$((tst+1)) ; try=$pref$tst
# 0+0.0+1) Src 3 blocks, Dst 3-1/4 blocks
echo '=== Src 3 blocks, Dst 3-1/4 blocks, test: c-w/r/c'
cp -a full-blk-ref/rand.bin $try.src
dd if=part-blk-ref/lab126.bin of=$try.dst bs=1024 count=13 2>/dev/null
b=`stat -c %s $try.dst`
./copycmp.sh $try.src $try.dst $1
a=`stat -c %s $try.dst`
echo "$try.dst: Before: $a; After: $b"
echo

echo '=== Src 3 blocks, Dst 3-1/4 blocks, test: c'
b=`stat -c %s $try.dst`
./copycmp.sh $try.src $try.dst $1
a=`stat -c %s $try.dst`
echo "$try.dst: Before: $a; After: $b"
rm $try.*
echo

tst=$((tst+1)) ; try=$pref$tst
# 0+0.1+0) Src 2 blocks, Dst 3 blocks
echo '=== Src 2 blocks, Dst 3 blocks, test: c-w/r/c'
dd if=full-blk-ref/zeros.bin of=$try.src bs=4096 count=2 2>/dev/null
cp -a full-blk-ref/rand.bin $try.dst
b=`stat -c %s $try.dst`
./copycmp.sh $try.src $try.dst $1
a=`stat -c %s $try.dst`
echo "$try.dst: Before: $a; After: $b"
echo

echo '=== Src 2 blocks, Dst 3 blocks, test: c'
b=`stat -c %s $try.dst`
./copycmp.sh $try.src $try.dst $1
a=`stat -c %s $try.dst`
echo "$try.dst: Before: $a; After: $b"
rm $try.*
echo

tst=$((tst+1)) ; try=$pref$tst
# 0+1.0+0) Src 3-1/2 blocks, Dst 3 blocks
echo '=== Src 3-1/2 blocks, Dst 3 blocks, test: c-w/r/c'
cp -a part-blk-ref/lab126.bin $try.src
cp -a full-blk-ref/ones.bin $try.dst
b=`stat -c %s $try.dst`
./copycmp.sh $try.src $try.dst $1
a=`stat -c %s $try.dst`
echo "$try.dst: Before: $a; After: $b"
echo

echo '=== Src 3-1/2 blocks, Dst 3 blocks, test: c'
b=`stat -c %s $try.dst`
./copycmp.sh $try.src $try.dst $1
a=`stat -c %s $try.dst`
echo "$try.dst: Before: $a; After: $b"
rm $try.*
echo

exit 0
