﻿#!/usr/bin/env python
# -*- coding: utf-8 -*-

import os,sys
import re
import tempfile
import shutil
from subprocess import call
from PIL import Image
from sys import platform as _platform
from io import BytesIO
PY2 = sys.version_info[0] == 2
JPEGLINUX = 'jpegtran'

if sys.platform.startswith('win'):
    # Windows
    iswindows = True
    isosx = False
    islinux = False
elif _platform == "darwin":
    iswindows = False
    isosx = True
    islinux = False
else:
    isosx = False
    iswindows = False
    islinux = True
   
def OptiWrapper(*args):
    # execute optimizer program
    ret = call(list(args))
    return ret

def run(bk):
    # set script_dir
    SCRIPT_DIR = os.path.join(bk._w.plugin_dir, 'ImageOptimizer')
    
    # get prefs
    prefs = bk.getPrefs()
    # set defaults
    if 'jpegtran_path' not in prefs:
        prefs['jpegtran_path'] = None
    if 'use_wine' not in prefs:
        prefs['use_wine'] = False
    # save preferences
    bk.savePrefs(prefs)

    # ensure excution rights OSX
    if isosx:
        os.chmod("./osx/gifsicle",0o777)
        os.chmod("./osx/optipng",0o777)
        os.chmod("./osx/jpegtran",0o777)
           
    # create temp folder
    temp_dir = tempfile.mkdtemp()

    # loop through images
    for (id, href, mime) in bk.image_iter():
        img = Image.open(BytesIO(bk.readfile(id)))
        image_name = os.path.join(temp_dir, href[7:])
        img.save(image_name)
        img.close
        ProcessImage(image_name, SCRIPT_DIR, prefs)
        img_file = open(image_name, "rb")
        image_data = img_file.read()    
        img_file.close()
        bk.writefile(id,image_data)
    # delete temp folders and files
    ignore_errors = sys.platform == 'win32'
    shutil.rmtree(temp_dir, ignore_errors)

    # Setting the proper Return value is important.
    # 0 - means success
    # anything else means failure
    return 0

def ProcessImage(filename, SCRIPT_DIR, prefs):
    # set linux command for jpegtran
    if (islinux and prefs['jpegtran_path'] is not None):
        JPEGLINUX = prefs['jpegtran_path']


    if(filename.lower().endswith('png')):
        # get correct arguments
        if iswindows:
            exe_path = os.path.join(SCRIPT_DIR,'win', 'optipng.exe')
        elif isosx:
            exe_path = os.path.join(SCRIPT_DIR,'osx','optipng')
        else:
            exe_path = 'optipng'
        
        if (islinux and prefs['use_wine']):
            args = ['wine', os.path.join(SCRIPT_DIR,'win', 'optipng.exe')]
        else:
            args = [exe_path]        
        
        args.append("-o7")
        args.append("-q")
        args.append(filename)
    elif (filename.lower().endswith('.jpg') or filename.lower().endswith('.jpeg'))    :
        # get correct arguments
        if iswindows:
            exe_path = os.path.join(SCRIPT_DIR,'win', 'jpegtran.exe')
        elif isosx:
            exe_path = os.path.join(SCRIPT_DIR,'osx','jpegtran')
        else:
            exe_path = 'jpegtran'
                
        if (islinux and prefs['use_wine']):
            args = ['wine', os.path.join(SCRIPT_DIR,'win', 'jpegtran.exe')]
        else:
            args = [exe_path]        

        args.append("-optimize")
        args.append("-progressive")
        args.append("-copy")
        args.append("none")
        args.append("-outfile")
        args.append(filename)
        args.append(filename)
    elif(filename.lower().endswith('.gif')):
        # get correct arguments
        if iswindows:
            exe_path = os.path.join(SCRIPT_DIR,'win', 'gifsicle.exe')
        elif isosx:
            exe_path = os.path.join(SCRIPT_DIR,'osx','gifsicle')
        else:
            exe_path = 'gifsicle'
                
        if (islinux and prefs['use_wine']):
            args = ['wine', os.path.join(SCRIPT_DIR,'win', 'gifsicle.exe')]
        else:
            args = [exe_path]        

        args.append("-O2")
        args.append(filename)

    # run optimizers
    result = OptiWrapper(*args)

    if result > 0:
        return -1

def main():
    print ('I reached main when I should not have\n')
    return -1


if __name__ == '__main__':
    sys.exit(main())
