#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import unicode_literals, division, absolute_import, print_function

try:
    from sigil_bs4 import BeautifulSoup
except:
    from bs4 import BeautifulSoup
import sys, urllib
import xml.etree.ElementTree as ET
import socket

# stolen from DiapDealer :-)
def is_connected():
    try:
        sock = socket.create_connection(('8.8.8.8', 53), 1)
        sock.close()
        return True
    except:
        pass

    return False

PY2 = sys.version_info[0] == 2

if PY2:
    from Tkinter import Tk, BOTH, StringVar, IntVar, BooleanVar 
    from ttk import Frame, Button, Style, Label, Entry, Checkbutton
else:
    from tkinter import Tk, BOTH, StringVar, IntVar, BooleanVar 
    from tkinter.ttk import Frame, Button, Style, Label, Entry, Checkbutton

import re, os, inspect
iswindows = sys.platform.startswith('win')

def int_to_roman(input):
    """ Convert an integer to a Roman numeral. """

    if not isinstance(input, type(1)):
        raise TypeError("expected integer, got %s" % type(input))
    if not 0 < input < 4000:
        raise ValueError("Argument must be between 1 and 3999")
    ints = (1000, 900,  500, 400, 100,  90, 50,  40, 10,  9,   5,  4,   1)
    nums = ('M',  'CM', 'D', 'CD','C', 'XC','L','XL','X','IX','V','IV','I')
    result = []
    for i in range(len(ints)):
        count = int(input / ints[i])
        result.append(nums[i] * count)
        input -= ints[i] * count
    return ''.join(result)

class Dialog(Frame):
    global parameters
    parameters = {}

    def __init__(self, parent):
        # display the dialog box
        Frame.__init__(self, parent)   
        self.parent = parent
        self.initUI()

    def savevalues(self):
        # save dialog box values in dictionary
        if self.tag.get() != '':
            parameters['tag'] = self.tag.get()
        if self.attribute.get() != '':
            parameters['attribute'] = self.attribute.get()
        if self.value.get() != '':
            parameters['value'] = self.value.get()
        parameters['id'] = self.id.get()
        parameters['counter'] = self.counter.get()
        parameters['roman'] = self.UseRomanNums.get()
        self.master.destroy()
        
    def initUI(self):
        # define dialog box properties
        self.parent.title("Add IDs")
        self.style = Style()
        # 'winnative', 'vista', 'xpnative' / 'clam', 'alt', 'default', 'classic'
        if iswindows:
            if 'xpnative' in self.style.theme_names():
                self.style.theme_use('xpnative')
            else:
                self.style.theme_use('default')
        else:
            self.style.theme_use('default')
        self.pack(fill=BOTH, expand=1)

        # tag (mandatory)
        tagLabel = Label(self, text="Tag: ")
        tagLabel.place(x=10, y=10)
        self.tag=StringVar(None)
        tagEntry=Entry(self, textvariable=self.tag)
        tagEntry.place(x=70, y=10)
        # tag attribute (optional)
        attributeLabel = Label(self, text="Attribute: ")
        attributeLabel.place(x=10, y=30)
        self.attribute=StringVar(None)
        attributeEntry=Entry(self, textvariable=self.attribute)
        attributeEntry.place(x=70, y=30)
        # tag attribute value (optional)
        valueLabel = Label(self, text="Value: ")
        valueLabel.place(x=10, y=50)
        self.value=StringVar(None)
        valueEntry=Entry(self, textvariable=self.value)
        valueEntry.place(x=70, y=50)
        # id (mandatory)
        idLabel = Label(self, text="ID: ")
        idLabel.place(x=10, y=70)
        self.id=StringVar(None)
        self.id.set("id")
        idEntry=Entry(self, textvariable=self.id)
        idEntry.place(x=70, y=70)
        # counter (mandatory)
        counterLabel = Label(self, text="Counter: ")
        counterLabel.place(x=10, y=90)
        self.counter=IntVar(None)
        self.counter.set(1)
        counterEntry=Entry(self, textvariable=self.counter)
        counterEntry.place(x=70, y=90)
        # Use Roman numerals check button
        self.UseRomanNums=BooleanVar(None)
        self.UseRomanNums.set(False)
        romanCheckbutton = Checkbutton(self, text="Use Roman numerals", variable=self.UseRomanNums)
        romanCheckbutton.place(x=70, y=115)
        # OK and Cancel buttons
        cancelButton = Button(self, text="Cancel", command=self.quit)
        cancelButton.place(x=120, y=140)
        okButton = Button(self, text="OK", command=self.savevalues)
        okButton.place(x=20, y=140)

def run(bk):
    
    # set Tk parameters for dialog box
    root = Tk()
    root.geometry("220x180+300+300")
    # get plugin path (/sigil-ebook/sigil/plugins/)
    if iswindows:
        icon_path = os.path.join(bk._w.plugin_dir, 'AddIDs', 'app.ico')
        root.wm_iconbitmap(icon_path)
    app = Dialog(root)
    root.mainloop()
    
    if parameters and len(parameters) > 2 and 'tag' in parameters:
        # get tag value
        tag = re.sub('[<|>| ]', '', parameters['tag']) 

        # get attribute and value
        if 'attribute' in parameters and 'value' in parameters:
            attribute = parameters['attribute'].strip()
            value = parameters['value'].strip()
        else:
            attribute = None
            value = None

        # get id and counter values
        id = parameters['id'].strip() 
        counter = int(parameters['counter'] ) - 1
        initial_counter = counter      
       
        # select files to be processed
        selected_files = []
        for file_name in list(bk.selected_iter()):
            if bk.id_to_mime(file_name[1]) == 'application/xhtml+xml':
                selected_files.append((file_name[1], bk.id_to_href(file_name[1]))) 
                
        all_files = list(bk.text_iter())

        if selected_files != []:
            print('Processing only selected files...\n')
            file_list = selected_files
        else:
            print('Processing all files...\n')
            file_list = all_files
        
        # process file list
        for (html_id, href) in file_list:
            html = bk.readfile(html_id)
            
            # load html code into BeautifulSoup
            soup = BeautifulSoup(html)
            orig_soup = str(soup)
            
            # search by tag, attribute and value
            if tag and attribute and value:
                all_tags = soup.find_all(tag, {attribute : value})
            # search only by tag
            else:
                all_tags = soup.findAll(tag)

            # process matches
            for index, each_tag in enumerate(all_tags, start = 1):
                counter += 1
                if parameters['roman']:
                    each_tag['id'] = id + int_to_roman(counter)
                else:
                    each_tag['id'] = id + str(counter)
            
            # update html if the code was changed
            if str(soup) != orig_soup:
                if PY2:
                    try:
                        bk.writefile(html_id, str(soup.prettyprint_xhtml(indent_level=0, eventual_encoding="utf-8", formatter="minimal", indent_chars="  ").encode('utf-8')))
                    except:
                        bk.writefile(html_id, str(soup.encode('utf-8')))
                else:
                    try:
                        bk.writefile(html_id, str(soup.prettyprint_xhtml(indent_level=0, eventual_encoding="utf-8", formatter="minimal", indent_chars="  ")))
                    except:
                        bk.writefile(html_id, str(soup))
                print(href + ' updated')
        
        if counter:
            print('\n', counter - initial_counter, ' matching tags found.')
        else:
            print('Tag \'' + tag + '\' and/or attribute/value not found.')
        
    # no values entered in dialog box
    else:
        print('No values selected.')
    
    if is_connected():    
        # run plugin version check
        href = 'http://www.mobileread.com/forums/showpost.php?p=3184441&postcount=1'
        _latest_pattern = re.compile(r'Current Version:\s*&quot;([^&]*)&')
        plugin_xml_path = os.path.abspath(os.path.join(bk._w.plugin_dir, 'AddIDs', 'plugin.xml'))
        plugin_version = ET.parse(plugin_xml_path).find('.//version').text
        try:
            latest_version = None
            if PY2:
                response = urllib.urlopen(href)
            else:
                response = urllib.request.urlopen(href)
            m = _latest_pattern.search(response.read().decode('utf-8', 'ignore'))
            if m:
                latest_version = (m.group(1).strip())
                if latest_version and latest_version != plugin_version:
                    print('\n*************************************************\n* An updated plugin version is available: v' + latest_version + ' *\n*************************************************')
        except:
            pass   
        
    print('\nPlease click OK to close the Plugin Runner window.')
    
    return 0


def main():
    print('I reached main when I should not have\n')
    return -1

if __name__ == "__main__":
    sys.exit(main())
