#!/usr/bin/env python
# -*- coding: utf-8 -*-

from __future__ import with_statement

__license__ = 'GPL v3'

# Standard Python modules.
import os, traceback, json

# PyQT4 modules (part of calibre).
try:
    from PyQt5.Qt import (Qt, QWidget, QGridLayout, QHBoxLayout, QVBoxLayout, QLabel, QLineEdit,
                      QGroupBox, QPushButton, QListWidget, QListWidgetItem, QTextEdit,
                      QAbstractItemView, QIcon, QDialog, QDialogButtonBox, QUrl)
except ImportError:
    from PyQt4.Qt import (Qt, QWidget, QGridLayout, QHBoxLayout, QVBoxLayout, QLabel, QLineEdit,
                      QGroupBox, QPushButton, QListWidget, QListWidgetItem, QTextEdit,
                      QAbstractItemView, QIcon, QDialog, QDialogButtonBox, QUrl)
try:
    from PyQt5 import Qt as QtGui
except ImportError:
    from PyQt4 import QtGui
    
from zipfile import ZipFile

# calibre modules and constants.
from calibre.gui2 import (error_dialog, question_dialog, info_dialog, open_url,
                            choose_dir, choose_files, choose_save_file)
from calibre.utils.config import dynamic, config_dir, JSONConfig
from calibre.constants import iswindows, isosx
# modules from this plugin's zipfile.
from calibre_plugins.getfilename.__init__ import PLUGIN_NAME, PLUGIN_VERSION

from calibre_plugins.getfilename.common_utils import (KeyboardConfigDialog, PrefsViewerDialog)

import calibre_plugins.getfilename.prefs as prefs

PREFS_NAMESPACE = 'GetFileNamePlugin'

class ConfigWidget(QWidget):
	def __init__(self, actual_plugin):
	
		QWidget.__init__(self)

		#actual_plugin = 'calibre_plugins.getfilename.action:GetFileNameAction'
		self.plugin_action = actual_plugin
        #self.alfdir = alfdir

        # get the prefs
		self.dedrmprefs = prefs.GetFileName_Prefs()

		self.filename_col = self.dedrmprefs['nom_col']

        # Start Qt Gui dialog layout
		layout = QVBoxLayout(self)
		self.setLayout(layout)
		
		self.nom_fich = ''
		
        # --- File ---
		filename_group_box = QGroupBox(_('File name options:'), self)
		layout.addWidget(filename_group_box)
		filename_group_box_layout = QGridLayout()
		filename_group_box.setLayout(filename_group_box_layout)
		
		#filename_col = '#nar'
		self.fname_column_text = QTextEdit (self)
		self.fname_column_text.setTabStopWidth (24)
		self.fname_column_text.setReadOnly (False)
		self.fname_column_text.setText (self.filename_col)
        #avail_columns_text = self.get_custom_columns_text()
        #self.des_column_combo = CustomColumnComboBox(self, avail_columns_text,self.filename_col)
	
		fname_column_label = QLabel(_('&Custom column:'), self)
		fname_column_label.setToolTip(_('Custom text column for storing the filename'))
		fname_column_label.setBuddy (self.fname_column_text)
		
		filename_group_box_layout.addWidget(fname_column_label, 0, 0, 1, 1)
		filename_group_box_layout.addWidget(self.fname_column_text, 0, 1, 1, 2)
		
		layout.addStretch(1)
		self.resize(self.sizeHint())
		

	def save_settings(self):
		self.dedrmprefs.set('nom_col', self.fname_column_text.toPlainText())
		self.dedrmprefs.set('configured', True)
		self.dedrmprefs.writeprefs()
		
    def get_custom_columns_text(self):
		from calibre.library import db
		
        current = os.path.normcase(os.path.abspath(db.library_path))

        column_types = ['text','enumeration','custom']
        custom_columns = self.plugin_action.gui.library_view.model().custom_columns
        available_columns = {}
        for key, column in custom_columns.iteritems():
            typ = column['datatype']
            if typ in column_types:
                available_columns[key] = column
        return available_columns

	
