#!/usr/bin/env python
# -*- coding: utf-8 -*-

from __future__ import with_statement
__license__   = 'GPL v3'
__docformat__ = 'restructuredtext en'


# Configuration:
# Check out the plugin's configuration settings by clicking the "Customize plugin"
# button when you have the "GetFileName" plugin highlighted (under Preferences->
# Plugins->File type plugins). Once you have the configuration dialog open, you'll
# see a Help link on the top right-hand side.
#
# Revision history:
#   0.0.1 - Initial release

"""
Store the filename.
"""

PLUGIN_NAME = u"GetFileName"
PLUGIN_VERSION_TUPLE = (0, 0, 2)
PLUGIN_VERSION = u".".join([unicode(str(x)) for x in PLUGIN_VERSION_TUPLE])
# Include an html helpfile in the plugin's zipfile with the following name.

import sys, os, re
import time
import zipfile
import traceback
from zipfile import ZipFile

class GetFileNameError(Exception):
    pass

from calibre.customize import FileTypePlugin
from calibre.constants import iswindows, isosx
from calibre.gui2 import is_ok_to_use_qt
from calibre.utils.config import config_dir


class GetFileName(FileTypePlugin):
	name                    = PLUGIN_NAME
	description             = u"Store the filename of the imported book in a custom column"
	supported_platforms     = ['linux', 'osx', 'windows']
	author                  = u"Anonimo"
	version                 = PLUGIN_VERSION_TUPLE
	minimum_calibre_version = (2, 0, 0)  # Qt5.
	file_types              = set(['epub','pdf','pdb','prc','mobi','azw','azw1','azw3','azw4','tpz','lit'])
	on_import               = False
	on_postimport			= True
	priority                = 700
	
	list_fich               = {}

	actual_plugin           = 'calibre_plugins.getfilename.action:GetFileNameAction'

    #def initialize(self):
    #    # convert old preferences, if necessary.
    #    try:
	#		self.nom_fich = ""
    #    except:
    #        traceback.print_exc()
	
	def run(self, path_to_ebook):
		global list_fich
		from calibre.ebooks.metadata.meta import get_metadata

		print "GetFileName::run(%s)" % path_to_ebook

		file = open(path_to_ebook, 'r+b')
		ext  = os.path.splitext(path_to_ebook)[-1][1:].lower()
		mi = get_metadata (file, ext)
		ind = mi.title + mi.authors[0]
		print "GetFileName::author (%s)" % ind
		nom_fich = os.path.basename(path_to_ebook)
		list_fich.update ({ind: nom_fich})
		print "KeysR: ", list_fich.keys ()
		
		print "GetFileType::run-fich(%s)" % nom_fich
		return path_to_ebook
		
	def postimport( self, book_id, book_format, db):
		#global list_fich
		import calibre_plugins.getfilename.prefs as prefs

		print "GetFileName::postimport"

		self.prefs = prefs.GetFileName_Prefs()
		nom_col = self.prefs['nom_col']
		# nom_fich = 'aux'
		
		#miA = db.get_metadata (book_id, index_is_id=True, get_cover=False) # Mirar con db.field
		#title = miA.get ('title')
		#author = miA.get ('author')
		#author = db.field_for ('authors', book_id)
		#print "author_ori: ", author
		#author1 = miA.get ('authors')
		#ind = title + author1[0]
		print "Nom col: ", nom_col
		#print "ind: ", ind
		#print "Keys: ", list_fich.keys ()
		#nom_fich = list_fich[ind]
		#print "Nom fich: ", nom_fich
		
		#db.new_api.set_field(nom_col, {book_id:nom_fich})
		
	def postadd (self, book_id, fmt_map, db):
		import calibre_plugins.getfilename.prefs as prefs

		print "GetFileName::postadd"

		self.prefs = prefs.GetFileName_Prefs()
		nom_col = self.prefs['nom_col']
		
		print nom_col
		
		nom_fich = ''
		for fmt, file in fmt_map:
			nom_fich = file
			
		print nom_fich
		
		db.new_api.set_field(nom_col, {book_id:nom_fich})	
		
	def is_customizable(self):
        # return true to allow customization via the Plugin->Preferences.
		return True
		
	def config_widget(self):
		import calibre_plugins.getfilename.config as config
		return config.ConfigWidget(self.actual_plugin)
		
	def save_settings(self, config_widget):
		config_widget.save_settings()
