from threading import Thread, Event
from calibre.gui2 import gprefs
from calibre.gui2.auto_add import AUTO_ADDED, allowed_formats
from tempfile import NamedTemporaryFile
import os, stat

class Unblocker(Thread):
    #
    # The time in seconds between checks for files to process
    #
    loopDelay = 10 * 60
    
    def __init__(self):
        Thread.__init__(self)
        self.daemon = True
        self.keepRunning = True
        self.signaller = Event()

    def run(self):
        while self.keepRunning:
            try:
                gotFiles = False
                autodir  = gprefs['auto_add_path']
                addlist  = allowed_formats()
                for file in os.listdir(autodir):
                    name, ext = os.path.splitext(file)
                    if ext.lstrip('.') in addlist:
                        path = os.path.join(autodir,file)
                        os.chmod(path,stat.S_IWRITE|stat.S_IREAD)
                        print 'Auto-add unblocker: processed \"%s\"' % file
                        gotFiles = True
                if gotFiles:
                    #
                    # Create and delete a file in the auto-add directory to signal
                    # the auto-adder. Something needs to be written to the file to
                    # make the auto-adder notice it.
                    #
                    tmp = NamedTemporaryFile(dir=autodir)
                    print 'Auto-add unblocker: using file %s to signal auto-adder' % tmp.name
                    tmp.write('\n')
                    tmp.close()
            except:
                pass
            self.signaller.wait(self.loopDelay)

    def stop(self):
        self.keepRunning = False
        self.signaller.set()
