#!/usr/bin/zsh
dir="/mnt/us/extensions/kindlevncviewer"
clear
zmodload zsh/curses
zcurses init
zcurses addwin poop 8 40 6 4 
zcurses border poop 
zcurses bg poop black/blue 
zcurses move poop 2 2
zcurses string poop "Enter password:" 
zcurses attr poop red/yellow
zcurses move poop 4 7 
zcurses string poop "┌────────┐"
zcurses move poop 5 7
zcurses string poop "│ cancel │" 
zcurses move poop 6 7
zcurses string poop "└────────┘"
zcurses move poop 4 23
zcurses string poop "┌─────────┐"             
zcurses move poop 5 23 
zcurses string poop "│ connect │"             
zcurses move poop 6 23
zcurses string poop "└─────────┘" 
zcurses move poop 2 20
zcurses attr poop yellow/black
zcurses string poop "                   "

zcurses move poop 2 20 
zcurses refresh poop

while [[ true ]] {
	zcurses input poop keyscan keypad mouse
	
	zcurses char poop "*"
 
	if [[ "$keypad" == "MOUSE" ]]; then 
		if [ $mouse[3] -ge 10 ] && [ $mouse[3] -le 14 ]; then 
			if [ $mouse[2] -ge 11 ] && [ $mouse[2] -le 20 ]; then 
				password="ABORTED"
				break
			elif [ $mouse[2] -ge 27 ] && [ $mouse[2] -le 37 ]; then
				break
			fi
		fi		
	fi
	if [[ $keyscan == $'\n' ]] {break}
	if [[ $(hexdump -e '"%X"' <<< "$keyscan") == "A1B" ]] {
		password="ABORTED"
		break
		}
	
	if [ -n "$keyscan" ]; then                                      
	       i=$(( $i + 1 ))                                         
	fi                                                              
	                               

	if [[ $(hexdump -e '"%X"' <<< "$keyscan") != "A7F" ]]; then 
		password=$password$keyscan
	else
		i=$(( $i - 2 ))
		password=`expr substr $password 1 $(( $i ))`
		zcurses move poop 2 $(( 20 + $i  ))
		zcurses char poop " "
		zcurses move poop 2 $(( 20 + $i ))
	fi                          

}

zcurses delwin poop
zcurses end
#echo password $password
#echo i $i
#echo lines $LINES
#echo col $COLUMNS
#echo mouse $mouse
#echo mousex $mouse[2]
#echo mousey $mouse[3]
#sleep 5 

echo $password > $dir/tmp/password

