'Place this script under the root directory of your Kindle device. 
'I take no responsibility directly or indirectly relating to the loss that may occure. Use at your own risk

'Declare variables
Option Explicit
Dim mode '1: Rename, 2: Restore
Dim objFSO, objShell
Dim strPath, strDrive

'User select operation mode
Dim bullet
bullet = Chr(10) & "   " & Chr(149) & " "
Do
    mode = InputBox("Please enter the number that corresponds to your selection:" & Chr(10) & bullet & "1.) Rename" & bullet & "2.) Restore" & bullet & "3.) Exit" & Chr(10), "Alternative Kindle Collection, Searching by Renaming")
    If mode = "" Then WScript.Quit  'Detect Cancel
    If IsNumeric(mode) Then Exit Do 'Detect value response.
    MsgBox "You must enter a numeric value.", 48, "Invalid Entry"
Loop
If mode = 3 or mode > 3 Then 
  Wscript.echo "Exit, done nothing"
  WScript.Quit  'Detect Cancel
End If  

'Determine the current drive letter
Set objFSO = CreateObject("Scripting.FileSystemObject")
Set objShell = CreateObject("Wscript.Shell")

strPath = objShell.CurrentDirectory
strDrive = objFSO.GetDriveName(strPath)

'Obtain the subdirectories under documents, dparh: full path to documents folder, fsub: each subfolder under documents
Dim  dpath, dsubfolders, fsub, currentfolder, bookfile, files, oldname, newname, count
Set dpath = objFSO.GetFolder(strDrive&"\documents")
Set dsubfolders = dpath.SubFolders

count = 0

'Loop through each subfolder
For Each fsub in dsubFolders
         
        'Process Individual book files
        Set currentfolder = objFSO.GetFolder(dpath & "\" & fsub.name)
        Set files = currentfolder.Files
        For each bookfile in files
          
          oldname = strDrive & "\documents\" &  fsub.name & "\" & bookfile.name
          If mode = 1 Then 'Rename by appending subfoldername
          
            'Skip the files that have been renamed already       
            If Mid(bookfile.name, 1, Len(fsub.name)) <> fsub.name Then
                newname = strDrive & "\documents\" &  fsub.name & "\" & fsub.name & "." & bookfile.name
                objFSO.MoveFile oldname, newname
                count = count + 1
            End If
            
          Else 'Restore by removing subfoldername
            
             'Skip the files that haven't been renamed previously
             If Mid(bookfile.name, 1, Len(fsub.name)) = fsub.name Then
                  newname = strDrive & "\documents\" &  fsub.name & "\" & Mid(bookfile.name, Len(fsub.name)+2, Len(bookfile.name)) 
                  objFSO.MoveFile oldname, newname
                  count = count + 1
             End If
          End If
          
          
        
        Next  
Next

' Finish
If mode = 1 Then
   wscript.echo "Completed successfully, " & Count & " files renamed!"
Else
   wscript.echo "Completed successfully, " & Count & " files restored!"
End If

Wscript.Quit