#!/usr/bin/env python
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai
from __future__ import (unicode_literals, division, absolute_import,
                    print_function)

__license__   = 'GPL v3'
__copyright__ = '2015, Terisa de Morgan <terisam@gmail.com>'
__docformat__ = 'restructuredtext en'

import copy, os

try:
    from PyQt5 import QtWidgets as QtGui
    from PyQt5.Qt import (Qt, QWidget, QGridLayout, QLabel, QPushButton, QUrl,
                      QGroupBox, QComboBox, QVBoxLayout, QCheckBox, QTabWidget,
                      QLineEdit, QHBoxLayout, QToolButton)
except ImportError:
    from PyQt4 import QtGui
    from PyQt4.Qt import (QWidget, QGridLayout, QLabel, QPushButton, QUrl,
                      QGroupBox, QComboBox, QVBoxLayout, QCheckBox, QTabWidget,
                      QLineEdit)

from calibre.gui2 import open_url, choose_dir
from calibre.utils.config import JSONConfig
from calibre.gui2.widgets import HistoryLineEdit

from calibre_plugins.my_tools.common_utils import (get_library_uuid, CustomColumnComboBox, ChooseLibrary,
                                 get_icon, KeyboardConfigDialog, KeyValueComboBox, PrefsViewerDialog, debug_print,
								 ImageTitleLayout)

try:
    debug_print("MyTools::config.py - loading translations")
    load_translations()
except NameError:
    debug_print("MyTools::config.py - exception when loading translations")
    pass # load_translations() added in calibre 1.9								 
								 
PREFS_NAMESPACE = 'MyToolsPlugin'
PREFS_KEY_SETTINGS = 'settings'

ConfMetadata="confMetadata"
ConfSeries="confSeries"
ConfReread="confReread"
ConfConversion="confConversion"
ConfConverted="confConverted"
ConfMark="confMark"
ConfChallenge="confChallenge"
ConfTools="confTools"
ConfBiblio="confBiblio"

READ_IN_SERIES_CUSTOM_COLUMN = 'customColumnReadInSeries'
NON_READ_IN_SERIES_CUSTOM_COLUMN = 'customColumnNonReadInSeries'
NEXT_IN_SERIES_CUSTOM_COLUMN = 'customColumnNextInSeries'
READ_CUSTOM_COLUMN = 'customColumnRead'
UPD_CUSTOM_COLUMN = 'customColumnUpd'

NRL_CUSTOM_COLUMN = 'customColumnNumRereads'
FLE_CUSTOM_COLUMN = 'customColumnFechaLect'
FICH_RELEC = 'fichLibraryRelec'

COL_CONV = 'customColumnConv'
FICH_CONV = 'fichLibraryConv'
COL_NREAD = 'customColumnNextRead'
FICH_DEV = 'fichLibraryDevice'

COL_GOO = 'customColumnGood'
COL_PAG = 'customColumnPag'
COL_PER = 'customColumnPer'

COL_ORI = 'customColumOri'
FICH_ADQ = 'fichAdquisic'

COL_DES = 'customColumnDes'
FICH_DES = 'fichLibraryDes'

OPT_CONVERSION = 'optConversion'
OPT_MAIN = 'optMain'
OPT_METADATA = 'optMetadata'
OPT_REGISTER = 'optRegister'

READ= 'read'
NONREAD = 'nonread'
NEXT = 'next'
STATUS = 'status'
UPD = 'updated'

NRL = 'num_rereads'
FLE = 'date_lect'
LREL = 'libRelec'

CONV = 'conv'
LCON = 'libConv'
NREAD = 'nRead'
LDEV = 'libDev'

PAG = 'pag'
GOO = 'goodreads'
PER = 'percentage'

ORI = 'origin'
LADQ = 'libAdq'

LREG = 'libReg'
FICH_REG = 'fichLibraryReg'

DES='des'
LDES='libDes'

OMC='OMC'
OME='OME'
OMM='OMM'
OMR='OMR'

CONF_FUNCTION = {ConfSeries: { 
    READ: READ_IN_SERIES_CUSTOM_COLUMN,
    NONREAD: NON_READ_IN_SERIES_CUSTOM_COLUMN,
    NEXT: NEXT_IN_SERIES_CUSTOM_COLUMN,
    STATUS: READ_CUSTOM_COLUMN,
    UPD: UPD_CUSTOM_COLUMN
    },
	ConfReread: { 
    NRL: NRL_CUSTOM_COLUMN,
    FLE: FLE_CUSTOM_COLUMN,
    LREL: FICH_RELEC
    },
	ConfConversion: { 
    CONV: COL_CONV,
    LCON: FICH_CONV
    },
	ConfMark: {
	CONV: COL_CONV,
	PAG: COL_PAG,
	LCON: FICH_CONV
	},
	ConfMetadata: { 
    PAG: COL_PAG,
    GOO: COL_GOO,
    PER: COL_PER
    },
	ConfConverted: {
        CONV: COL_CONV,
        LREG: FICH_REG,
		PAG: COL_PAG,
		NREAD: COL_NREAD,
		LDEV: FICH_DEV		
    },
	ConfChallenge: {
		DES: COL_DES,
		LREG: FICH_REG,
		LDES: FICH_DES
	},
	ConfBiblio: {
		ORI: COL_ORI,
		LADQ: FICH_ADQ
	},
	ConfTools: {
		OME: OPT_METADATA,
		OMR: OPT_REGISTER,
		OMC: OPT_CONVERSION,
		OMM: OPT_MAIN
		}
	}
	
ConfDir = {
	LCON: FICH_CONV,
	LDES: FICH_DES,
	LDEV: FICH_DEV,
	LREG: FICH_REG,
	LREL: FICH_RELEC,
	LADQ: FICH_ADQ
	}

FICH_NAME = 'Libraries'

DEFAULT_FICH_VALUES = {
                    FICH_CONV: 'D:/Biblioteca Kindle/Conversiones',
                    FICH_RELEC: 'D:/Biblioteca Kindle/Relecturas',
                    FICH_REG: 'D:/Biblioteca Kindle/Mi Registro',
					FICH_DES: 'D:/Biblioteca Kindle/Desafios',
					FICH_DEV: 'D:/dropbox-moretta/Dropbox/Libros',
					FICH_ADQ: 'D:/Biblioteca Kindle/Adquisiciones',
                    }
DEFAULT_LIBRARY_VALUES = { READ_IN_SERIES_CUSTOM_COLUMN: '',
                       NON_READ_IN_SERIES_CUSTOM_COLUMN: '',
                       NEXT_IN_SERIES_CUSTOM_COLUMN: '',
                       READ_CUSTOM_COLUMN: '',
                       UPD_CUSTOM_COLUMN: '',
                       NRL_CUSTOM_COLUMN: '',
                       FLE_CUSTOM_COLUMN: '',
                       COL_CONV: '',
					   COL_NREAD: '',
                       COL_PAG: '',
                       COL_GOO: '',
                       COL_PER: '',
					   COL_DES: '',
					   COL_ORI: '',
					   OPT_CONVERSION: False,
					   OPT_MAIN: False,
					   OPT_METADATA: False,
					   OPT_REGISTER: False
                       }

KEY_SCHEMA_VERSION = 'SchemaVersion'
DEFAULT_SCHEMA_VERSION = 1.61

# This is where all preferences for this plugin will be stored
plugin_prefs = JSONConfig('plugins/My Tools')

# Set defaults
plugin_prefs.defaults[FICH_NAME] = DEFAULT_FICH_VALUES

def get_library_config(db):
    library_id = get_library_uuid(db)
    library_config = None

    if library_config is None:
        library_config = db.prefs.get_namespaced(PREFS_NAMESPACE, PREFS_KEY_SETTINGS,
                                             copy.deepcopy(DEFAULT_LIBRARY_VALUES))
    return library_config

def set_library_config(db, library_config):
    db.prefs.set_namespaced(PREFS_NAMESPACE, PREFS_KEY_SETTINGS, library_config)

class ConfigWidget(QWidget):

    def __init__(self, plugin_action):
        QWidget.__init__(self)
        self.plugin_action = plugin_action
        layout = QVBoxLayout(self)
        self.setLayout(layout)
		
		title_layout = ImageTitleLayout(self, 'images/tools.png', _('MyTools Options'))
		layout.addLayout(title_layout)
		
        tab_widget = QTabWidget(self)
        layout.addWidget(tab_widget)
        self.common_tab = QtGui.QWidget()
        self.register_tab = QtGui.QWidget()
        self.other_tab = QtGui.QWidget()
		
		common_layout = QtGui.QVBoxLayout()
		register_layout = QtGui.QVBoxLayout()
		other_layout = QtGui.QVBoxLayout()

        l = plugin_prefs[FICH_NAME]
		avail_columns = {}
		avail_columns['FLOAT'] = self.get_custom_columns_float()
		avail_columns['INTEGER'] = self.get_custom_columns_integer()
		avail_columns['TEXT'] = self.get_custom_columns_text()
		avail_columns['DATE'] = self.get_custom_columns_date()
        library_config = get_library_config(self.plugin_action.gui.current_db)
		
		list_fich = {}
		for fich, default in DEFAULT_FICH_VALUES.iteritems ():
			list_fich[fich] = l.get (fich, default)
		
		self.location = {}
		self.combos = {}
		self.options = {}

    # --- Register ---
	
		register_layout.addWidget (self.createMetadataGroupBox(library_config, avail_columns))

		register_layout.addWidget (self.createSeriesGroupBox (library_config, avail_columns))
		register_layout.addWidget (self.createRereadsGroupBox (library_config, avail_columns, list_fich))
		register_layout.addWidget (self.createLibraryGroupBox (library_config, avail_columns, list_fich))

    # --- Other ---
	
		other_layout.addWidget (self.createConversionGroupBox (library_config, avail_columns, list_fich))															
		other_layout.addWidget (self.createChallengesGroupBox (library_config, avail_columns, list_fich))

    # --- Other options ---
        
		# common_layout.addSpacing(5)
		
		common_layout.addWidget (self.createCommonGroupBox (library_config, avail_columns, list_fich))
		common_layout.addWidget (self.createOptionsGroupBox (library_config))
		
        keyboard_shortcuts_button = QPushButton('Keyboard shortcuts...', self)
        keyboard_shortcuts_button.setToolTip(_(
                    'Edit the keyboard shortcuts associated with this plugin'))
        keyboard_shortcuts_button.clicked.connect(self.edit_shortcuts)
        common_layout.addWidget(keyboard_shortcuts_button)
        view_prefs_button = QPushButton('&View library preferences...', self)
        view_prefs_button.setToolTip(_(
                    'View data stored in the library database for this plugin'))
        view_prefs_button.clicked.connect(self.view_prefs)
        common_layout.addWidget(view_prefs_button)
		
		common_layout.addStretch(0)
		register_layout.addStretch(0)
		other_layout.addStretch(0)
		
		self.common_tab.setLayout (common_layout)
		self.register_tab.setLayout (register_layout)
		self.other_tab.setLayout (other_layout)
		
		tab_widget.addTab(self.common_tab, _('Common'))
        tab_widget.addTab(self.register_tab, _('Register'))
        tab_widget.addTab(self.other_tab, _('Other options'))


    def save_settings(self):

        new_prefs_fich = {}
		
		for fich, text_direc in self.location.iteritems ():
			new_prefs_fich[fich] = text_direc.text ()

        plugin_prefs[FICH_NAME] = new_prefs_fich

        db = self.plugin_action.gui.current_db
        library_config = get_library_config(db)
		
		for column, combo in self.combos.iteritems ():
			library_config[column] = combo.get_selected_column ()

		library_config[READ_IN_SERIES_CUSTOM_COLUMN] = self.read_column_combo.get_selected_column()
        library_config[NON_READ_IN_SERIES_CUSTOM_COLUMN] = self.nonread_column_combo.get_selected_column()
        library_config[NEXT_IN_SERIES_CUSTOM_COLUMN] = self.next_column_combo.get_selected_column()
        library_config[READ_CUSTOM_COLUMN] = self.status_column_combo.get_selected_column()
        library_config[UPD_CUSTOM_COLUMN] = self.updated_column_combo.get_selected_column()
        library_config[COL_CONV] = self.conv_column_combo.get_selected_column()
        library_config[COL_NREAD] = self.nread_column_combo.get_selected_column()
        library_config[COL_PAG] = self.pag_column_combo.get_selected_column()
        library_config[COL_GOO] = self.good_column_combo.get_selected_column()
        library_config[COL_PER] = self.per_column_combo.get_selected_column()
        library_config[COL_DES] = self.des_column_combo.get_selected_column()
		
		for type, checkbox in self.options.iteritems ():
			library_config[type] = checkbox.isChecked ()
			
        set_library_config(db, library_config)

    def get_custom_columns_float(self):
        column_types = ['float']
        custom_columns = self.plugin_action.gui.library_view.model().custom_columns
        available_columns = {}
        for key, column in custom_columns.iteritems():
            typ = column['datatype']
            if typ in column_types:
                available_columns[key] = column
        return available_columns

    def get_custom_columns_integer(self):
        column_types = ['int']
        custom_columns = self.plugin_action.gui.library_view.model().custom_columns
        available_columns = {}
        for key, column in custom_columns.iteritems():
            typ = column['datatype']
            if typ in column_types:
                available_columns[key] = column
        return available_columns

    def get_custom_columns_text(self):
        column_types = ['text','bool','enumeration','composite']
        custom_columns = self.plugin_action.gui.library_view.model().custom_columns
        available_columns = {}
        for key, column in custom_columns.iteritems():
            typ = column['datatype']
            if typ in column_types:
                available_columns[key] = column
        return available_columns

    def get_custom_columns_date(self):
        column_types = ['datetime']
        custom_columns = self.plugin_action.gui.library_view.model().custom_columns
        available_columns = {}
        for key, column in custom_columns.iteritems():
            typ = column['datatype']
            if typ in column_types:
                available_columns[key] = column
        return available_columns

    def _link_activated(self, url):
        open_url(QUrl(url))

    def createConversionGroupBox(self, library_config, avail_columns, list_fich):
        conversion_group_box = QGroupBox(_('Conversion configuration'), self)
        conversion_group_box_layout = QGridLayout()
        conversion_group_box.setLayout(conversion_group_box_layout)
		
        self.nread_column_combo = self.createCombo (_('&Next read custom column:'), _('Book which is going to be sent to the device'), 
													library_config, COL_NREAD, avail_columns['TEXT'], conversion_group_box_layout, 
													0)

        self.location[FICH_DEV] = self.createDirectory(_('&Dev library'), _('Library for coping the books to send to the device'),
													LDEV, list_fich[FICH_DEV], conversion_group_box_layout, 3)

		return conversion_group_box
    
    def createMetadataGroupBox (self, library_config, avail_columns):
        metadata_group_box = QGroupBox(_('Common column configuration'), self)
        metadata_group_box_layout = QGridLayout()
        metadata_group_box.setLayout(metadata_group_box_layout)

        self.pag_column_combo = self.createCombo (_('&Num pag custom column:'), _('Number of page of the book'), 
													library_config, COL_PAG, avail_columns['INTEGER'], 
													metadata_group_box_layout, 0)
        self.good_column_combo = self.createCombo (_('&Goodreads custom column:'), _('Included in goodreads'), 
													library_config, COL_GOO, avail_columns['TEXT'], 
													metadata_group_box_layout, 1)
        self.per_column_combo = self.createCombo (_('&Percentage custom column:'), _('Percentage read of the book'), 
													library_config, COL_PER, avail_columns['INTEGER'], 
													metadata_group_box_layout, 
													2)
		return metadata_group_box
		
	def createSeriesGroupBox (self, library_config, avail_columns):
	    group_box = QGroupBox(_('Series configuration:'), self)
        group_box_layout = QGridLayout()
        group_box.setLayout(group_box_layout)

        self.read_column_combo = self.createCombo(_('&Read in series custom column:'), _('Number of books read in the associated series'),
													library_config, READ_IN_SERIES_CUSTOM_COLUMN, avail_columns['FLOAT'], 
													group_box_layout, 0)

        self.nonread_column_combo = self.createCombo(_('&Non read in series custom column:'), _('Number of books non read in the associated series'),
													library_config, NON_READ_IN_SERIES_CUSTOM_COLUMN, avail_columns['FLOAT'], 
													group_box_layout, 1)

        self.next_column_combo = self.createCombo(_('&Next in series custom column:'), _('Next non-read index in the associated series'),
													library_config, NEXT_IN_SERIES_CUSTOM_COLUMN, avail_columns['FLOAT'], 
													group_box_layout, 2)

        self.status_column_combo = self.createCombo(_('&Read indicator custom column:'), _('Column which sets a book as status / non-status'),
													library_config, READ_CUSTOM_COLUMN, avail_columns['TEXT'], 
													group_box_layout, 3)

        self.updated_column_combo = self.createCombo(_('&Updated custom column:'), _('Column which indicates if the series has been updated'),
													library_config, UPD_CUSTOM_COLUMN, avail_columns['TEXT'], 
													group_box_layout, 4)

		return group_box
		
	def createRereadsGroupBox (self, library_config, avail_columns, list_fich):
	    group_box = QGroupBox(_('Rereads configuration:'), self)
        group_box_layout = QGridLayout()
        group_box.setLayout(group_box_layout)

        self.combos[NRL_CUSTOM_COLUMN] = self.createCombo(_('&Number of readings custom column:'), _('Number of times the book has been read'),
													library_config, NRL_CUSTOM_COLUMN, avail_columns['FLOAT'], 
													group_box_layout, 0)

        self.combos[FLE_CUSTOM_COLUMN] = self.createCombo(_('&Date of reading custom column:'), _('Date of last reading of the book'),
													library_config, FLE_CUSTOM_COLUMN, avail_columns['DATE'], 
													group_box_layout, 1)

        self.location[FICH_RELEC] = self.createDirectory (_('&Reread library'), _('Library for coping the reread books'),
													LREL, list_fich[FICH_RELEC], group_box_layout, 3)
													
		return group_box
    
    def createLibraryGroupBox (self, library_config, avail_columns, list_fich):
        group_box = QGroupBox(_('Library configuration'), self)
        group_box_layout = QGridLayout()
        group_box.setLayout(group_box_layout)

        self.combos[COL_ORI] = self.createCombo (_('&Origin custom column:'), _('Origin of the book'), 
													library_config, COL_ORI, avail_columns['TEXT'], 
													group_box_layout, 0)

        self.location[FICH_ADQ] = self.createDirectory (_('&Original library'), _('Library for coping the books to process'),
													LADQ, list_fich[FICH_ADQ], group_box_layout, 2)
													
		return group_box
		
    def createCommonGroupBox(self, library_config, avail_columns, list_fich):
        group_box = QGroupBox(_('Common configuration'), self)
        group_box_layout = QGridLayout()
        group_box.setLayout(group_box_layout)
		
        self.conv_column_combo = self.createCombo (_('&Conv custom column:'), _('Book which is going to be converted'), 
													library_config, COL_CONV, avail_columns['TEXT'], group_box_layout, 
													0)
        self.location[FICH_CONV] = self.createDirectory (_('&Conv library'), _('Library for coping the books to be converted'),
													LCON, list_fich[FICH_CONV], group_box_layout, 3)
													
        self.location[FICH_REG] = self.createDirectory (_('&Reg library'), _('Library for coping the converted books'),
													LREG, list_fich[FICH_REG], group_box_layout, 4)
		return group_box
    
    def createChallengesGroupBox(self, library_config, avail_columns, list_fich):
        group_box = QGroupBox(_('Challenge configuration'), self)
        group_box_layout = QGridLayout()
        group_box.setLayout(group_box_layout)

        self.des_column_combo = self.createCombo (_('&Challenge custom column:'), _('Challenges the book fit'), 
													library_config, COL_DES, avail_columns['TEXT'], group_box_layout, 
													0)

        self.location[FICH_DES] = self.createDirectory (_('&Challenge library'), _('Library for coping the books included in a challenge'),
													LDES, list_fich[FICH_DES], group_box_layout, 3)
												
		return group_box
		
	def createOptionsGroupBox (self, library_config):
		group_box = QGroupBox(_('Tools availabity options:'), self)
        group_box_layout = QGridLayout()
        group_box.setLayout(group_box_layout)
		
		self.options[OPT_CONVERSION] = self.createCheckbox (library_config, _('Conversion option'), 
													_('Check this option if you want to use the conversion options.'),
													OPT_CONVERSION)
        group_box_layout.addWidget(self.options[OPT_CONVERSION], 1, 0, 1, 2)

        self.options[OPT_REGISTER] = self.createCheckbox(library_config, _('Register option'), 
														_('Check this option if you want to use the register options.'),
														OPT_REGISTER)
        group_box_layout.addWidget(self.options[OPT_REGISTER], 1, 2, 1, 2)

        self.options[OPT_METADATA] = self.createCheckbox(library_config, _('Metadata option'), 
														_('Check this option if you want to use the metadata options.'),
														OPT_METADATA)
        group_box_layout.addWidget(self.options[OPT_METADATA], 2, 0, 1, 2)

        self.options[OPT_MAIN] = self.createCheckbox(library_config, _('Device library option'), 
													_('Check this option if you want to use the device library options.'),
													OPT_MAIN)
        group_box_layout.addWidget(self.options[OPT_MAIN], 2, 2, 1, 2)
		
		return group_box


    
	def createCombo (self, text, tip, library_config, des_col, avail_column, layout, pos):
        label = QLabel(text, self)
        label.setToolTip(tip)
        col = library_config.get(des_col, '')
        column_combo = CustomColumnComboBox(self, avail_column, col)
        label.setBuddy(column_combo)

        layout.addWidget(label, pos, 0, 1, 1)
        layout.addWidget(column_combo, pos, 1, 1, 2)

		return column_combo
		
	def createDirectory (self, text, tip, direc, file, layout, pos):
        label = QLabel(text, self)
        label.setToolTip(tip)
		
        button = QToolButton (self)
        button.setIcon(get_icon('document_open.png'))
        button.clicked.connect(lambda: self._choose_location (direc))

        directory = HistoryLineEdit (self) 
        directory.initialize ('my_tools_plugin:library_duplicate_combo')
        directory.setText(file)

        layout.addWidget (label, pos, 0)
        layout.addWidget (directory, pos, 1)
        layout.addWidget (button, pos, 2)
		
		return directory

	def createCheckbox (self, library_config, text, tip, option):
	    checkbox = QCheckBox(text, self)
        checkbox.setToolTip('Check this option if you want to use the conversion options.')
        checkbox.setChecked(library_config.get(option, False))

		return checkbox


    def edit_shortcuts(self):
        self.save_settings ()
        self.plugin_action.rebuild_menus ()
        d = KeyboardConfigDialog(self.plugin_action.gui, self.plugin_action.action_spec[0])
        if d.exec_() == d.Accepted:
            self.plugin_action.gui.keyboard.finalize()

    def view_prefs(self):
        d = PrefsViewerDialog(self.plugin_action.gui, PREFS_NAMESPACE)
        d.exec_()

    def build_menus(self): # Aqui se seleccionan las librerias- Esto para la configuracion
        self.plugin_action.menu.clear()
        if os.environ.get('CALIBRE_OVERRIDE_DATABASE_PATH', None):
            self.plugin_action.menu.addAction('disabled', self.cannot_do_dialog)
            return
        db = self.plugin_action.gui.library_view.model().db
        locations = list(self.plugin_action.stats.locations(db))
        if len(locations) > 50:
            self.plugin_action.menu.addAction(_('Choose library by path...'), self.choose_library)
            self.plugin_action.menu.addSeparator()
        for name, loc in locations:
            name = name.replace('&', '&&')
            self.plugin_action.menu.addAction(name, partial(self.copy_to_library,
                loc))
            self.plugin_action.menu.addSeparator()

        if len(locations) <= 50:
            self.plugin_action.menu.addAction(_('Choose library by path...'), self.choose_library)
        self.qaction.setVisible(bool(locations))
        if isosx:
            # The cloned action has to have its menu updated
            self.qaction.changed.emit()

    def _choose_location(self, tipoDir):
        loc = choose_dir(self, 'choose library',
                _('Choose library location '))
        if loc is not None:
			self.location[ConfDir[tipoDir]].setText (loc)

    def choose_library(self, tipoDir):
        pathFin = ""
        d = ChooseLibrary(self.plugin_action.gui)
        if d.exec_() == d.Accepted:
            path, delete_after = d.args
            if not path:
                return
            db = self.plugin_action.gui.library_view.model().db
            current = os.path.normcase(os.path.abspath(db.library_path))
            if current == os.path.normcase(os.path.abspath(path)):
                return error_dialog(self.plugin_action.gui, _('Cannot copy'),
                    _('Cannot copy to current library.'), show=True)

                if (tipoDir == LCON):
                    self.lib_name = path
                else:
                    self.libRel_name = path

