#!/usr/bin/env python
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai
from __future__ import (unicode_literals, division, absolute_import,
                        print_function)
from calibre_plugins.my_tools.config import READ, NONREAD, NEXT, STATUS, UPD, FLE, NRL, READ, CONV,  PAG
from datetime import datetime


__copyright__ = '2015, Terisa de Morgan <terisam@gmail.com>'
__docformat__ = 'restructuredtext en'

from functools import partial
try:
    from PyQt5.Qt import QToolButton, QMenu, QModelIndex
except ImportError:
    from PyQt4.Qt import QToolButton, QMenu

from calibre.ebooks.metadata.book.base import Metadata
from calibre.gui2 import (question_dialog, Dispatcher, error_dialog)
from calibre.gui2.actions import InterfaceAction
from calibre.gui2.dialogs.message_box import ErrorNotification
from calibre.gui2.jobs import JobManager
from calibre.gui2.tools import convert_single_ebook, convert_bulk_ebook
from calibre.ptempfile import PersistentTemporaryDirectory, remove_dir
from calibre.gui2.dialogs.progress import ProgressDialog
from contextlib import closing
from calibre.utils.date import now, UNDEFINED_DATE, DEFAULT_DATE, EPOCH
from calibre.utils.config import prefs, tweaks
from calibre.customize.ui import plugin_for_input_format
from calibre.db.legacy import LibraryDatabase

import calibre_plugins.my_tools.config as cfg
from calibre_plugins.my_tools.common_utils import (set_plugin_icon_resources, get_icon, create_menu_action_unique, debug_print, Worker)

import calibre_plugins.count_pages.config as cfg_page
from calibre_plugins.count_pages.action import CountPagesAction
from threading import Thread

from calibre.ebooks.metadata.book.base import Metadata
from calibre.customize.ui import find_plugin
from calibre.library import current_library_name

import os
import re
import time

PLUGIN_ICONS = ['images/tools.png', 'images/update_series_status.png','images/estimate.png','images/metadata.png', 'images/update_comment.png', 'images/update_metadata.png', 'images/mark_reread.png', 'images/update_conversion.png']

try:
    debug_print("MyTools::action.py - loading translations")
    load_translations()
except NameError:
    debug_print("MyTools::action.py - exception when loading translations")
    pass # load_translations() added in calibre 1.9
	
class MyToolsAction(InterfaceAction):

    name = 'My Tools'
    # Create our top-level menu/toolbar action (text, icon_path, tooltip, keyboard shortcut)
    action_spec = ('My Tools', None, _('Tools to normalize my metadata'), ())
    popup_type = QToolButton.MenuButtonPopup
    action_type = 'current'
    dont_add_to = frozenset(['context-menu-device'])

    def genesis(self):
        self.is_library_selected = True
        self.menu = QMenu(self.gui)
        self.menu_actions = []
		self.metadata_actions = []
		self.conversion_actions = []
		self.register_actions = []
		self.main_actions = []

        # Read the plugin icons and store for potential sharing with the config widget
        icon_resources = self.load_resources(PLUGIN_ICONS)
        set_plugin_icon_resources(self.name, icon_resources)

        self.build_menus()
        self.nltk_pickle = self._get_nltk_resource()

        # Assign our menu to this action and an icon
        self.qaction.setMenu(self.menu)
        self.qaction.setIcon(get_icon(PLUGIN_ICONS[0]))
        self.qaction.triggered.connect(self.toolbar_triggered)
        self.conversion_jobs = {}
        self.job_manager = JobManager ()
		self.libros_rec = ()
		self.num_libros = 0

    def library_changed(self, db):
        # We need to reapply keyboard shortcuts after switching libraries
		debug_print ("MyTools: library changed (", current_library_name(), ")")
        self.reactivate_menus()

    def location_selected(self, loc):
        self.is_library_selected = loc == 'library'

    def build_menus(self):
        m = self.menu
        m.clear()

		candidate = self.gui.library_path
		db = LibraryDatabase (candidate)

        library_config = cfg.get_library_config(db)

        col_indices = {}
		for type, nom_col_key in cfg.CONF_FUNCTION[cfg.ConfTools].iteritems():			
			col_indices[type] = library_config.get (nom_col_key, False)

		# Anyadir los shortcut a traves de action

        ac = create_menu_action_unique(self, m, _('Normalize &metadata'), 'images/estimate.png',
                                  triggered=partial(self._normalize_metadata),
                                  shortcut_name=_('Normalize metadata'), enabled=col_indices[cfg.OME])
        self.menu_actions.append (ac)
		self.metadata_actions.append (ac)

        ac = create_menu_action_unique(self, m, _('Treat &converted'), 'images/mark_reread.png',
                                  triggered=partial(self._treat_converted),
                                      shortcut_name=_('Treat converted'), enabled=col_indices[cfg.OMC])
        self.menu_actions.append (ac)
		self.conversion_actions.append (ac)

        m.addSeparator()
		#sm = QMenu (m)

        #ac = create_menu_action_unique(self, m, _('Register'), 'images/update_conversion.png',
        #                          shortcut=False, submenu=sm, enabled=col_indices[cfg.OMR])
        ac = create_menu_action_unique(self, m, _('Update &register'), 'images/update_conversion.png',
                                  triggered=partial(self._update_register_on_selected),
                                  shortcut_name=_('Update register'), enabled=col_indices[cfg.OMR])
        self.menu_actions.append (ac)
		self.register_actions.append (ac)


        ac = create_menu_action_unique(self, m, _('&Update series status'), 'images/update_series_status.png',
                                  triggered=partial(self._update_series_status_on_selected),
                                      shortcut_name=_('Update series status'), enabled=col_indices[cfg.OMR])
        self.menu_actions.append (ac)
		self.register_actions.append (ac)

        ac = create_menu_action_unique(self, m, _('Mark &rereads'), 'images/mark_reread.png',
                                  triggered=partial(self._update_rereads),
                                      shortcut_name=_('Mark rereads'), enabled=col_indices[cfg.OMR])
        self.menu_actions.append (ac)
		self.register_actions.append (ac)

        ac = create_menu_action_unique(self, m, _('Mark &conversion'), 'images/update_conversion.png',
                                  triggered=partial(self._mark_conversion),
                                      shortcut_name=_('Mark conversion'), enabled=col_indices[cfg.OMR])
        self.menu_actions.append (ac)
		self.register_actions.append (ac)

        ac = create_menu_action_unique(self, m, _('Mark &library'), 'images/update_conversion.png',
                                  triggered=partial(self._mark_library),
                                      shortcut_name=_('Mark library'), enabled=col_indices[cfg.OMR])
        self.menu_actions.append (ac)
		self.register_actions.append (ac)

        m.addSeparator()

        ac = create_menu_action_unique(self, m, _('Move &read books'), 'images/mark_reread.png',
                                  triggered=partial(self._move_read_books),
                                      shortcut_name=_('Move read books'), enabled=col_indices[cfg.OMM])
        self.menu_actions.append (ac)
		self.main_actions.append (ac)

        m.addSeparator()

        ac = create_menu_action_unique(self, m, _('&Normalize comment'), 'images/update_comment.png',
                                  triggered=partial(self._normalize_comment),
                                  shortcut_name=_('Normalize comment'))
        self.menu_actions.append (ac)

        m.addSeparator()
        ac = create_menu_action_unique(self, m, _('&Customize plugin')+'...', 'config.png',
                                  shortcut=False, triggered=self.show_configuration)
        self.menu_actions.append (ac)
        self.gui.keyboard.finalize()

	def reactivate_menus(self):
		candidate = self.gui.library_path
		db = LibraryDatabase (candidate)

        library_config = cfg.get_library_config(db)
		
		debug_print ("Config OK")

        col_indices = {}
		for type, nom_col_key in cfg.CONF_FUNCTION[cfg.ConfTools].iteritems():			
			col_indices[type] = library_config.get (nom_col_key, False)
			
		for action in self.metadata_actions:
			action.setEnabled (col_indices[cfg.OME])
		
		for action in self.conversion_actions:
			action.setEnabled (col_indices[cfg.OMC])
		
		for action in self.register_actions:
			action.setEnabled (col_indices[cfg.OMR])
		
		for action in self.main_actions:
			action.setEnabled (col_indices[cfg.OMM])		

    def toolbar_triggered(self):
        self._update_series_status_on_selected

    def _get_nltk_resource(self):
        # Retrieve the english pickle file. Can't do it from within the nltk code
        # because of our funky situation of executing a plugin from a zip file.
        # So we retrieve it here and pass it through when executing jobs.
        ENGLISH_PICKLE_FILE = 'nltk_lite/english.pickle'
        pickle_data = self.load_resources([ENGLISH_PICKLE_FILE])[ENGLISH_PICKLE_FILE]
        return pickle_data

    def _normalize_comment(self):
        if not self.is_library_selected:
            return error_dialog(self.gui, _('No selected book'),
                    _('No book selected for normalizing comments'), show=True)
            return

        rows = self.gui.library_view.selectionModel().selectedRows()
        if not rows or len(rows) == 0 :
            return error_dialog(self.gui, _('No selected book'),
                    _('No book selected for normalizing comments'), show=True)
        book_ids = self.gui.library_view.get_selected_ids()

        self._do_replace_text (book_ids)

    def _normalize_metadata(self):
        if not self.is_library_selected:
            return error_dialog(self.gui, _('No selected book'),
                    _('No book selected for normalizing metadata'), show=True)

        rows = self.gui.library_view.selectionModel().selectedRows()
        if not rows or len(rows) == 0 :
            return error_dialog(self.gui, _('No selected book'),
                    _('No book selected for update'), show=True)
        book_ids = self.gui.library_view.get_selected_ids()

        any_valid, col_indices = self._get_column_validity(cfg.ConfConversion)
        if not any_valid:
            if not question_dialog(self.gui, _('Configure plugin'), '<p>'+
                _('You must specify custom columns first. Do you want to configure this now?'),
                show_copy_button=False):
                return
            self.show_configuration()
            return

        self._do_replace_text (book_ids)

        convert = self._do_convert_epub (book_ids)
		
		if (convert):
			self.libros_rec = book_ids
			self.num_libros = len (book_ids)
		else:
			self.finish_metadata (col_indices, book_ids)

    def _normalize_conversion(self):
        if not self.is_library_selected:
            return error_dialog(self.gui, _('No library'), 
                    _('No library selected'), show=True)

        rows = self.gui.library_view.selectionModel().selectedRows()
        if not rows or len(rows) == 0 :
            return error_dialog(self.gui, _('No books selected'),
                    _('No book selected for normalizing'), show=True)

        book_ids = self.gui.library_view.get_selected_ids()

        valid_formats = self._check_formats (book_ids)
        if not valid_formats:
            return error_dialog(self.gui, _('No valid format'),
                    _('No epub format found'), show=True)

        self._do_replace_text (book_ids)
        col_conv = ''

        for type, col in col_indices.iteritems ():
            if type == cfg.CONV:
                col_conv = col

        self._do_copy_books ('D:/Biblioteca Kindle/Conversiones', book_ids)
		
		plug = find_plugin ('Count Pages')
		if plugin is not None:
            plugin.load_actual_plugin (self.gui).count_statistics (book_ids, 'PageCount')
			return
	
    def _update_register_on_selected(self):
        dbA = self.gui.current_db
        if not self.is_library_selected:
            return error_dialog(self.gui, _('No selected book'),
                    _('No book selected for update'), show=True)

        rows = self.gui.library_view.selectionModel().selectedRows()
        if not rows or len(rows) == 0 :
            return error_dialog(self.gui, _('No selected book'),
                    _('No book selected for update'), show=True)
        book_ids = self.gui.library_view.get_selected_ids()

        #statistics_to_run = [k for k in ALL_STATISTICS.keys()]
        any_valid, col_indices = self._get_column_validity(cfg.ConfSeries)
        if not any_valid:
            if not question_dialog(self.gui, _('Configure plugin'), '<p>'+
                _('You must specify custom columns first. Do you want to configure this now?'),
                show_copy_button=False):
                return
            self.show_configuration()
            return

        any_valid, col_indices1 = self._get_column_validity(cfg.ConfConversion)
        if not any_valid:
            if not question_dialog(self.gui, _('Configure plugin'), '<p>'+
                _('You must specify custom columns first. Do you want to configure this now?'),
                show_copy_button=False):
                return
            self.show_configuration()
            return

        any_valid, col_indices2 = self._get_column_validity(cfg.ConfMetadata)
        if not any_valid:
            if not question_dialog(self.gui, _('Configure plugin'), '<p>'+
                _('You must specify custom columns first. Do you want to configure this now?'),
                show_copy_button=False):
                return
            self.show_configuration()
            return

        for type, col in col_indices2.iteritems ():
            if type == PAG:
                col_pag = col
            elif type == cfg.GOO:
                col_goodreads = col
            elif type == cfg.PER:
                col_percentage = col

        # Comprobar el porcentaje leido, y si esta definido y es 100
        #   no procesar
        # Poner a cero el numero de paginas de los libros convertidos
        libros_conv = self._get_conv_books (col_indices1, book_ids, 
                            col_percentage)
        if (len (libros_conv) > 0):
            dbA.new_api.set_field(col_pag, {id:None for id in libros_conv})
            self.gui.iactions['Edit Metadata'].refresh_gui(libros_conv, covers_changed=False)

        # Poner goodreads a true

        dbA.new_api.set_field(col_goodreads, {id:1 for id in book_ids})
        self.gui.iactions['Edit Metadata'].refresh_gui(book_ids, covers_changed=False)

        # Eliminar los formatos que existan

        self._remove_all_formats (book_ids)

        self._do_update_series_status(book_ids, col_indices)

    def _update_series_status_on_selected(self):
        if not self.is_library_selected:
            return error_dialog(self.gui, _('No selected book'),
                    _('No book selected for update'), show=True)

        rows = self.gui.library_view.selectionModel().selectedRows()
        if not rows or len(rows) == 0 :
            return error_dialog(self.gui, _('No selected book'),
                    _('No book selected for update'), show=True)
        book_ids = self.gui.library_view.get_selected_ids()

        #statistics_to_run = [k for k in ALL_STATISTICS.keys()]
        any_valid, col_indices = self._get_column_validity(cfg.ConfSeries)
        if not any_valid:
            if not question_dialog(self.gui, _('Configure plugin'), '<p>'+
                _('You must specify custom columns first. Do you want to configure this now?'),
                show_copy_button=False):
                return
            self.show_configuration()
            return

        self._remove_all_formats (book_ids)

        self._do_update_series_status(book_ids, col_indices)

    def _update_rereads(self):
        if not self.is_library_selected:
            return error_dialog(self.gui, _('No selected book'),
                    _('No book selected for update'), show=True)

        rows = self.gui.library_view.selectionModel().selectedRows()
        if not rows or len(rows) == 0 :
            return error_dialog(self.gui, _('No selected book'),
                    _('No book selected for update'), show=True)
        book_ids = self.gui.library_view.get_selected_ids()

        any_valid, col_indices = self._get_column_validity(cfg.ConfReread)
        if not any_valid:
            if not question_dialog(self.gui, _('Configure plugin'), '<p>'+
                _('You must specify custom columns first. Do you want to configure this now?'),
                show_copy_button=False):
                return
            self.show_configuration()
            return

        self._do_update_rereads (book_ids, col_indices)

    def _treat_converted(self):
        if not self.is_library_selected:
            return error_dialog(self.gui, _('No selected book'),
                    _('No book selected for treating'), show=True)

        rows = self.gui.library_view.selectionModel().selectedRows()
        if not rows or len(rows) == 0 :
            return error_dialog(self.gui, _('No selected book'),
                    _('No book selected for treating'), show=True)
        book_ids = self.gui.library_view.get_selected_ids()

        valid_formats, lis_dos_formats = self._check_formats (book_ids)
        if not valid_formats:
            return error_dialog(self.gui, _('No ePub format'),
                    _('No ePub format at selected books'), show=True)

        any_valid, col_indices = self._get_column_validity(cfg.ConfConverted)
        if not any_valid:
            if not question_dialog(self.gui, _('Configure plugin'), '<p>'+
                _('You must specify custom columns first. Do you want to configure this now?'),
                show_copy_button=False):
                return
            self.show_configuration()
            return

		col_conv = col_indices[cfg.CONV]

        # Poner conv a 1

        dbA = self.gui.current_db
        dbA.new_api.set_field(col_conv, {id:1 for id in book_ids})
        self.gui.iactions['Edit Metadata'].refresh_gui(book_ids, covers_changed=False)

		plugin = find_plugin ('Count Pages')
		if plugin is not None:
			self.libros_rec = book_ids
            plugin.load_actual_plugin (self.gui).count_statistics (book_ids, 'PageCount', func=self._do_conversion)

    def _mark_conversion(self):
        if not self.is_library_selected:
            return error_dialog(self.gui, _('No selected book'),
                    _('No book selected for treating'), show=True)

        rows = self.gui.library_view.selectionModel().selectedRows()
        if not rows or len(rows) == 0 :
            return error_dialog(self.gui, _('No selected book'),
                    _('No book selected for marking'), show=True)
        book_ids = self.gui.library_view.get_selected_ids()

        any_valid, col_indices = self._get_column_validity(cfg.ConfMark)
        if not any_valid:
            if not question_dialog(self.gui, _('Configure plugin'), '<p>'+
                _('You must specify custom columns first. Do you want to configure this now?'),
                show_copy_button=False):
                return
            self.show_configuration()
            return

		col_conv = col_indices[cfg.CONV]
		col_pag = col_indices[cfg.PAG]
		
		# Set conv:1, pag:NULL

        dbA = self.gui.current_db
        dbA.new_api.set_field(col_conv, {id:1 for id in book_ids})
        dbA.new_api.set_field(col_pag, {id:None for id in book_ids})
        self.gui.iactions['Edit Metadata'].refresh_gui(book_ids, covers_changed=False)

        self._do_copy_books (col_indices[cfg.LCON], book_ids)

    def _mark_library(self):
        if not self.is_library_selected:
            return error_dialog(self.gui, _('No selected book'),
                    _('No book selected for treating'), show=True)

        rows = self.gui.library_view.selectionModel().selectedRows()
        if not rows or len(rows) == 0 :
            return error_dialog(self.gui, _('No selected book'),
                    _('No book selected for marking'), show=True)
        book_ids = self.gui.library_view.get_selected_ids()

        any_valid, col_indices = self._get_column_validity(cfg.ConfBiblio)
        if not any_valid:
            if not question_dialog(self.gui, _('Configure plugin'), '<p>'+
                _('You must specify custom columns first. Do you want to configure this now?'),
                show_copy_button=False):
                return
            self.show_configuration()
            return

		col_ori = col_indices[cfg.ORI]
		
		# Set conv:1, pag:NULL

        dbA = self.gui.current_db
		idBiblio = dbA.new_api.get_item_id (col_ori, 'Biblioteca')
		debug_print ("Id biblio: ", idBiblio)
        dbA.new_api.set_field(col_ori, {id:'Biblioteca' for id in book_ids})
        self.gui.iactions['Edit Metadata'].refresh_gui(book_ids, covers_changed=False)

        self._do_copy_books (col_indices[cfg.LADQ], book_ids)

    def _move_read_books(self):
        if not self.is_library_selected:
            return error_dialog(self.gui, _('No selected book'),
                    _('No book selected for move'), show=True)

        rows = self.gui.library_view.selectionModel().selectedRows()
        if not rows or len(rows) == 0 :
            return error_dialog(self.gui, _('No selected book'),
                    _('No book selected for move'), show=True)
        book_ids = self.gui.library_view.get_selected_ids()

        any_valid, col_indices = self._get_column_validity(cfg.ConfChallenge)
        if not any_valid:
            if not question_dialog(self.gui, _('Configure plugin'), '<p>'+
                _('You must specify custom columns first. Do you want to configure this now?'),
                show_copy_button=False):
                return
            self.show_configuration()
            return
			
		self._do_copy_books (col_indices[cfg.LREG], book_ids)
			
		book_des = []
		col_des = col_indices[cfg.DES]

        dbA = self.gui.current_db
        for idB in book_ids:
            miA = dbA.get_metadata (idB, index_is_id=True, get_cover=False) # Mirar con db.field
            if not (miA.is_null (col_des)):
                if (miA.get (col_des) <> ""):
                    book_des.append (idB)

        if len(book_des) > 0:
            self._do_copy_books (col_indices[cfg.LDES], book_des)

	def _do_conversion (self, job):
		book_ids = self.libros_rec
		self.libros_rec = ()
		if job.failed:
			return
		
		plugin = find_plugin ('Count Pages')
		if plugin is not None:
            plugin.load_actual_plugin (self.gui)._get_statistics_completed (job)
		

		any_valid, col_indices = self._get_column_validity(cfg.ConfConverted)
		self._do_copy_books (col_indices[cfg.LREG], book_ids)

		col_conv = col_indices[cfg.CONV]

		# Poner conv a Null

		dbA = self.gui.current_db
		dbA.new_api.set_field(col_conv, {id:'' for id in book_ids})
		self.gui.iactions['Edit Metadata'].refresh_gui(book_ids, covers_changed=False)

		# Copia los libros que se van a leer a continuacion

		next_books = self._get_next_books (col_indices, book_ids)

        if len(next_books) > 0:
            self._do_copy_books (col_indices[cfg.LDEV], next_books)

		self._do_convert_books (book_ids)
		
	def _do_replace_text (self, book_ids):
		from calibre.utils.html2text import html2text
        # Queue all the books and kick off the job
		
        dbA = self.gui.current_db
        library_config = cfg.get_library_config(dbA)

        db = self.gui.current_db.new_api

        # Para cada uno de los libros actualiza los metadatos

        id_aux = {}

        for id in book_ids:
            miA = dbA.get_metadata (id, index_is_id=True, get_cover=False)
            texto = miA.get ("comments")
			
            id_aux[id] = html2text(texto)

        dbA.new_api.set_field('comments', {id:id_aux[id] for id in book_ids})
        self.gui.iactions['Edit Metadata'].refresh_gui(book_ids, covers_changed=False)
        
    def _check_formats (self, book_ids):
        db = self.gui.library_view.model().db
        lis_res = []
        for id in book_ids:
            bfmts = db.formats(id, index_is_id=True)
            if bfmts is None:
                return False, lis_res
            bfmts = set([x.lower() for x in bfmts.split(',')])
            if (len (bfmts) > 1):
                lis_res.append (id)
            if ('epub' not in bfmts):
                return False, lis_res
        return True, lis_res

    def _obt_mobi_format (self, book_ids):
        db = self.gui.library_view.model().db
        lis_res = []
        for id in book_ids:
            bfmts = db.formats(id, index_is_id=True)
            if bfmts is not None:
                bfmts = set([x.lower() for x in bfmts.split(',')])
                if ('epub' not in bfmts):
                    lis_res.append (id)
        return lis_res

    def _get_conv_books (self, col_indices, book_ids, col_per):
        col_conv = ''

        for type, col in col_indices.iteritems ():
            if type == cfg.CONV:
                col_conv = col

        lis_books = []
        if (col_conv <> ""):
            dbA = self.gui.current_db
            lis_books = []
            for idB in book_ids:
                miA = dbA.get_metadata (idB, index_is_id=True, get_cover=False) # Mirar con db.field
                if (col_per <> ""):
                    if miA.is_null (col_per):
                        per = 0
                    else:
                        per = miA.get (col_per)
                else:
                    per = 0

                if not (miA.is_null (col_conv)):
                    conv = miA.get (col_conv)
                    if (conv <> "") and (per <> 100):
                        lis_books.append (idB)
        return lis_books

    def _get_column_validity(self, conf):
        '''
        Look that all the custom column are configured
        '''
        db = self.gui.current_db
        all_cols = db.field_metadata.custom_field_metadata()

        library_config = cfg.get_library_config(db)
        dir_lib = cfg.plugin_prefs[cfg.FICH_NAME]

        col_indices = {}
		if cfg.CONF_FUNCTION.has_key (conf) == False:
			any_valid = False
		else:
		    any_valid = True
			
			for type, nom_col_key in cfg.CONF_FUNCTION[conf].iteritems():
				if cfg.DEFAULT_FICH_VALUES.has_key (nom_col_key) == True:
					col = dir_lib.get (nom_col_key, '')	
					is_valid = len(col) > 0
				else :
					col = library_config.get(nom_col_key, '')
					is_valid = len(col) > 0 and col in all_cols
					
				if not is_valid or not col:
					any_valid = False
					col_indices[type] = ''
				else:
					col_indices[type] = col

		return any_valid, col_indices

    def _do_update_series_status(self, book_ids, col_indices):
        # Queue all the books and kick off the job
        dbA = self.gui.current_db
        library_config = cfg.get_library_config(dbA)

        db = self.gui.current_db.new_api

        # Para cada una de las series, actualiza todos los libros de la base de datos

        list_series = list ()
        uniq_series = set ()

        for id in book_ids:
            series_id = db.field_ids_for ("series", id)
            if (series_id is not None):
                #debug_print ("id: ", series_id)
                for id_serie in series_id:
                    #debug_print ("series", id_serie)
                    list_series.append (id_serie)

        if (len (list_series) > 0):
            uniq_series = set (list_series)

        id_map = {}
        apply_metadata = False
        for series in uniq_series:
            lis_books = db.books_for_field ("series", series)

            list_indices = {}

            for type, col in col_indices.iteritems ():
                if type == NEXT:
                    debug_print ('colA:', col)
                    list_indices[type] = {'name':col, 'val': 10000}
                elif type == STATUS:
                    col_read = col
                elif ((type != FLE) and (type != NRL)):
                    debug_print ('colS:', col)
                    list_indices[type] = {'name':col, 'val': 0}

            lis_id = []

            for idB in lis_books:
                miA = dbA.get_metadata (idB, index_is_id=True, get_cover=False) # Mirar con db.field
                lis_id.append (idB)
                ind = miA.get ("series_index")
                if not (miA.is_null (col_read)):
                    lei = miA.get (col_read)
                else:
                    lei = ""

                if (lei == ""):
                    list_indices[NEXT]['val'] = min (list_indices[NEXT]['val'], ind)
                    list_indices[NONREAD]['val'] = list_indices[NONREAD]['val'] + 1
                    debug_print ("ind: ", ind)
                    debug_print ("next: ", list_indices[NEXT]['val'])
                else:
                    list_indices[READ]['val'] = list_indices[READ]['val'] + 1

                list_indices[UPD]['val'] = 1

            if (list_indices[NEXT]['val'] == 10000):
                list_indices[NEXT]['val'] = 0

            custom_cols = dbA.field_metadata.custom_field_metadata()
            for id in lis_id:
                mi = Metadata (_('Unknown'))
                apply_metadata = True

                for elem in list_indices.iterkeys ():
                    debug_print ("elem: ", elem)
                    debug_print ("col: ", list_indices [elem]['name'])
                    debug_print ("val: ", list_indices [elem]['val'])
                    col = custom_cols[list_indices[elem]['name']]
                    col['#value#'] = list_indices [elem]['val']
                    mi.set_user_metadata (list_indices[elem]['name'], col)

                id_map[id] = mi

            debug_print ("Map: ", id_map)

        if (apply_metadata == True):
            edit_metadata_action = self.gui.iactions['Edit Metadata']
            edit_metadata_action.apply_metadata_changes (id_map)

    def _remove_all_formats (self, books_ids):
        db = self.gui.library_view.model().db
        removals = {}
        for id in books_ids:
            fmts = db.formats(id, index_is_id=True, verify_formats=False)
            if fmts:
                removals[id] = fmts.split(',')
        if removals:
            db.new_api.remove_formats(removals)
            self.gui.library_view.model().refresh_ids(books_ids)
            self.gui.library_view.model().current_changed(self.gui.library_view.currentIndex(),
                    self.gui.library_view.currentIndex())
            if books_ids:
                self.gui.tags_view.recount()

    def _remove_epub_format (self, books_ids):
        m = self.gui.library_view.model()
        m.db.new_api.remove_formats({book_id:['EPUB'] for book_id in books_ids})
        m.refresh_ids(books_ids)
        m.current_changed(self.gui.library_view.currentIndex(),
                self.gui.library_view.currentIndex())
        if books_ids:
            self.gui.tags_view.recount()

    def _get_next_books (self, col_indices, book_ids):
        col_next = ''

        for type, col in col_indices.iteritems ():
			debug_print ("Type: ", type)
            if type == cfg.NREAD:
                col_next = col

        lis_books = []
		debug_print ("Buscando libros para leer")
        if (col_next <> ""):
			debug_print ("Columna siguiente: ", col_next)
            dbA = self.gui.current_db
            lis_books = []
            for idB in book_ids:
                miA = dbA.get_metadata (idB, index_is_id=True, get_cover=False) # Mirar con db.field
                if not (miA.is_null (col_next)):
                    next = miA.get (col_next)
                    if (next <> ""):
                        lis_books.append (idB)
						debug_print ("Hallado 1")
        return lis_books

    def _do_update_rereads (self, book_ids, col_indices):
        # Queue all the books and kick off the job

        # 1.- Borrar rating
        # 2.- Borrar fecha lectura
        # 3.- Incrementar numero de lecturas
        #     * Si esta vacio, asignarle 1
        #     * Si no, valor + 1

        dbA = self.gui.current_db
        library_config = cfg.get_library_config(dbA)

        db = self.gui.current_db.new_api

        self._do_copy_books (col_indices[cfg.LREL], book_ids)

        # Para cada uno de los libros actualiza los metadatos

        id_aux = {}
        list_indices = {}

        for type, col in col_indices.iteritems ():
            if type == NRL:
                col_numLect = col
                debug_print ('colA:', col)
                list_indices[type] = {'name':col, 'val': 1}
            elif type == FLE:
                col_fecha = col

        custom_cols = dbA.field_metadata.custom_field_metadata()

        lis_id = []

        for id in book_ids:

            # 1.- Borra fecha lectura
            # 2.- Actualiza numero de lecturas

            miA = dbA.get_metadata (id, index_is_id=True, get_cover=False)

            lis_id.append (id)
            if not (miA.is_null (col_numLect)):
                list_indices[NRL]['val'] = miA.get (col_numLect) + 1
            else:
                list_indices[NRL]['val'] = 1

            mi = Metadata (_('Unknown'))
            id_map = {}

            for elem in list_indices.iterkeys ():
                debug_print ("elem: ", elem)
                debug_print ("col: ", list_indices [elem]['name'])
                debug_print ("val: ", list_indices [elem]['val'])
                col = custom_cols[list_indices[elem]['name']]
                col['#value#'] = list_indices [elem]['val']
                mi.set_user_metadata (list_indices[elem]['name'], col)

                id_map[id] = mi

        dbA.new_api.set_field('rating', {id:0 for id in book_ids})
        dbA.new_api.set_field(col_fecha, {id:None for id in book_ids})
        
        edit_metadata_action = self.gui.iactions['Edit Metadata']
        edit_metadata_action.apply_metadata_changes (id_map)
            #self.gui.iactions['Edit Metadata'].refresh_gui(book_ids, covers_changed=False)

    def show_configuration(self):
        self.interface_action_base_plugin.do_user_config(self.gui)
		
	def _check_pag (self, col_pag, book_ids):
        if (col_pag <> ""):
            dbA = self.gui.current_db
            for idB in book_ids:
                miA = dbA.get_metadata (idB, index_is_id=True, get_cover=False) # Mirar con db.field
                if miA.is_null (col_pag):
					return False
                else:
                    pag = miA.get (col_pag)
					if pag == 0:
						return False
		return True

    def _do_copy_books (self, path, book_ids):
        db = self.gui.library_view.model().db
        if not db.exists_at(path):
            return error_dialog(self.gui, _('No library'),
                    _('No library found at %s')%loc, show=True)

        self.do_copy(book_ids, db, path, add_duplicates=True)

    def do_copy(self, ids, db, loc, add_duplicates=True):
        aname = _('Copying to')
        dtitle = '%s %s'%(aname, os.path.basename(loc))
        self.pd = ProgressDialog(dtitle, min=0, max=len(ids)-1,
                parent=self.gui, cancelable=False, icon='lt.png')

        def progress(idx, title):
            self.pd.set_msg(title)
            self.pd.set_value(idx)

        self.worker = Worker(ids, db, loc, Dispatcher(progress),
                             Dispatcher(self.pd.accept), add_duplicates)
        self.worker.start()

        self.pd.exec_()

        donemsg = _('Copied %(num)d books to %(loc)s')

        if self.worker.error is not None:
            e, tb = self.worker.error
            error_dialog(self.gui, _('Failed'), _('Could not copy books: ') + e,
                    det_msg=tb, show=True)
            return

        self.gui.status_bar.show_message(donemsg %
                dict(num=len(ids), loc=loc), 2000)
        if self.worker.auto_merged_ids:
            books = '\n'.join(self.worker.auto_merged_ids.itervalues())
            info_dialog(self.gui, _('Auto merged'),
                    _('Some books were automatically merged into existing '
                        'records in the target library. Click Show '
                        'details to see which ones. This behavior is '
                        'controlled by the Auto merge option in '
                        'Preferences->Adding books.'), det_msg=books,
                    show=True)
        return self.worker.duplicate_ids

    def _do_convert_books (self, book_ids):
        previous = self.gui.library_view.currentIndex()
        db = self.gui.library_view.model().db
        rows = [x.row() for x in
                self.gui.library_view.selectionModel().selectedRows()]
        num = 0
        formats = ('MOBI', 'LIT')
        for format in formats:
            if len(book_ids) > 1:
                self.__bulk_queue = convert_bulk_ebook(self.gui, self._queue_convert_jobs,
                    db, book_ids,
                    out_format=format, args=(rows, previous,
                        self.book_converted))
                if self.__bulk_queue is None:
                    return
                num = num + len(self.__bulk_queue.book_ids)
            else:
                jobs, changed, bad = convert_single_ebook(self.gui,
                    db, book_ids, auto_conversion=True, out_format=format)
                self._queue_convert_jobs(jobs, changed, bad, rows, previous,
                        self.book_converted)
                num = num + len(jobs)

        if num > 0:
            self.gui.jobs_pointer.start()
			
		self.num_libros = 0

    def _do_convert_epub (self, book_ids):
        previous = self.gui.library_view.currentIndex()
        db = self.gui.library_view.model().db
        rows = [x.row() for x in
                self.gui.library_view.selectionModel().selectedRows()]
        num = 0

        #
        # Busco los libros que no tienen epub
        #

        lis_mobi = self._obt_mobi_format (book_ids)

        if (len (lis_mobi) > 0):
            format = 'EPUB'
            if len(lis_mobi) > 1:
                self.__bulk_queue = convert_bulk_ebook(self.gui, self._queue_convert_jobs,
                        db, lis_mobi,
                        out_format=format, args=(rows, previous,
                            self.book_converted))
                if self.__bulk_queue is None:
                    return
                num = num + len(self.__bulk_queue.book_ids)
            else:
                jobs, changed, bad = convert_single_ebook(self.gui,
                        db, lis_mobi, auto_conversion=True, out_format=format)
                self._queue_convert_jobs(jobs, changed, bad, rows, previous,
                            self.book_converted)
                num = num + len(jobs)

            if num > 0:
                self.gui.jobs_pointer.start()
				
			return True
		else:
			return False

    def book_converted(self, job):
        temp_files, fmt, book_id = self.conversion_jobs.pop(job)[:3]
        try:
            if job.failed:
                self.gui.job_exception(job)
                return
            db = self.gui.current_db
            if not db.new_api.has_id(book_id):
                return error_dialog(self.gui, _('Book deleted'), _(
                    'The book you were trying to convert has been deleted from the calibre library.'), show=True)
            same_fmt = getattr(job, 'conversion_of_same_fmt', False)
            manually_fine_tune_toc = getattr(job, 'manually_fine_tune_toc', False)
            fmtf = temp_files[-1].name
            if os.stat(fmtf).st_size < 1:
                raise Exception(_('Empty output file, '
                    'probably the conversion process crashed'))

            if same_fmt and tweaks['save_original_format']:
                db.save_original_format(book_id, fmt, notify=False)

            with open(temp_files[-1].name, 'rb') as data:
                db.add_format(book_id, fmt, data, index_is_id=True)
            self.gui.book_converted.emit(book_id, fmt)
            self.gui.status_bar.show_message(job.description +
                    (' completed'), 2000)
        finally:
            for f in temp_files:
                try:
                    if os.path.exists(f.name):
                        os.remove(f.name)
                except:
                    pass
        self.gui.tags_view.recount()
        if self.gui.current_view() is self.gui.library_view:
            lv = self.gui.library_view
            lv.model().refresh_ids((book_id,))
            current = lv.currentIndex()
            if current.isValid():
                lv.model().current_changed(current, QModelIndex())
        if manually_fine_tune_toc:
            self.gui.iactions['Edit ToC'].do_one(book_id, fmt.upper())
			
        any_valid, col_indices = self._get_column_validity(cfg.ConfConversion)
        if not any_valid:
            if not question_dialog(self.gui, _('Configure plugin'), '<p>'+
                _('You must specify custom columns first. Do you want to configure this now?'),
                show_copy_button=False):
                return
            self.show_configuration()
            return

		if self.num_libros > 0:
			if self.num_libros > 1:
				self.num_libros = self.num_libros - 1
			else:
				self.finish_metadata (col_indices, self.libros_rec)
				self.libros_rec = ()

    def _queue_convert_jobs (self, jobs, changed, bad, rows, previous, converted_func):
        for func, args, desc, fmt, id, temp_files in jobs:
            func, _, parts = func.partition(':')
            parts = {x for x in parts.split(';')}
            input_file = args[0]
            input_fmt = os.path.splitext(input_file)[1]
            core_usage = 1
            if input_fmt:
                input_fmt = input_fmt[1:]
                plugin = plugin_for_input_format(input_fmt)
                if plugin is not None:
                    core_usage = plugin.core_usage

            if id not in bad:
                job = self.gui.job_manager.run_job(Dispatcher(converted_func),
                                            func, args=args, description=desc,
                                            core_usage=core_usage)
                job.conversion_of_same_fmt = 'same_fmt' in parts
                job.manually_fine_tune_toc = 'manually_fine_tune_toc' in parts
                args = [temp_files, fmt, id]
                self.conversion_jobs[job] = tuple(args)

        if changed:
            m = self.gui.library_view.model()
            m.refresh_ids(rows)
            current = self.gui.library_view.currentIndex()
            self.gui.library_view.model().current_changed(current, previous)

	def finish_metadata (self, col_indices, book_ids):
	
	    valid_formats, lis_dos_formats = self._check_formats (book_ids)
        if not valid_formats:
            return error_dialog(self.gui, _('No ePub format'),
                    _('No ePub format at selected books'), show=True)

        dbA = self.gui.current_db
        dbA.new_api.set_field('rating', {id:0 for id in book_ids})
        
        self.gui.iactions['Edit Metadata'].refresh_gui(book_ids, covers_changed=False)

		libros_conv = self._get_conv_books (col_indices, book_ids, '')

        if len(libros_conv) > 0:
            self._do_copy_books (col_indices[cfg.LCON], libros_conv)

		plugin = find_plugin ('Count Pages')
		if plugin is not None:
            plugin.load_actual_plugin (self.gui).count_statistics (book_ids, 'PageCount')
				
            if len (lis_dos_formats) > 0:
				self._remove_epub_format (lis_dos_formats)
            return
