from threading import Thread, Event
from calibre.gui2 import gprefs
from calibre.gui2.auto_add import AUTO_ADDED
import os, stat

class Unblocker(Thread):
    #
    # The time in seconds between checks for files to process
    #
    loopDelay = 10 * 60
    
    def __init__(self):
        Thread.__init__(self)
        self.daemon = True
        self.keepRunning = True
        self.signaller = Event()

    def run(self):
        while self.keepRunning:
            try:
                gotFiles = False
                autodir  = gprefs['auto_add_path']
                if gprefs['auto_add_everything']:
                    addlist = AllAllowed()
                else:
                    addlist = AUTO_ADDED - frozenset(gprefs['blocked_auto_formats'])
                for file in os.listdir(autodir):
                    name, ext = os.path.splitext(file)
                    if ext.lstrip('.') in addlist:
                        path = os.path.join(autodir,file)
                        os.chmod(path,stat.S_IWRITE|stat.S_IREAD)
                        print 'Auto-add unblocker: processed \"%s\"' % file
                        gotFiles = True
                if gotFiles:
                    flagFile = os.path.join(autodir,'foo.xxx')
                    open(flagFile,'a').close()
                    os.remove(flagFile)
            except:
                pass
            self.signaller.wait(self.loopDelay)

    def stop(self):
        self.keepRunning = False
        self.signaller.set()
