from threading import Thread, Event
from calibre.gui2 import gprefs
from calibre.gui2.auto_add import AUTO_ADDED
import os, stat

class Unblocker(Thread):
    #
    # The time in seconds between checks for files to process
    #
    loopDelay = 10 * 60
    
    def __init__(self):
        Thread.__init__(self)
        self.daemon = True
        self.keepRunning = True
        self.signaller = Event()

    def run(self):
        perms = (stat.S_IWRITE|stat.S_IREAD)
        while self.keepRunning:
            gotFiles = False
            autodir  = gprefs['auto_add_path']
            for file in os.listdir(autodir):
                name, ext = os.path.splitext(file)
                if ext.lstrip('.') in AUTO_ADDED:
                    path = os.path.join(autodir,file)
                    mode = os.stat(path).st_mode & perms
                    if mode != perms:
                      os.chmod(path,perms)
                      print 'Auto-add unblocker: processed \"%s\"' % file
                      gotFiles = True
            if gotFiles:
                flagFile = os.path.join(autodir,'foo.xxx')
                open(flagFile,'a').close()
                os.remove(flagFile)
            self.signaller.wait(self.loopDelay)

    def stop(self):
        self.keepRunning = False
        self.signaller.set()
