from threading import Thread, Event
from calibre.gui2 import gprefs
import os, stat

class Unblocker(Thread):
    #
    # The time in seconds between checks for files to process
    #
    loopDelay = 10 * 60
    
    def __init__(self):
        Thread.__init__(self)
        self.daemon = True
        self.keepRunning = True
        self.signaller = Event()

    def run(self):
        while self.keepRunning:
            gotFiles = False
            autodir  = gprefs['auto_add_path']
            for file in os.listdir(autodir):
                path = os.path.join(autodir,file)
                os.chmod(path,stat.S_IWRITE|stat.S_IREAD)
                print 'Auto-add unblocker: processed \"%s\"' % file
                gotFiles = True
            if gotFiles:
                flagFile = os.path.join(autodir,'foo.xxx')
                open(flagFile,'a').close()
                os.remove(flagFile)
            self.signaller.wait(self.loopDelay)

    def stop(self):
        self.keepRunning = False
        self.signaller.set()
