#!/bin/sh

killall timedlock.sh || true

# change to directory of this script
cd "$(dirname "$0")"

# load configuration
if [ -e "config.sh" ]; then
        source config.sh
fi

# load utils
if [ -e "utils.sh" ]; then
        source utils.sh
else
        echo "Could not find utils.sh in `pwd`"
        exit
fi

# only run on supported devices
#TODO

if [ -e /etc/upstart ]; then
        logger "Enabling Timed Lock"

        mntroot rw
        cp timedlock.conf /etc/upstart/
        mntroot ro

        start timedlock
else
        logger "Upstart folder not found, device too old"
fi
