#############################################################################
### TIMED LOCK CONFIGURATION SETTINGS
#############################################################################

# up to how many SECONDS may your Kindle sleep before the passcode is required
# again (this setting only applies to times that are not specifically configured
# in the schedule).
PASSCODEFREESLEEPTIME=10

# The file that signals that the Kindle has an active password (remove to
# disable the password, touch to enable password - assuming a password is
# set!)
PASSCODEFILE=/var/local/system/userpasswdenabled

# Schedule for the day. Use checkschedule.sh to check whether the format is
# correct and interpreted as you intended. The format is a space separated
# list of settings for different times of day:
#       SCHEDULE="setting1 setting2 setting3 etc"
# where each setting is of the format
#       STARTHOUR:STARTMINUTE-ENDHOUR:ENDMINUTE=PASSCODEENABLED,SLEEPTIME
# where
#       STARTHOUR:STARTMINUTE is the time this setting starts taking effect
#       ENDHOUR:ENDMINUTE is the time this setting stops being active
#       PASSCODEENABLED is 1 if a passcode should be requested, 0 if not
#       SLEEPTIME is the number of SECONDS up to which your Kindle may sleep
#        without requiring the passcode to be entered (this will override 
#        the global PASSCODEFREESLEEPTIME setting)
#
# Time values must be in 24 hour format and must not wrap over midnight.
# EXAMPLE: "00:00-08:00=1,10 08:00-20:00=1,0 20:00-24:00=0,0"
#          -> Require passcode between midnight and 8am, with 10s timeout
#          -> Require passcode between 8am and 8pm (20 o'clock) at all times
#          -> Do not require a passcode at all between 8pm and midnight
#
# Use the checkschedule.sh script to verify that the setting is correct and
# which would be the active setting.
SCHEDULE="00:00-06:00=1,0 06:00-21:00=1,10 21:00-24:00=1,30"

# Whether to create log output (1) or not (0).
LOGGING=1

# Where to log to - either /dev/stdout for console output, or an absolute
# file path (beware that this may grow large over time!)
LOGFILE=/dev/stderr
#LOGFILE=/tmp/timedlock.log  


#############################################################################
# Advanced
#############################################################################

# the real-time clock to use (0, 1 or 2)
RTC=0
