#!/bin/sh
#
##############################################################################
#
# Checks the format of the schedule configuration value
#
##############################################################################

# change to directory of this script
cd "$(dirname "$0")"

# load configuration
if [ -e "config.sh" ]; then
	source config.sh
fi

# load utils
if [ -e "utils.sh" ]; then
	source utils.sh
else
	echo "Could not find utils.sh in `pwd`"
	exit
fi

# get minute of day
CURRENTMINUTE=$(( 60*`date +%-H` + `date +%-M` ))

# SCHEDULE="00:00-06:00=10 06:00-21:00=0 21:00-24:00=10" 
for schedule in $SCHEDULE; do
	echo "Parsing \"$schedule\""
	read STARTHOUR STARTMINUTE ENDHOUR ENDMINUTE ENABLED TIMEOUT << EOF
		$( echo $schedule | sed -e 's/[:,=,-]/ /g' )
EOF
	echo "	Starts at $STARTHOUR hours and $STARTMINUTE minutes"
	echo "	Ends at $ENDHOUR hours and $ENDMINUTE minutes"
	echo "	Lock is $ENABLED, timeout $TIMEOUT"

	START=$(( 60*$STARTHOUR + $STARTMINUTE ))
	END=$(( 60*$ENDHOUR + $ENDMINUTE ))

	if [ $END -lt $START ]; then
		echo "!!!!!!! End time is before start time."
	fi

	if [ $CURRENTMINUTE -ge $START ] && [ $CURRENTMINUTE -lt $END ]; then
		echo "------> Active setting"
	fi
done
