#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import unicode_literals, division, absolute_import, print_function
from io import BytesIO
from os.path import splitext, basename
import uuid, sys, os, tempfile, imghdr

PY2 = sys.version_info[0] == 2

if PY2:
    from Tkinter import Tk 
    from urlparse import urlparse
    import urllib
else:
    from tkinter import Tk 
    from urllib.parse import urlparse
    import urllib.request
    
# main routine
def run(bk):
    image_name = 'img' + str(uuid.uuid4())[24:82] + '.jpg'
    image_data = None
    mime_type = 'image/jpeg'

    if sys.platform.startswith('win'):
        # get image from Windows clipboard
        try:
            from PIL import ImageGrab
            img = ImageGrab.grabclipboard()
            if img:
                clipboard_data = BytesIO()
                img.save(clipboard_data, 'jpeg', quality=90)
                image_data = clipboard_data.getvalue()
        except:
            print('Pillow import error or unsupported clipboard image format.')
    
    if sys.platform.startswith('linux'):
        # get image from GTK clipboard
        try:
            if PY2:
                import gtk
                clipboard = gtk.clipboard_get()
            else:
                from gi.repository import Gtk, Gdk
                clipboard = Gtk.Clipboard.get(Gdk.SELECTION_CLIPBOARD)
            img = clipboard.wait_for_image()
                
            if img:
                temp_file = tempfile.NamedTemporaryFile().name
                if PY2:
                    img.save(temp_file, 'jpeg', {str('quality'):str('90')})
                else:
                    img.savev(temp_file, "jpeg", ["quality"], ["90"])
                img_file = open(temp_file, "rb")
                image_data = img_file.read()    
                img_file.close()
                os.remove(temp_file)
        except:
            print('GTK import error or unsupported clipboard image format.')

    if not image_data:
        # try to download an image
        root = Tk()
        root.withdraw()
        try:
            clipboard = root.clipboard_get()
            root.destroy()
            if clipboard:
                file_name, extension = splitext(basename(urlparse(clipboard).path))
                image_name = file_name + extension
                temp_file = os.path.join(tempfile.gettempdir(), image_name)
                if PY2:
                    urllib.urlretrieve(clipboard, temp_file)
                else:
                    urllib.request.urlretrieve(clipboard, temp_file)
                if extension == '':
                    extension = imghdr.what(temp_file)
                    image_name = image_name + '.' + extension
                mime_type = 'image/' + imghdr.what(temp_file)
                img_file = open(temp_file, "rb")
                image_data = img_file.read()    
                img_file.close()
                os.remove(temp_file)
        except:
            print('Unsupported clipboard format or image retrieval error.')
        
    # add image to epub
    if image_data:
        try:
            bk.addfile(image_name, image_name, image_data, mime_type)
            print(image_name + ' added')
        except:
            print(image_name + ' couldn\'t be added')
    else:
        print('No clipboard image found.')
        
    print('\nDone.\n\nPlease click OK to close the Plugin Runner window.')
    return 0

def main():
    print('I reached main when I should not have\n')
    return -1

if __name__ == "__main__":
    sys.exit(main())
