#!/bin/sh
# ==== nickel variant of the launcher
# set variables
export ROOT=/mnt/onboard/.kobo/db_scripts
export VROOT=/mnt/onboard/.kobo/vlasovsoft
export ROOT_BAK=$ROOT/../db_scripts.bak
LOG=/dev/null
case `/bin/kobo_config.sh * 2>/dev/null` in
 alyssum) DEVICE=GLOHD ;;
 dahlia)  DEVICE=AURAH2O ;;
 dragon)  DEVICE=AURAHD  ;;
 phoenix) DEVICE=AURA    ;;
 kraken)  DEVICE=GLO     ;;
 trilogy) DEVICE=TOUCH   ;;
 pixie)   DEVICE=MINI    ;;
 *)       DEVICE=TOUCH   ;;
esac
export DEVICE
export TMPDIR=/tmp/db_scripts
export LANG=en_US.UTF-8
export VLASOVSOFT_KEY=$VROOT/key
export VLASOVSOFT_KBD=$VROOT/kbd.txt
export VLASOVSOFT_FIFO1=$TMPDIR/fifo1
export VLASOVSOFT_FIFO2=$TMPDIR/fifo2
export VLASOVSOFT_I18N=$VROOT/i18n
export VLASOVSOFT_DICT=$VROOT/dictionary
export QT_PLUGIN_PATH=$VROOT/Qt/plugins
export LD_LIBRARY_PATH=$VROOT/Qt/lib
if [ $DEVICE == AURAH2O -o $DEVICE == GLOHD ]; then
    export QWS_MOUSE_PROTO=KoboTS_h2o
else
    export QWS_MOUSE_PROTO=KoboTS
fi
export QWS_KEYBOARD=KoboKb
export QWS_DISPLAY=Transformed:KoboFB
export QT_QWS_FONTDIR=$VROOT/fonts
export STYLESHEET=$ROOT/eink.qss
export UPDATE_DELAY_PART=25
export UPDATE_DELAY_FULL=50
cd $ROOT

# kill nickel
killall nickel
killall hindenburg
killall fmon

# make the temporary directory for Qt
mkdir -p $TMPDIR

# make fifos
mkfifo $VLASOVSOFT_FIFO1
mkfifo $VLASOVSOFT_FIFO2

# remount external SD card to read/write
/bin/mount -w -o remount /mnt/sd

# upgrade
if [ -d $ROOT_BAK -a ! -f $ROOT/upgraded ]; then
    $VROOT/upgrade.sh
    touch $ROOT/upgraded
fi

# run launcher
echo 0 > /sys/class/graphics/fb0/rotate
$ROOT/db_launcher -qws -stylesheet $STYLESHEET > $LOG 2>&1

# remove fifos
rm $VLASOVSOFT_FIFO1
rm $VLASOVSOFT_FIFO2

if [ -f $ROOT/nickel ]; then
    . $VROOT/run_nickel.sh
else
    /sbin/reboot
fi

