#!/bin/sh

fmonroot=/mnt/onboard/.kobo/db_scripts
targetmd5sum=$fmonroot/log/PPDrtl_ja_kepub_md5sum
sqlite3prg=$fmonroot/sqlite3

PPDrtl_ja_kepub() {
	echo "PRAGMA synchronous = OFF;"
	echo "PRAGMA journal_mode = MEMORY;"
	echo "BEGIN TRANSACTION;"
	
	$sqlite3prg /mnt/onboard/.kobo/KoboReader.sqlite "
    SELECT ContentID FROM content
    WHERE ContentID LIKE 'file:///mnt/%'
      AND ContentID NOT LIKE '%#%'
      AND ContentID NOT LIKE '%/.%'
      AND ContentType != 9
      OR ContentURL LIKE 'http://www.kobobooks.com/%'
    ORDER BY ContentID
    ;" | while read file
	do
		echo "UPDATE content SET PageProgressDirection='rtl' WHERE ContentType=6 AND MimeType='application/x-kobo-epub+zip' AND Language IN('ja', 'jpn', 'enm') AND PageProgressDirection='ltr';"
	done
	
	echo "END TRANSACTION;"
}

ROTATE=/sys/class/graphics/fb0/rotate

if [ -e /mnt/onboard/.kobo/KoboReader.sqlite ]
then
    rotate=$(cat "$ROTATE")
    
    result=$(PPDrtl_ja_kepub)

    if echo "$result" | md5sum -c $targetmd5sum > /dev/null 2>&1
    then
        echo "Already done..."
	$fmonroot/showpic/showpic 2 already_updated.png
    else
        /etc/init.d/update-animator.sh &
        echo "$result" | md5sum > $targetmd5sum
        echo "$result" | $sqlite3prg /mnt/onboard/.kobo/KoboReader.sqlite  > /dev/null 2>&1
        echo "Database updated..."
        killall update-animator.sh
    fi
    
    echo "$rotate" > "$ROTATE"
    cat "$ROTATE" > "$ROTATE"
fi
