#!/bin/sh

ksmroot=${ksmroot:-"/adds/kbmenu"}
ksmuser=${ksmuser:-"/mnt/onboard/.adds/kbmenu_user"}
ksmFontDir=${ksmFontDir:-"$ksmuser/fonts"}

[ -d "$ksmFontDir" ] || ksmFontDir="$ksmroot/fonts"

if [ "$KSMdebugmode" == "true" ]; then
  debug_logfile=$ksmroot/log/ksmdebug_$(date +%Y%m%d_%H%M%S)_$(basename $0).log
  echo "started: $(date +%Y%m%d_%H%M%S)" > $debug_logfile
  echo "script path: $0" >> $debug_logfile
  echo "ksmroot: $ksmroot" >> $debug_logfile
  echo "product: $PRODUCT" >> $debug_logfile
  echo "ksmGeometryValuesN: $ksmGeometryValuesN"  >> $debug_logfile
  echo "ksmGeometryValuesE: $ksmGeometryValuesE"  >> $debug_logfile
  echo "ksmGeometryValuesS: $ksmGeometryValuesS"  >> $debug_logfile
  echo "ksmGeometryValuesW: $ksmGeometryValuesW"  >> $debug_logfile
  sync
fi


export QT_PLUGIN_PATH=$ksmroot/Qt/plugins
export LD_LIBRARY_PATH=$ksmroot/Qt/lib
export QWS_MOUSE_PROTO=KoboTS
export QT_QWS_FONTDIR=$ksmFontDir
if [ "$mrotation" == "0" ] || [ "$mrotation" == "90" ] || [ "$mrotation" == "180" ] || [ "$mrotation" == "270" ]; then
  export QWS_DISPLAY=Transformed:KoboFB:Rot$mrotation
else
  export QWS_DISPLAY=Transformed:KoboFB:Rot90
fi

if [ "$KSMdebugmode" == "true" ]; then
  if [ "$mrotation" == "0" ] && [ "x$ksmGeometryValuesE" != "x" ]; then
    $ksmroot/imageviewer $* -qws -geometry $ksmGeometryValuesE >> $debug_logfile
  elif [ "$mrotation" == "90" ] && [ "x$ksmGeometryValuesN" != "x" ]; then
    $ksmroot/imageviewer $* -qws -geometry $ksmGeometryValuesN >> $debug_logfile
  elif [ "$mrotation" == "180" ] && [ "x$ksmGeometryValuesW" != "x" ]; then
    $ksmroot/imageviewer $* -qws -geometry $ksmGeometryValuesW >> $debug_logfile
  elif [ "$mrotation" == "270" ] && [ "x$ksmGeometryValuesS" != "x" ]; then
    $ksmroot/imageviewer $* -qws -geometry $ksmGeometryValuesS >> $debug_logfile
  else
    $ksmroot/imageviewer $* -qws  >> $debug_logfile
  fi
else
  if [ "$mrotation" == "0" ] && [ "x$ksmGeometryValuesE" != "x" ]; then
    $ksmroot/imageviewer $* -qws -geometry $ksmGeometryValuesE
  elif [ "$mrotation" == "90" ] && [ "x$ksmGeometryValuesN" != "x" ]; then
    $ksmroot/imageviewer $* -qws -geometry $ksmGeometryValuesN
  elif [ "$mrotation" == "180" ] && [ "x$ksmGeometryValuesW" != "x" ]; then
    $ksmroot/imageviewer $* -qws -geometry $ksmGeometryValuesW
  elif [ "$mrotation" == "270" ] && [ "x$ksmGeometryValuesS" != "x" ]; then
    $ksmroot/imageviewer $* -qws -geometry $ksmGeometryValuesS
  else
    $ksmroot/imageviewer $* -qws
  fi
fi
