#!/bin/sh

ksmroot=${ksmroot:-"/adds/kbmenu"}

if [ "$KSMdebugmode" == "true" ]; then
#debug_logfile=$ksmroot/log/ksmdebug_$(date +%Y%m%d_%H%M%S)_kobomenu.sh.log
  debug_logfile=$ksmroot/log/ksmdebug_$(date +%Y%m%d_%H%M%S)_$(basename $0).log
  echo "started: $(date +%Y%m%d_%H%M%S)" > $debug_logfile
  echo "script path: $0" >> $debug_logfile
  echo "ksmroot: $ksmroot" >> $debug_logfile
  echo "koreaderbasedir: $koreaderbasedir" >> $debug_logfile
  sync
fi


[ "$koreaderbasedir" == "" ] && exit
koreadersh=$koreaderbasedir/koreader/koreader.sh


frontlightprg=$ksmroot/tools/frontlight
dontTamperwithFrontlight=${dontTamperwithFrontlight:-"true"}

if [ $(grep -c 'from_nickel' "$koreadersh") -gt 0 ]; then
  [ "$KSMdebugmode" == "true" ] && echo "call: $koreadersh" >> $debug_logfile
  if [ $(grep -c  'KOREADER_DIR=/mnt/onboard/.kobo/koreader' $koreadersh) -gt 0 ]; then
    sed -i "s:KOREADER_DIR=/mnt/onboard/.kobo/koreader:KOREADER_DIR=\$(dirname \$0):" $koreadersh
  fi
  if [ $(grep -c  'cd /mnt/onboard/.kobo' $koreadersh) -gt 0 ]; then
    sed -i "s:cd /mnt/onboard/.kobo:cd \$(dirname \$KOREADER_DIR):" $koreadersh
  fi
  $koreadersh
else
  [ "$KSMdebugmode" == "true" ] && echo "bypass orig koreader.sh" >> $debug_logfile
# remain compatible with older versions of Koreader
  export LC_ALL="en_US.UTF-8"

# we're always starting from our working directory
  cd $koreaderbasedir/koreader/

# export trained OCR data directory
  export TESSDATA_PREFIX="data"

# export dict directory
  export STARDICT_DATA_DIR="data/dict"
# finally call reader
  ./reader.lua /mnt/onboard 2> crash.log
fi

if [ "$deleteSDRsOnboard" == "true" ]; then
  $ksmroot/scripts_intern/koreader/delete_sdrs.sh
fi

#set frontlight for KSM
[ $PRODUCT != trilogy ] && [ $PRODUCT != pixie ] && [ $PRODUCT != pika ] && (
[ "$KSMdebugmode" == "true" ] && echo "reset frontligth to $KSMfrontlightlevel" >> $debug_logfile
$frontlightprg "$KSMfrontlightlevel"
)

$ksmroot/onstart/clean_up_after_koreader.sh

[ $(lsmod | grep -c sdio_wifi_pwr) -gt 0 ] &&  $ksmroot/kbmessage.sh "Info: Wifi is enabled!"

