#!/bin/sh

ksmroot=${ksmroot:-"/adds/kbmenu"}

if [ "$KSMdebugmode" == "true" ]; then
  debug_logfile=$ksmroot/log/ksmdebug_$(date +%Y%m%d_%H%M%S)_$(basename $0).log
  echo "started: $(date +%Y%m%d_%H%M%S)" > $debug_logfile
  echo "script path: $0" >> $debug_logfile
  echo "ksmroot: $ksmroot" >> $debug_logfile
  echo "product: $PRODUCT" >> $debug_logfile
fi

KOREADER_DIR="$1"
koreadersh=$KOREADER_DIR/koreader.sh

frontlightprg=$ksmroot/tools/frontlight
dontTamperwithFrontlight=${dontTamperwithFrontlight:-"true"}
currentRotation=$(cat /sys/class/graphics/fb0/rotate)

if [ "$KSMdebugmode" == "true" ]; then
  echo "KOREADER_DIR: $KOREADER_DIR" >> $debug_logfile
fi

if [ $(grep -c 'from_nickel' "$koreadersh") -gt 0 ]; then
  [ "$KSMdebugmode" == "true" ] && echo "call: $koreadersh" >> $debug_logfile
  if [ $(grep -c  'KOREADER_DIR=/mnt/onboard/.kobo/koreader' $koreadersh) -gt 0 ]; then
    sed -i "s:KOREADER_DIR=/mnt/onboard/.kobo/koreader:KOREADER_DIR=\$(dirname \$0):" $koreadersh
  fi
  if [ $(grep -c  'cd /mnt/onboard/.kobo' $koreadersh) -gt 0 ]; then
    sed -i "s:cd /mnt/onboard/.kobo:cd \$(dirname \$KOREADER_DIR):" $koreadersh
  fi
  $koreadersh
else
  [ "$KSMdebugmode" == "true" ] && echo "bypass orig koreader.sh" >> $debug_logfile
# remain compatible with older versions of Koreader
# we're always starting from our working directory
  cd $KOREADER_DIR

# export trained OCR data directory
  export TESSDATA_PREFIX="data"

  args="/mnt/onboard"

# export dict directory
  export STARDICT_DATA_DIR="data/dict"
  ./reader.lua $args 2> crash.log
fi

echo "$currentRotation" > /sys/class/graphics/fb0/rotate
cat /sys/class/graphics/fb0/rotate > /sys/class/graphics/fb0/rotate
 
#set frontlight for KSM
[ $PRODUCT != trilogy ] && [ $PRODUCT != pixie ] && [ $PRODUCT != pika ] && (
[ "$KSMdebugmode" == "true" ] && echo "reset frontligth to $KSMfrontlightlevel" >> $debug_logfile
$frontlightprg "$KSMfrontlightlevel"
)

$ksmroot/onstart/clean_up_after_koreader.sh
[ $(lsmod | grep -c sdio_wifi_pwr) -gt 0 ] &&  $ksmroot/kbmessage.sh "Info: Wifi is enabled!"

