import os, sys, shutil
from optparse import OptionParser

#error
class DirException(Exception):
	pass

# writes a log file
def logwrite(strings):
	logfile = open("log.txt", "a")
	logfile.write(strings)
	logfile.close()

# put a value between XML tags (no attributes)
def putintags(tag, value):
	return("<" + tag + ">" + value + "</" + tag + ">")

def createmanifest(fname, imgname):
	manifest = open("manifest.xml", "w")
	manifest.write('<?xml version="1.0" encoding="utf-8"?>')
	manifest.write("\n")
	title = "Titolo"
	author = "Autore"
	# dirty trick for to get metadata (author & Title)
	# Uses mobi2mobi.exe capturing the output
	xx=os.popen("mobi2mobi.exe --savethumb " + "\"" + imgname + "\"" + " \"" + fname + "\"", "r")
	#print xx
	for xline in xx:
		if xline.rfind("EXTH    item: 100 - Author") != -1:
			author = xline[34:len(xline)-1]
			#print xline
			print author
		if xline.rfind("LONGTITLE:") != -1:
			title = xline[11:len(xline)-1]
			#print xline
			print title
	xx.close()
	#DC Metadata (include title & author)
	dcmeta = putintags("Title", title) + putintags("Description", author) + putintags("Date", "2007-01-01T00:00:00")
	dcmeta = putintags("dc-metadata", dcmeta)
	#y-metadata
	ymeta = putintags("image", imgname) + putintags("startpage", fname) + putintags("version", "000") + putintags("ItemSize", "000")
	ymeta = putintags("y-metadata", ymeta)
	#the long row
	longrow = putintags("package", putintags("metadata", dcmeta + ymeta))
	manifest.write(longrow + "\n")
	manifest.close()

def createdirs(path, img):
	# legge la dir dei file nella path, e ne mette i nomi in una lista.
	a = 0
	dirList=os.listdir(path)
	for fname in dirList:
		if fname.endswith(".prc") or fname.endswith(".mobi"):
			a = a + 1
			newname = str(a) + ".mobi"
			os.rename(fname, newname)
			logwrite("ren " + newname + " " + fname + "\n")
			os.mkdir(fname)
			dst = os.path.join(path, fname, fname)
			os.rename(newname, dst)
			shutil.copy("mobi2mobi.exe", os.path.join(path, fname, "mobi2mobi.exe"))
			os.chdir(os.path.join(path, fname))
			print os.getcwd()
			createmanifest(fname, img)
			os.remove("mobi2mobi.exe")
			os.chdir("..");

# Main Function
print "\nMobi2Dir v0.01. Copyright (c) 2008 Nicola Giani"
print "mobi2mobi is part of Mobiperl, by tompe - https://dev.mobileread.com/trac/mobiperl/wiki\n\n"
# parse della linea di comando
parser = OptionParser(usage="mobi2dirs -p <path> -i <image name>")
parser.add_option("-p", "--pathname", dest="pathname", help="Path where mobi files are", metavar="PATH")
parser.add_option("-i", "--imgname", dest="imgname", help="Name of the cover image file (the same for every book)", metavar="IMG")
parser.set_defaults(pathname=os.getcwd())
parser.set_defaults(imgname=".c.jpg")
(options, args) = parser.parse_args()

# controllo degli argomenti e indicazione dei default
p = options.pathname
j = options.imgname

if not os.path.exists(p):
	p = os.getcwd()

os.chdir(p)

createdirs(p, j)
