#!/usr/bin/env python
# -*- coding: utf-8 -*-

import tkinter as tk                #Essential for custom dialog box using tk. commands
import tkinter.ttk as tkinter_ttk    #Essential for ttk. commands
from tkinter import *                #Essential for root = Tk()
from tkinter import messagebox        #Essential for messagebox
import re

"""
PURPOSE
=======
This class will strip all tags from a title line and add the required <h> tags.
It can also insert a Sigil Split Marker if required.

"""

class Chapters:
    cs = chapterStatus = {
    "CurrentTag": "p",
    "RequiredTag" : "h1",
    "ChapterFormat" : "T",
    "Splitter" : False,
    "Text case" : "Title case",
    "ProcessSecondLine" : False,
    "SecondCurrentLineTag" :"p",
    "RequiredSecondLineTag" :"h2",
    "RequiredSecondLineCase" : "Title case",
    "LowerRomanCase" : False,
    "ProcessChapter" : False  #If function called without setting values then processing will not take place
    }       

    dlgTop=""   #Needed for external program to destroy the dialog window
    
    def __init__(self):
        pass    #Dummy - does nothing
        
    def ShowDialogBox(self, parent):
        """
        Called by an external module.
        Parent is the window that owns this dialog.
        """
        self.top = tk.Toplevel(parent)
        Chapters.dlgTop=self.top #Needed for external program to destroy the dialog window
        self.top.grab_set() #Make dialog box modal
        self.top.title("Format chapter titles") #Title for dialog box
        mainframe = ttk.Frame(self.top, padding="15 15 12 12") #replace root with top
        mainframe.grid(column=2, row=1, sticky=(N, W, E, S))
        mainframe.columnconfigure(0, weight=1)
        mainframe.rowconfigure(0, weight=1)
            
        cbTags = ("p", "h1", "h2","h3", "h4","h5", "h6")

        mainframe.columnconfigure(1, minsize=50)
        separator1 = ttk.Frame(mainframe, width=1, relief=SUNKEN)
        separator1.grid(column=1, row=1, rowspan=7, sticky=(N,S))

        mainframe.columnconfigure(3, minsize=50)
        separator2 = ttk.Frame(mainframe, width=1, relief=SUNKEN)
        separator2.grid(column=3, row=1, rowspan=8, sticky=(N,S))

        tk.Label(mainframe, text = "General", fg="blue").grid(column = 0, row=0, sticky = N)
        tk.Label(mainframe, text = "First line of Chapter", fg="blue").grid(column = 2, row=0, sticky = N)
        tk.Label(mainframe, text = "Second line of Chapter", fg="blue").grid(column = 4, row=0, sticky = N)

        tk.Label(mainframe, text = "Select tag used for chapters").grid(column = 2, row=1, sticky = W)
        self.cbox=ttk.Combobox(mainframe, state = "readonly", values = cbTags, exportselection = 0)	
        self.cbox.grid(column=2, row=2, sticky=W)	#Needs to be on a separate line, unlike checkboxes????
        self.cbox.set(Chapters.chapterStatus["CurrentTag"])					#Set default value

        tk.Label(mainframe, text="Select tag required for chapters").grid(column=2, row=3, sticky=W)
        self.cbox1=ttk.Combobox(mainframe, state = "readonly", values = cbTags, exportselection = 0)	
        self.cbox1.grid(column=2, row=4, sticky=W)	#Needs to be on a separate line, unlike checkboxes????
        self.cbox1.set(Chapters.chapterStatus["RequiredTag"])					#Set default value
       
        cbTextCase = ("Title case", "Uppercase", "Capitalise first character only")
        
        tk.Label(mainframe, text = "Required case:").grid(column=2, row=5, sticky = W)
        self.cbox2=ttk.Combobox(mainframe, state = "readonly", values = cbTextCase, exportselection = 0)	
        self.cbox2.grid(column=2, row=6, sticky=W)	#Needs to be on a separate line, unlike checkboxes????
        self.cbox2.set(Chapters.chapterStatus["Text case"])					#Set default value

        tk.Label(mainframe, text="Select the format for chapters in the ebook").grid(column=0, row=1, sticky=W)

        self.radioVar = StringVar()
        ChapterStyle = [("Text","T"), ("Numeric","N")]
        self.radioVar.set("T") # initialize -  essential to prevent both buttons from being selected at start
        count=0
        for strtext, myStyle in ChapterStyle:
            rb = Radiobutton(mainframe, text=strtext, variable=self.radioVar, value=myStyle)
            rb.grid(column=0, row=count+2, sticky=W)
            count = count+1
        
        self.chkLowerRomanNumerals = IntVar()
        ttk.Checkbutton(mainframe, text='Use lower case Roman numerals', 
        variable = self.chkLowerRomanNumerals).grid(column=0, row=4, sticky=W)
        self.chkLowerRomanNumerals.set(Chapters.chapterStatus["LowerRomanCase"])      
        
        self.chkAddSplitter = IntVar()
        ttk.Checkbutton(mainframe, text='Insert chapter breaks', 
        variable = self.chkAddSplitter).grid(column=0, row=5, sticky=W)
        self.chkAddSplitter.set(Chapters.chapterStatus["Splitter"])       
 
        self.chkProcessSubTitle = IntVar()
        ttk.Checkbutton(mainframe, text='Chapter title covers two lines', 
        variable = self.chkProcessSubTitle, command=self.cbProcessSubTitle).grid(column=4, row=1, sticky=W)
        self.chkProcessSubTitle.set(Chapters.chapterStatus["ProcessSecondLine"])       

        self.label3 = tk.Label(mainframe, text = "Tag for second line is:")
        self.label3.grid(column = 4, row=2, sticky = W)#Must be separate from above line so .config() will work
        self.cbox3=ttk.Combobox(mainframe, state = "readonly", values = cbTags, exportselection = 0)	
        self.cbox3.grid(column=4, row=3, sticky=W)	#Needs to be on a separate line, unlike checkboxes????
        self.cbox3.set(Chapters.chapterStatus["SecondCurrentLineTag"])					#Set default value

        self.label4 = tk.Label(mainframe, text = "Required tag for second line is:")
        self.label4.grid(column = 4, row=4, sticky = W)
        self.cbox4=ttk.Combobox(mainframe, state = "readonly", values = cbTags, exportselection = 0)	
        self.cbox4.grid(column=4, row=5, sticky=W)	#Needs to be on a separate line, unlike checkboxes????
        self.cbox4.set(Chapters.chapterStatus["RequiredSecondLineTag"])					#Set default value
        
        self.label5 = tk.Label(mainframe, text = "Required case for second line is:")
        self.label5.grid(column = 4, row=6, sticky = W)
        self.cbox5=ttk.Combobox(mainframe, state = "readonly", values = cbTextCase, exportselection = 0)	
        self.cbox5.grid(column=4, row=7, sticky=W)	#Needs to be on a separate line, unlike checkboxes????
        self.cbox5.set(Chapters.chapterStatus["RequiredSecondLineCase"])					#Set default value

        tk.Button(mainframe, text="OK", command=self.OK, width = 20).grid(column=0, row=13, sticky=W)
        tk.Button(mainframe, text="Cancel", command=self.Cancel, width = 20).grid(column=2, row=13, sticky=W)
        
        self.cbProcessSubTitle()

        self.top.bind('<Return>', self.OKPressed)
        self.top.bind('<Escape>', self.EscapePressed)

    def OKPressed(self, event):
        self.OK()

    def EscapePressed(self, event):
        self.Cancel()
##        
    def lowerTitleCaseWords(self, chap):
        """
        When titlecase is chosen in the dialog, this function puts some standard words in lower case
        Also this calls setRomanCase() to set the case of any Roman numerals that are found
        Regardless of Roman case, it sets the lone character i to I
        """
        chap = chap.title()
        strPart=chap.partition(" ")
        chap=strPart[0]+strPart[2]	#strPart[0] is the first word in the title - its first letter must be uppercas
             
        if strPart[2] !="":    #Replace letters that are usually not uppercase in title strings
            strTemp=strPart[2]
            strTemp=strTemp.replace(" The ", " the ")
            strTemp=strTemp.replace(" A ", " a ")
            strTemp=strTemp.replace(" As ", "  as ")
            strTemp=strTemp.replace(" In ", " in ")
            strTemp=strTemp.replace(" Of ", " of ")
            strTemp=strTemp.replace(" An ", " an ")
            strTemp=strTemp.replace(" And ", " and ")
            chap=strPart[0]+" "+strTemp
            
        chap=re.sub(r'(\b([x|v|i|X|V|I])+\b)', self.setRomanCase, chap)
        
        chap=re.sub(r' i ', ' I ', chap)
        return (chap)
        
    def setRomanCase(self, m):
        """
        Sets the case of a Roman number, passed in as paramter m
        Called by lowerTitleCaseWords()
        Case is determined by the value of the Boolean: Chapters.cs["LowerRomanCase"] 
        """
        if Chapters.cs["LowerRomanCase"] == True:
            return m.group(0).lower()
        else:
            return m.group(0).upper()
        
    def cbProcessSubTitle(self):
        """
        Called when the checkbox for the second line of the title is un/checked
        Also called by ShowDialogBox() to set the initial state of the comboboxes (to disabled)
        """
        #print ("CheckBox State: ", self.chkProcessSubTitle.get())
        if self.chkProcessSubTitle.get() == False:
            putState='disabled'
            cl="grey"
        else:
            putState='readonly'
            cl="black"
            
        self.cbox3.configure(state=putState)
        self.label3.configure(fg=cl) #This uses config, not configure
        self.cbox4.configure(state=putState)
        self.label4.config(fg=cl) #This uses config, not configure
        self.cbox5.configure(state=putState)
        self.label5.config(fg=cl) #This uses config, not configure
            
    def replaceChapLine1(self, m):
        """
        Called by processChapterTitle()
        This returns a replacement for the CHAPTER heading.
        It strips tags from the heading
        that has selected tags
        """
        if Chapters.cs["ChapterFormat"] == "T":
            chap= m.group(2)
        else:
            chap= m.group(3)
            
        while chap.find(">") !=-1:      #strip tags - will not work for tags inside tags
            chap=re.sub(r'<[^>]+>',  "", chap)

        if Chapters.cs["ChapterFormat"] != "T": #Option is set to text
            if not isinstance(chap, int):       #but a number has been found
                chap=m.group()
                while chap.find(">") !=-1:      #strip tags - will not work for tags inside tags
                    chap=re.sub(r'<[^>]+>',  "", chap)

        if Chapters.cs["Text case"]=="Uppercase": chap=chap.upper()

        if Chapters.cs["Text case"]=="Capitalise first character only": chap = chap.capitalize()

        if Chapters.cs["Text case"]=="Title case": chap = self.lowerTitleCaseWords(chap)
        
        chap = '<' + Chapters.cs["RequiredTag"] + '>' + chap + '</'+ Chapters.cs["RequiredTag"] + ">"
        if Chapters.cs["Splitter"]==True:  chap = '<hr class="sigil_split_marker" />' + chap     
        return (chap)

    def replaceChapLine2(self, m):
        
        chapLine2= m.group(3)
        while chapLine2.find(">") !=-1:      #strip tags from title - will not work for tags inside tags
            chapLine2=re.sub(r'<[^>]+>',  "", chapLine2)
        
        if Chapters.cs["RequiredSecondLineCase"]=="Uppercase": chapLine2=chapLine2.upper()
        if Chapters.cs["RequiredSecondLineCase"]=="Capitalise first character only": chapLine2 = chapLine2.capitalize()
        if Chapters.cs["RequiredSecondLineCase"]=="Title case": chapLine2 = self.lowerTitleCaseWords(chapLine2)
        
        chapLine2= m.group(1) +'\n<' + Chapters.cs["RequiredSecondLineTag"] + '>'+chapLine2+'</'+ Chapters.cs["RequiredSecondLineTag"] + ">"
        return(chapLine2)
        
    def processChapterTitle(self, html):
        """
        Called by an external module
        html is the html file to process
        This strips tags from the chapter line in the html file (Cannot cope with tags in tags!)
        and then adds the required tags to the chapter,
        including a Sigil SplitMarker if required
        """
        if Chapters.cs["ProcessChapter"]==True:
            searchStr="<"+Chapters.cs["CurrentTag"]+"(.*?)"
            if Chapters.cs["ChapterFormat"] == "T":
                searchStr=searchStr + "(CHAPter(.*?))</"+Chapters.cs["CurrentTag"]+">" 
            else:
                searchStr=searchStr+">(\s+)?(\d\d?)(\s+)?</" + Chapters.cs["CurrentTag"]+">"
            searchStr = re.compile(searchStr,re.IGNORECASE)
            html=re.sub(searchStr, self.replaceChapLine1, html)
            
            if Chapters.cs["ProcessSecondLine"] == True:
                searchSubTitle='(</'+ Chapters.cs["RequiredTag"] + ">)\s+<"+Chapters.cs["SecondCurrentLineTag"]+'(.*?)>'
                searchSubTitle= searchSubTitle+ '(.*?)</'+Chapters.cs["SecondCurrentLineTag"]+'>'
                
                html=re.sub(searchSubTitle, self.replaceChapLine2, html)

            #Now remove the Sigil marker if it immediately follows a <body tag>
            html=re.sub(r'(<body(.*?)>)(\s+)?<hr class="sigil_split_marker" />', '\\1', html)

        return(html)
    
    def Cancel(self):
        Chapters.cs["ProcessChapter"] = False
        self.top.destroy()
    
    def OK(self):
        """
        Called by a button click in the method ShowDialogBox()
        This stores user selections in the static class dictionary
        and then destroys the window
        """
        Chapters.chapterStatus["CurrentTag"] = self.cbox.get()
        Chapters.chapterStatus["RequiredTag"] = self.cbox1.get()
        Chapters.chapterStatus["Text case"] = self.cbox2.get()
        Chapters.chapterStatus["Splitter"] = self.chkAddSplitter.get()
        Chapters.chapterStatus["ChapterFormat"] = self.radioVar.get()
        Chapters.chapterStatus["ProcessSecondLine"] = self.chkProcessSubTitle.get()
        Chapters.chapterStatus["SecondCurrentLineTag"] = self.cbox3.get()
        Chapters.chapterStatus["RequiredSecondLineTag"] = self.cbox4.get()
        Chapters.chapterStatus["RequiredSecondLineCase"] = self.cbox5.get()
        Chapters.chapterStatus["LowerRomanCase"] = self.chkLowerRomanNumerals.get()
        Chapters.chapterStatus["ProcessChapter"] = True
        self.top.destroy()