#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
ShowMainWindow() is called by the main function.
When processHTMLFiles() is called, new code tries to determine the quote maarks used for speech.
Any other code that iterates through html files should form part of this loop for setting up the program.
The new code requires the module: config.sys
"""
import os, inspect	#needed to get Sigil plugin path
import sys
import re
import tkinter.ttk as tkinter_ttk	#Essential for ttk. commands
from tkinter import *				#Essential for root = Tk()
import tkinter as tk				#Essential for custom dialog box using tk. commands
from tkinter import messagebox		#Essential for messagebox
from tkinter import filedialog		#Essential for file dialog box

import SpanTagProcessor
import GenUtils						#Need centerWindow()
import HTMLProcessor
import config						#used for identifying common quote marks
from Chapter import Chapters
import ImageMod
from ProcessHeaderTags  import cProcessHeaderTags

text_type = str
characterize = chr

def getWordList(prefs):
	prefs['WordListDirectory']  = filedialog.askopenfilename()

def GetDictPath():
	# get plugin directory path
	plugin_path = os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe())))
	#print(plugin_path)
    
	# get rid of the last two directories
	tmp_path = os.path.dirname(os.path.dirname(plugin_path))
	#print(tmp_path)
    
	# add the dictionary path
	dictionary_path = os.path.join(tmp_path, 'user_dictionaries', 'WordDictionary.txt')
	#print(dictionary_path)
	return(dictionary_path)

def showImageDialog(root,  bk):
	if ImageMod.importPILFlag:
		imageDialog = ImageMod.dlgImage()
		imageDialog.ShowDialogBox(root,bk)
		root.wait_window(dlgImage.dlgTop)
	else:
		print("PIL not found - cannot process images")

def GetHeaderTagOptions(root,  bk):
	processHeaderTagsDlg = cProcessHeaderTags()
	processHeaderTagsDlg.showHeadtagsDlg(root)
	GenUtils.centerWindow(processHeaderTagsDlg.top)		#Centre dialog
	root.wait_window(processHeaderTagsDlg.top)

def GetChapterOptions(root):
	chapDialog = Chapters()
	chapDialog.ShowDialogBox(root)
	GenUtils.centerWindow(Chapters.dlgTop)		#Centre dialog
	root.wait_window(Chapters.dlgTop)

def processHTMLFiles(root, lbox, bk, prefs):
	SelectedHtmlList=[]
	IDlist = []
	quoteDict={}

	SelectedHtmlList = [lbox.get(idx) for idx in lbox.curselection()]
	if not SelectedHtmlList:
		messagebox.showwarning('WARNING','You must select the files to process from the listbox')
		return

	for (id, href) in bk.text_iter():			#For each html file in the 'text' section of the epbub
		if (href) in SelectedHtmlList:
			IDlist.append(id)

		#Process other items for all html files here eg type of quotes used

		html = bk.readfile(id)					#Read the section into html
		if not isinstance(html, text_type):		#If the section is not str
			html = text_type(html, 'utf-8')		#then sets its type to 'utf-8'
		html_orig = html						#Copy the result to html_orig
		quoteDict["SingleCurlyQuoteCount"]=quoteDict.get("SingleCurlyQuoteCount",0)+html.count("‘")
		quoteDict["DoubleCurlyQuoteCount"]=quoteDict.get("DoubleCurlyQuoteCount",0)+html.count('“')
		quoteDict["StraightSingleQuoteCount"]=quoteDict.get("StraightSingleQuoteCount",0)+html.count("'")
		quoteDict["StraightDoubleQuoteCount"]=quoteDict.get("StraightDoubleQuoteCount",0)+html.count('"')

	config.setQuotes(quoteDict)

	if prefs['ProcessSpanTags'] == 'Yes':
		SpanTagProcessor.ProcessTags(root, SelectedHtmlList, bk, prefs, IDlist)
	HTMLProcessor.processHTML(bk, prefs, IDlist)
	root.quit()
	return(0)

def ShowMainWindow(bk, prefs):
	"""
	This function is called automatically by the main function
	This function displays the main window showing a listbox containing the html files in the ePub file.
	It contains buttons to enable the user to run required processes.
	After building the window with its widgets, centerWindow is called to centre this window
	"""
	def Go(root, lbox, bk, prefs):
		prefs['JoinParagraphs'] = chkJoinParagraphs.get()
		prefs['ReplaceHTMLCode'] = chkReplaceHTMLCode.get()
		prefs['ProcessItalics'] = chkProcessItalics.get()
		prefs['ProcessSpanTags'] = chkProcessSpanTags.get()

		processHTMLFiles(root, lbox, bk, prefs)
		return 0

	root = Tk()
	root.withdraw()	#Hide window to avoid flashing when it is moved to the correct position

	prefs['DictFile']=GetDictPath()
	print (GetDictPath())

	root.title("Epub tidy")
	mainframe = ttk.Frame(root, padding="15 15 12 12")
	mainframe.grid(column=0, row=0, sticky=(N, W, E, S))
	mainframe.columnconfigure(0, weight=1)
	mainframe.rowconfigure(0, weight=1)

	ttk.Label(mainframe, text="Options").grid(column=3, row=1, sticky=W, rowspan=10)
	optionFrame=ttk.Frame(mainframe,padding="5 5 5 5")
	optionFrame.grid(column=3, row=1, sticky=(N, W, E, S))

	ttk.Label(mainframe, text="Select parts to process").grid(column=0, row=0, sticky=W, rowspan=10)
	lbox = Listbox(mainframe, height=15, width=50, selectmode=EXTENDED, exportselection=0)
	lbox.grid(column=0, row=1, sticky=(N,S,E,W))
	scroller = ttk.Scrollbar(mainframe, orient=VERTICAL, command=lbox.yview)
	scroller.grid(column=1, row=1, sticky=(N,S,W))
	lbox.configure(yscrollcommand=scroller.set)

	for (id, href) in bk.text_iter():				#For each html file in the 'text' section of the epbub
		lbox.insert(END, href)						#Append the HTML file name to the list box

	chkJoinParagraphs = StringVar()
	chkReplaceHTMLCode = StringVar()
	chkProcessItalics = StringVar()
	chkProcessSpanTags = StringVar()

	chkJoinParagraphs.set(prefs['JoinParagraphs'])
	chkReplaceHTMLCode.set(prefs['ReplaceHTMLCode'])
	chkProcessItalics.set(prefs['ProcessItalics'])
	chkProcessSpanTags.set(prefs['ProcessSpanTags'])

	check = ttk.Checkbutton(optionFrame, text='Fix ALL broken line endings', 
	    variable=chkJoinParagraphs,
	    onvalue='Yes', offvalue='No').grid(column=3, row=1, sticky=W)

	check = ttk.Checkbutton(optionFrame, text='Replace HTML eg &nsbc;', 
	    variable=chkReplaceHTMLCode,
	    onvalue='Yes', offvalue='No').grid(column=3, row=2, sticky=W)

	check = ttk.Checkbutton(optionFrame, text='Process italics', 
	    variable=chkProcessItalics,
	    onvalue='Yes', offvalue='No').grid(column=3, row=3, sticky=W)

	check = ttk.Checkbutton(optionFrame, text='Process span tags', 
	    variable=chkProcessSpanTags,
	    onvalue='Yes', offvalue='No').grid(column=3, row=4, sticky=W)

	ttk.Label(optionFrame, text="").grid(column=3, row=5, sticky=W,) #Blank row

	ttk.Button(optionFrame, text='Process header tags', command=lambda: GetHeaderTagOptions(root,  bk)).grid(column=3, row=7, sticky=W)
	ttk.Button(optionFrame, text="Options for chapter titles", command=lambda: GetChapterOptions(root)).grid(column=3, row=6, sticky=W)
	ttk.Button(optionFrame, text="Use word list", command=lambda: getWordList(prefs)).grid(column=3, row=8, sticky=W)

	ttk.Button(mainframe, text='Resize image', command=lambda: showImageDialog(root,  bk)).grid(column=4, row=10, sticky=W)
	ttk.Button(mainframe, text="Process text", command=lambda: Go(root, lbox, bk, prefs)).grid(column=3, row=10, sticky=W)
	ttk.Button(mainframe, text="Close", command=root.quit).grid(column=0, row=10, sticky=W)
	for child in mainframe.winfo_children(): child.grid_configure(padx=5, pady=5) 
	GenUtils.centerWindow(root)		#Centre main window and show it
	root.mainloop()
	return ()

def run(bk):
	prefs = bk.getPrefs()	    # Get preferences from json file

	if not 'JoinParagraphs' in prefs: prefs['JoinParagraphs']  = 'No'
	if not 'ReplaceHTMLCode' in prefs: prefs['ReplaceHTMLCode']  = 'No'
	if not 'ProcessItalics' in prefs: prefs['ProcessItalics']  = 'No'
	if not 'ProcessSpanTags' in prefs: prefs['ProcessSpanTags']  = 'No'
	if not 'WordListDirectory' in prefs: prefs['WordListDirectory']  = ''

	ShowMainWindow(bk,prefs)			#show the main window

	bk.savePrefs(prefs)				#Save user preferences to a json file

	return 0		#0 - means success, anything else means failure

def main():
    print ("I reached main when I should not have\n")
    return -1
    
if __name__ == "__main__":
    sys.exit(main())