#!/usr/bin/env python
# -*- coding: utf-8 -*-

# This unit contains global values with the functions that set their values
# Global variables in this module can be accessed from other modules by putting config. before their name eg config.OpenQ

global OpenQ, CloseQ, Apostrophe	#Used for quote marks

def setQuotes(quoteDict):
	"""
	This function sets the quote marks that are to be used for speech
	The parameter is  dictionary that contains each quote and the number of times it occurs in the book
	The most frequewnt quote mark is " since this appears in tags etc.
	Consequently, the function checks to see whether there are significant numbers of other quotes; if not the
	quotes used for open/closing speeches is set to "
	"""
	global OpenQ, CloseQ, Apostrophe
	Apostrophe = "'"
	if quoteDict.get("SingleCurlyQuoteCount") > 200:
		OpenQ = "‘"
		CloseQ = "’"
		Apostrophe = "’"
	elif quoteDict.get("StraightSingleQuoteCount") > 200:
		OpenQ = "'"
		CloseQ = "'"
	elif quoteDict.get("DoubleCurlyQuoteCount") > 200:
		OpenQ = '“'
		CloseQ = '”'
		Apostrophe = "’"
	else:		#These are common to many tags, so can dominate all the other quotes, even if others are used for speech marks
		OpenQ = '"'
		CloseQ = '"'
	return(0)

