/*
 * Decompiled with CFR 0.152.
 */
package mobitag;

import java.io.File;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import mobitag.BookFolder;
import mobitag.MobiTag;

public class Utils {
    private static BookFolder rootFolder = null;
    private static ArrayList<String> currentTags = null;
    private static DefaultListModel defaultListModel = null;
    private static MobiTag.MobiSwingWorker w = null;
    private static ImageIcon img = null;
    public static final int LOG_TRACE = 0;
    public static final int LOG_DEBUG = 1;
    public static final int LOG_WARNING = 2;
    public static final int LOG_ERROR = 3;
    public static final int LOG_NONE = 4;
    private static final String LOG_FILE = "MobiTag.log";
    private static final int LOG_LEVEL = 2;
    public static final String LARGE_BOOK_ICON_FILE = "images/booklarge.png";
    public static final String SMALL_BOOK_ICON_FILE = "images/book.png";
    public static final String THREAD_URL = "http://www.mobileread.com/forums/showthread.php?p=1927698";
    public static final String APP_NAME = "MobiTag";

    public static BookFolder getRootFolder() {
        return rootFolder;
    }

    public static void setRootFolderFile(File file) {
        Utils.setRootFolderFile(file, null);
    }

    public static void setRootFolderFile(File file, MobiTag.MobiSwingWorker w) {
        rootFolder = new BookFolder(file, w);
    }

    public static void setRootFolder(BookFolder rootFolder) {
        Utils.rootFolder = rootFolder;
    }

    public static File getRootFolderFile() {
        return null == rootFolder ? null : rootFolder.getBookFolderFile();
    }

    public static ArrayList<String> getCurrentTags() {
        return currentTags;
    }

    public static void setCurrentTags(ArrayList<String> currentTags) {
        Utils.currentTags = currentTags;
    }

    public static DefaultListModel getDefaultListModel() {
        return defaultListModel;
    }

    public static void setDefaultListModel(DefaultListModel defaultListModel) {
        Utils.defaultListModel = defaultListModel;
    }

    public static ImageIcon getImg() {
        return img;
    }

    public static void setImg(ImageIcon img) {
        Utils.img = img;
    }

    public static int getNumberOfFiles(File srcDir) {
        int count = 0;
        File[] listFiles = srcDir.listFiles();
        for (int i = 0; i < listFiles.length; ++i) {
            if (listFiles[i].isDirectory()) {
                count += Utils.getNumberOfFiles(listFiles[i]);
                continue;
            }
            if (!listFiles[i].isFile() || !listFiles[i].getName().endsWith(".mobi")) continue;
            ++count;
        }
        return count;
    }

    public static void log(String message, int level) {
        if (level >= 2) {
            String s = null;
            try {
                FileWriter fw = null;
                fw = new FileWriter(new File(LOG_FILE), true);
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss");
                Calendar cal = Calendar.getInstance();
                s = dateFormat.format(cal.getTime()) + ": " + message + "\n";
                fw.write(s);
                System.out.print(s);
                fw.flush();
                fw.close();
            }
            catch (Exception e) {
                System.out.print("Exception '" + e.getMessage() + "' generated trying to write message '" + message + "' to log file '" + LOG_FILE + "'.");
            }
        }
    }

    public static String getRecordTypeString(String type) {
        return Utils.getRecordTypeString(Integer.valueOf(type));
    }

    public static String getRecordTypeString(int type) {
        String result = null;
        switch (type) {
            case 1: {
                result = "drm_server_id";
                break;
            }
            case 2: {
                result = "drm_commerce_id";
                break;
            }
            case 3: {
                result = "drm_ebookbase_book_id";
                break;
            }
            case 100: {
                result = "author";
                break;
            }
            case 101: {
                result = "publisher";
                break;
            }
            case 102: {
                result = "imprint";
                break;
            }
            case 103: {
                result = "description";
                break;
            }
            case 104: {
                result = "isbn";
                break;
            }
            case 105: {
                result = "tags";
                break;
            }
            case 106: {
                result = "publishingdate";
                break;
            }
            case 107: {
                result = "review";
                break;
            }
            case 108: {
                result = "contributor";
                break;
            }
            case 109: {
                result = "rights";
                break;
            }
            case 110: {
                result = "subjectcode";
                break;
            }
            case 111: {
                result = "type";
                break;
            }
            case 112: {
                result = "source";
                break;
            }
            case 113: {
                result = "asin";
                break;
            }
            case 114: {
                result = "versionnumber";
                break;
            }
            case 115: {
                result = "sample";
                break;
            }
            case 116: {
                result = "startreading";
                break;
            }
            case 117: {
                result = "adult";
                break;
            }
            case 118: {
                result = "retail price";
                break;
            }
            case 119: {
                result = "retail price currency";
                break;
            }
            case 121: {
                result = "KF8 BOUNDARY Offset";
                break;
            }
            case 125: {
                result = "count of resources";
                break;
            }
            case 129: {
                result = "KF8 cover URI";
                break;
            }
            case 131: {
                result = "Unknown";
                break;
            }
            case 200: {
                result = "Dictionary short name";
                break;
            }
            case 201: {
                result = "coveroffset";
                break;
            }
            case 202: {
                result = "thumboffset";
                break;
            }
            case 203: {
                result = "hasfakecover";
                break;
            }
            case 204: {
                result = "Creator Software";
                break;
            }
            case 205: {
                result = "Creator Major Version";
                break;
            }
            case 206: {
                result = "Creator Minor Version";
                break;
            }
            case 207: {
                result = "Creator Build Number";
                break;
            }
            case 208: {
                result = "watermark";
                break;
            }
            case 209: {
                result = "tamper proof keys";
                break;
            }
            case 300: {
                result = "fontsignature";
                break;
            }
            case 401: {
                result = "clippinglimit";
                break;
            }
            case 402: {
                result = "publisherlimit";
                break;
            }
            case 403: {
                result = "Unknown";
                break;
            }
            case 404: {
                result = "ttsflag";
                break;
            }
            case 405: {
                result = "Unknown";
                break;
            }
            case 406: {
                result = "Rent/Borrow Expiration Date";
                break;
            }
            case 407: {
                result = "Unknown";
                break;
            }
            case 450: {
                result = "Unknown";
                break;
            }
            case 451: {
                result = "Unknown";
                break;
            }
            case 452: {
                result = "Unknown";
                break;
            }
            case 453: {
                result = "Unknown";
                break;
            }
            case 501: {
                result = "cdetype";
                break;
            }
            case 502: {
                result = "lastupdatetime";
                break;
            }
            case 503: {
                result = "updatedtitle";
                break;
            }
            case 504: {
                result = "asin";
                break;
            }
            case 524: {
                result = "language";
                break;
            }
            case 525: {
                result = "alignment";
                break;
            }
            case 535: {
                result = "Creator Build Number";
                break;
            }
            case 547: {
                result = "InMemory";
                break;
            }
            default: {
                result = "Unknown";
            }
        }
        return result;
    }
}

