/*
 * Decompiled with CFR 0.152.
 */
package mobitag;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import mobitag.Props;

public class Preferences
extends JDialog {
    private ButtonGroup buttonGroupLogLevel;
    private ButtonGroup buttonGroupShowBooksWithNoTags;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JCheckBox jCheckBoxAutoRefresh;
    private JCheckBox jCheckBoxBackupOriginal;
    private JCheckBox jCheckBoxExpandBooks;
    private JCheckBox jCheckBoxRequireConfirmation;
    private JCheckBox jCheckBoxShowTooltips;
    private JPanel jPanel1;
    private JRadioButton jRadioButtonAlways;
    private JRadioButton jRadioButtonNever;
    private JRadioButton jRadioButtonNoTagsSelected;

    public Preferences(Frame parent) {
        super(parent, true);
        this.initComponents();
        this.pack();
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("images/book.png")));
        Rectangle parentBounds = parent.getBounds();
        Dimension size = this.getSize();
        int x = Math.max(0, parentBounds.x + (parentBounds.width - size.width) / 2);
        int y = Math.max(0, parentBounds.y + (parentBounds.height - size.height) / 2);
        this.setLocation(new Point(x, y));
        this.jCheckBoxExpandBooks.setSelected(Props.getExpandBooks());
        this.jCheckBoxRequireConfirmation.setSelected(Props.getRequireConfirmation());
        this.jCheckBoxAutoRefresh.setSelected(Props.getAutoRefresh());
        this.jCheckBoxBackupOriginal.setSelected(Props.getBackupOriginal());
        this.jCheckBoxShowTooltips.setSelected(Props.getShowTooltips());
        switch (Props.getShowBooksNoTags()) {
            case 2: {
                this.jRadioButtonNoTagsSelected.setSelected(true);
                break;
            }
            case 1: {
                this.jRadioButtonNever.setSelected(true);
                break;
            }
            default: {
                this.jRadioButtonAlways.setSelected(true);
            }
        }
    }

    private void initComponents() {
        this.buttonGroupShowBooksWithNoTags = new ButtonGroup();
        this.buttonGroupLogLevel = new ButtonGroup();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jCheckBoxExpandBooks = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.jRadioButtonAlways = new JRadioButton();
        this.jRadioButtonNever = new JRadioButton();
        this.jRadioButtonNoTagsSelected = new JRadioButton();
        this.jCheckBoxRequireConfirmation = new JCheckBox();
        this.jCheckBoxAutoRefresh = new JCheckBox();
        this.jCheckBoxBackupOriginal = new JCheckBox();
        this.jCheckBoxShowTooltips = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setTitle("MobiTag Preferences");
        this.setResizable(false);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Preferences.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Preferences.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jCheckBoxExpandBooks.setText("Expand book list by default");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Show Books With No Tags"));
        this.buttonGroupShowBooksWithNoTags.add(this.jRadioButtonAlways);
        this.jRadioButtonAlways.setSelected(true);
        this.jRadioButtonAlways.setText("Always");
        this.buttonGroupShowBooksWithNoTags.add(this.jRadioButtonNever);
        this.jRadioButtonNever.setText("Never");
        this.buttonGroupShowBooksWithNoTags.add(this.jRadioButtonNoTagsSelected);
        this.jRadioButtonNoTagsSelected.setText("When no tags selected");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonNever).addComponent(this.jRadioButtonAlways).addComponent(this.jRadioButtonNoTagsSelected)).addGap(0, 0, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jRadioButtonAlways).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonNever).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonNoTagsSelected).addContainerGap(-1, Short.MAX_VALUE)));
        this.jCheckBoxRequireConfirmation.setText("Require confirmation on tag clear");
        this.jCheckBoxAutoRefresh.setText("Auto refresh on tag check/uncheck");
        this.jCheckBoxBackupOriginal.setText("Create a backup of modified files");
        this.jCheckBoxShowTooltips.setText("Show tooltips");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxShowTooltips).addComponent(this.jCheckBoxBackupOriginal).addComponent(this.jCheckBoxExpandBooks).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jCheckBoxRequireConfirmation, GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxAutoRefresh, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE))).addContainerGap(-1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxExpandBooks).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxRequireConfirmation).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxAutoRefresh).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxBackupOriginal).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxShowTooltips).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOK)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        int showNoTags = 0;
        showNoTags = this.jRadioButtonNoTagsSelected.isSelected() ? 2 : (this.jRadioButtonNever.isSelected() ? 1 : 0);
        Props.setExpandBooks(this.jCheckBoxExpandBooks.isSelected());
        Props.setRequireConfirmation(this.jCheckBoxRequireConfirmation.isSelected());
        Props.setAutoRefresh(this.jCheckBoxAutoRefresh.isSelected());
        Props.setBackupOriginal(this.jCheckBoxBackupOriginal.isSelected());
        Props.setShowBooksNoTags(showNoTags);
        Props.setShowTooltips(this.jCheckBoxShowTooltips.isSelected());
        Props.setProperties();
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(Preferences.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(Preferences.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(Preferences.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(Preferences.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Preferences dialog = new Preferences(new JFrame());
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

