/*
 * Decompiled with CFR 0.152.
 */
package mobitag;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.SplashScreen;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import mobitag.About;
import mobitag.BookFile;
import mobitag.BookFolder;
import mobitag.CheckBoxList;
import mobitag.CheckBoxListEntry;
import mobitag.Counter;
import mobitag.Edit;
import mobitag.Preferences;
import mobitag.Props;
import mobitag.TagList;
import mobitag.Utils;

public class MobiTag
extends JFrame {
    private static final int EMPTY_ONLY = 0;
    public static final int REFRESH_BOOKS_SHOWN_FROM_TAGS_READ = 1;
    private static final int REREAD_TAGS_FROM_READ_FILES = 2;
    private static final int REREAD_BOOKS_FROM_FILES = 3;
    private static final int VIEW = 0;
    private static final int EDIT = 1;
    private static final int CLEAR = 2;
    private static int numberOfBooks = 0;
    private static BookFile lastSelectedNode = null;
    private static int numberOfBooksRead = 0;
    static SplashScreen splashScreen;
    static Graphics2D splashGraphics;
    static Rectangle2D.Double splashTextArea;
    static Rectangle2D.Double splashProgressArea;
    static Font font;
    public JPopupMenu popup;
    private ButtonGroup buttonGroupAndOr;
    private CheckBoxList checkBoxListTags;
    private JButton jButtonAbout;
    private JButton jButtonBrowse;
    private JButton jButtonCollapseAll;
    private JButton jButtonEditAll;
    private JButton jButtonEditSelected;
    private JButton jButtonExit;
    private JButton jButtonExpandAll;
    private JButton jButtonPreferences;
    private JButton jButtonRefresh;
    private JButton jButtonSelectAll;
    private JButton jButtonSelectNone;
    private JLabel jLabelBooks;
    private JLabel jLabelPath;
    private JLabel jLabelPathText;
    private JLabel jLabelSelected;
    private JLabel jLabelShowing;
    private JLabel jLabelTagsSelected;
    private JMenuItem jMenuItemClearTags;
    private JMenuItem jMenuItemEditTags;
    private JMenuItem jMenuItemViewTags;
    private JPanel jPanel1;
    private JPanel jPanelBooks;
    private JPanel jPanelTags;
    private JPopupMenu jPopupMenu;
    private JRadioButton jRadioButtonAndBookTags;
    private JRadioButton jRadioButtonAndSelectedTags;
    private JRadioButton jRadioButtonOrTags;
    private JScrollPane jScrollPaneFiles;
    private JScrollPane jScrollPaneTags;
    private JPopupMenu.Separator jSeparator1;
    private JTree jTreeBooks;

    public MobiTag() {
        String rootFolderFileName = null;
        MobiTag.splashInit();
        this.initComponents();
        ImageIcon img = this.createImageIcon("images/booklarge.png", null);
        Utils.setImg(img);
        this.setBooksFoundLabel();
        this.setBooksSelectedLabel();
        this.jLabelTagsSelected.setText(null);
        this.jTreeBooks.getSelectionModel().setSelectionMode(4);
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("images/book.png")));
        this.setLocationRelativeTo(null);
        ImageIcon leafIcon = MobiTag.createImageIcon("images/book.png");
        DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)this.jTreeBooks.getCellRenderer();
        renderer.setLeafIcon(leafIcon);
        Props.getProperties();
        int andOrTags = Props.getAndOrTags();
        switch (andOrTags) {
            case 1: {
                this.jRadioButtonAndBookTags.setSelected(true);
                break;
            }
            case 2: {
                this.jRadioButtonAndSelectedTags.setSelected(true);
                break;
            }
            default: {
                this.jRadioButtonOrTags.setSelected(true);
            }
        }
        this.ableTooltips(Props.getShowTooltips());
        rootFolderFileName = Props.getRootFolderValue();
        if (null != rootFolderFileName && 0 < rootFolderFileName.length()) {
            File test = new File(rootFolderFileName);
            if (test.exists()) {
                numberOfBooks = Utils.getNumberOfFiles(test);
                this.jLabelPathText.setText(rootFolderFileName);
                this.readData(3, rootFolderFileName);
            } else {
                this.readData(0);
            }
        } else {
            this.readData(0);
        }
        this.ableMiscellany(true);
        if (splashScreen != null) {
            splashScreen.close();
        }
    }

    private void ableTooltips(boolean able) {
        this.jButtonBrowse.setToolTipText(able ? "Browse for the directory containing your ebooks" : null);
        this.jButtonEditAll.setToolTipText(able ? "Edit the metadata of all ebooks" : null);
        this.jButtonCollapseAll.setToolTipText(able ? "Collapse all elements in the eBooks tree" : null);
        this.jButtonEditSelected.setToolTipText(able ? "Edit the metadata of the selected ebook(s)" : null);
        this.jButtonExpandAll.setToolTipText(able ? "Expand all elements in the eBooks tree" : null);
        this.jButtonSelectAll.setToolTipText(able ? "Select all tags in the Tags list" : null);
        this.jButtonSelectNone.setToolTipText(able ? "De-select all tags in the Tags list" : null);
        this.jButtonRefresh.setToolTipText(able ? "Refresh the Files tree. Only required if auto-refresh is not enabled" : null);
        this.jLabelPathText.setToolTipText(able ? "The fully-qualified path of the folder containing your ebooks" : null);
        this.jRadioButtonAndBookTags.setToolTipText(able ? "<html>If selected, books are displayed in the Books tree if <b><i>all</i></b> of<br>their tags correspond to <b><i>any</i></b> of the selected tags in the Tags list</html>" : null);
        this.jRadioButtonAndSelectedTags.setToolTipText(able ? "<html>If selected, books are displayed in the Books tree if <b><i>any</i></b> of<br>their tags correspond to <b><i>all</i></b> of the selected tags in the Tags list</html>" : null);
        this.jRadioButtonOrTags.setToolTipText(able ? "<html>If selected, books are displayed in the Books tree if <b><i>any</i></b> of<br>their tags correspond to <b><i>any</i></b> of the selected tags in the Tags list</html>" : null);
    }

    private static void splashInit() {
        splashScreen = SplashScreen.getSplashScreen();
        if (splashScreen != null) {
            Dimension ssDim = splashScreen.getSize();
            int height = ssDim.height;
            int width = ssDim.width;
            splashTextArea = new Rectangle2D.Double(width / 2, (double)height * 0.9, width / 2 - 3, 32.0);
            splashGraphics = splashScreen.createGraphics();
            font = new Font("Tahoma", 1, 16);
            splashGraphics.setFont(font);
            MobiTag.splashText("Starting...");
        }
    }

    public static void splashText(String str) {
        if (splashScreen != null && splashScreen.isVisible()) {
            splashGraphics.setPaint(Color.WHITE);
            splashGraphics.fill(splashTextArea);
            splashGraphics.setPaint(Color.BLACK);
            FontMetrics fm = splashGraphics.getFontMetrics();
            int width = fm.stringWidth(str);
            splashGraphics.drawString(str, (int)(splashTextArea.getX() + (splashTextArea.getX() / 2.0 - (double)(width / 2))), (int)(splashTextArea.getY() + 15.0));
            splashScreen.update();
        }
    }

    public static void splashUpdate() {
        String text = null;
        DecimalFormat formatter = new DecimalFormat("#,###,###");
        text = ++numberOfBooksRead >= numberOfBooks ? "Tidying up..." : "Reading book " + formatter.format(numberOfBooksRead) + " out of " + formatter.format(numberOfBooks) + "...";
        MobiTag.splashText(text);
    }

    private void ableTreeViewButtons(boolean enable) {
        this.jButtonRefresh.setEnabled(enable && 1 < this.jTreeBooks.getRowCount());
        this.jButtonCollapseAll.setEnabled(enable && 1 < this.jTreeBooks.getRowCount());
        this.jButtonExpandAll.setEnabled(enable && 1 < this.jTreeBooks.getRowCount());
        this.jTreeBooks.setEnabled(enable);
        this.jPanelBooks.setEnabled(enable);
        this.jScrollPaneFiles.setEnabled(enable);
    }

    private void ableListViewButtons(boolean enable) {
        this.jButtonSelectAll.setEnabled(enable && 0 < Utils.getDefaultListModel().getSize());
        this.jButtonSelectNone.setEnabled(enable && 0 < Utils.getDefaultListModel().getSize());
        this.checkBoxListTags.setEnabled(enable);
        this.jPanelTags.setEnabled(enable);
        this.jScrollPaneTags.setEnabled(enable);
    }

    private void ableMiscellany(boolean enable) {
        this.jButtonAbout.setEnabled(enable);
        this.jButtonBrowse.setEnabled(enable);
        this.jButtonEditAll.setEnabled(enable && 1 < this.jTreeBooks.getRowCount());
        this.jButtonEditSelected.setEnabled(enable && 1 < this.jTreeBooks.getRowCount() && 0 < this.getTreeSelectedCount());
        this.jButtonExit.setEnabled(enable);
        this.jButtonPreferences.setEnabled(enable);
        this.jLabelPath.setEnabled(enable);
        this.jLabelPathText.setEnabled(enable);
        this.jPopupMenu.setEnabled(enable);
    }

    private void ableAll(boolean enable) {
        this.ableTreeViewButtons(enable);
        this.ableListViewButtons(enable);
        this.ableMiscellany(enable);
    }

    private void readData(int type) {
        this.readData(type, null);
    }

    private void readData(int type, String rootFolderFileName) {
        this.readData(type, rootFolderFileName, null);
    }

    public void readData(int type, String rootFolderFileName, MobiSwingWorker w) {
        if (null != w) {
            w.mobiPublish("Starting...");
        }
        this.ableAll(false);
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.emptyAll(type);
        if (3 <= type && null != rootFolderFileName) {
            numberOfBooks = Utils.getNumberOfFiles(new File(rootFolderFileName));
            numberOfBooksRead = 0;
            if (null != w) {
                w.mobiPublish("Reading books...");
            }
            Utils.setRootFolderFile(new File(rootFolderFileName), w);
            if (null != w) {
                w.mobiPublish("Completed reading books...");
            }
        }
        if (2 <= type) {
            if (null != w) {
                w.mobiPublish("Creating a list of tags...");
            }
            this.createTagList(w);
            this.populateListView();
        }
        if (1 <= type) {
            this.createCheckedItemList();
            if (null != w) {
                w.mobiPublish("Adding books to the tree...");
            }
            this.populateTreeView();
        }
        this.setCursor(Cursor.getDefaultCursor());
        this.ableAll(true);
        if (null != w) {
            w.mobiPublish("Tidying up...");
        }
    }

    private void emptyAll(int type) {
        if (3 <= type) {
            Counter.restart();
        } else {
            Counter.restartShown();
        }
        if (3 == type || 0 == type) {
            this.jTreeBooks.setModel(null);
            this.setBooksFoundLabel();
            this.setBooksSelectedLabel();
        }
        if (2 <= type || 0 == type) {
            Utils.setDefaultListModel(new DefaultListModel());
            this.checkBoxListTags.setModel(Utils.getDefaultListModel());
            Utils.setCurrentTags(null);
            TagList.emptyTagList();
            this.jLabelTagsSelected.setText(null);
        }
    }

    private void createTagList(MobiSwingWorker w) {
        TagList.emptyTagList();
        numberOfBooksRead = 0;
        this.getTagsFromFolderFiles(Utils.getRootFolder(), w);
    }

    private void getTagsFromFolderFiles(BookFolder bookFolder, MobiSwingWorker w) {
        int i;
        DecimalFormat formatter = new DecimalFormat("#,###,###");
        for (i = 0; null != bookFolder && null != bookFolder.getBookFolders() && i < bookFolder.getBookFolders().size(); ++i) {
            this.getTagsFromFolderFiles(bookFolder.getBookFolders().get(i), w);
        }
        for (i = 0; null != bookFolder && null != bookFolder.getBookFiles() && i < bookFolder.getBookFiles().size(); ++i) {
            ArrayList<String> tags;
            ++numberOfBooksRead;
            if (null != w) {
                w.mobiPublish("Creating tag list...checking book " + formatter.format(numberOfBooksRead) + " of " + formatter.format(numberOfBooks) + " for tags...");
            }
            if (null == bookFolder.getBookFiles().get(i) || null == (tags = bookFolder.getBookFiles().get(i).getTags())) continue;
            for (Object e : tags) {
                TagList.addTag(((String)e).trim());
            }
        }
    }

    private void populateListView() {
        TreeSet<String> ts = TagList.getTagList();
        this.ableListViewButtons(null != TagList.getTagList() && 0 < TagList.getTagList().size());
        if (null != ts) {
            Iterator<String> it = ts.iterator();
            while (it.hasNext()) {
                Utils.getDefaultListModel().addElement(new CheckBoxListEntry((Object)it.next(), true));
            }
        }
        this.ableListViewButtons(null != ts && 0 < ts.size());
    }

    private void createCheckedItemList() {
        ArrayList<String> cTags = null;
        List cbIncludeListTags = null;
        cbIncludeListTags = this.checkBoxListTags.getCheckedItems();
        if (null != cbIncludeListTags) {
            cTags = new ArrayList<String>();
            for (JCheckBox cbListTag : cbIncludeListTags) {
                cTags.add(cbListTag.getText());
            }
        }
        Utils.setCurrentTags(cTags);
        this.setTagsSelectedLabel();
    }

    private void setTagsSelectedLabel() {
        DecimalFormat formatter = new DecimalFormat("#,###,###");
        this.jLabelTagsSelected.setText("Selected " + formatter.format(Utils.getCurrentTags().size()) + " tags of " + formatter.format(Utils.getDefaultListModel().size()) + "");
    }

    private void populateTreeView() {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(Utils.getRootFolder());
        DefaultTreeModel model = new DefaultTreeModel(rootNode);
        this.jTreeBooks.setModel(model);
        this.jTreeBooks.setRootVisible(true);
        this.jTreeBooks.setShowsRootHandles(true);
        this.addFilesToTreeViewFromFolder(Utils.getRootFolder(), model, rootNode);
        this.jTreeBooks.expandPath(new TreePath(rootNode));
        this.ableTreeViewButtons(null != Utils.getRootFolder());
        if (Props.getExpandBooks()) {
            this.expandTreeView();
        }
        this.setBooksFoundLabel();
    }

    private void setBooksFoundLabel() {
        DecimalFormat formatter = new DecimalFormat("#,###,###");
        this.jLabelBooks.setText("Books found: " + formatter.format(Counter.getNumberOfBooks()));
        this.jLabelShowing.setText("Showing: " + formatter.format(Counter.getNumberOfBooksShown()));
    }

    private void setBooksSelectedLabel() {
        DecimalFormat formatter = new DecimalFormat("#,###,###");
        this.jLabelSelected.setText("Selected: " + formatter.format(this.getTreeSelectedCount()));
    }

    private void addFilesToTreeViewFromFolder(BookFolder folder, DefaultTreeModel model, DefaultMutableTreeNode rootNode) {
        DefaultMutableTreeNode childNode = null;
        if (null != folder && null != folder.getBookFolders()) {
            for (BookFolder bookFolder : folder.getBookFolders()) {
                if (!bookFolder.shouldIShow(Utils.getCurrentTags())) continue;
                childNode = new DefaultMutableTreeNode(bookFolder);
                if (model != null && rootNode != null) {
                    model.insertNodeInto(childNode, rootNode, rootNode.getChildCount());
                }
                this.addFilesToTreeViewFromFolder(bookFolder, model, childNode);
            }
        }
        if (null != folder && null != folder.getBookFiles()) {
            for (BookFile bookFile : folder.getBookFiles()) {
                if (!bookFile.shouldIShow(Utils.getCurrentTags()) || null == model || null == rootNode) continue;
                childNode = new DefaultMutableTreeNode(bookFile);
                model.insertNodeInto(childNode, rootNode, rootNode.getChildCount());
                Counter.addBookShown();
            }
        }
    }

    private void expandTreeView() {
        for (int i = 0; i < this.jTreeBooks.getRowCount(); ++i) {
            this.jTreeBooks.expandRow(i);
        }
    }

    private void collapseTreeView() {
        for (int i = this.jTreeBooks.getRowCount() - 1; i >= 0; --i) {
            this.jTreeBooks.collapseRow(i);
        }
    }

    protected static ImageIcon createImageIcon(String path) {
        ImageIcon icon = null;
        URL imgURL = MobiTag.class.getResource(path);
        if (imgURL != null) {
            icon = new ImageIcon(imgURL);
        } else {
            Utils.log("Unable to load image icon at '" + path + "'.", 3);
        }
        return icon;
    }

    private void initComponents() {
        this.jPopupMenu = new JPopupMenu();
        this.jMenuItemViewTags = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.jMenuItemEditTags = new JMenuItem();
        this.jMenuItemClearTags = new JMenuItem();
        this.buttonGroupAndOr = new ButtonGroup();
        this.jPanelBooks = new JPanel();
        this.jButtonRefresh = new JButton();
        this.jScrollPaneFiles = new JScrollPane();
        this.jTreeBooks = new JTree();
        this.jButtonCollapseAll = new JButton();
        this.jButtonExpandAll = new JButton();
        this.jLabelBooks = new JLabel();
        this.jLabelSelected = new JLabel();
        this.jLabelShowing = new JLabel();
        this.jPanelTags = new JPanel();
        this.jButtonSelectAll = new JButton();
        this.jButtonSelectNone = new JButton();
        this.jScrollPaneTags = new JScrollPane();
        this.checkBoxListTags = new CheckBoxList();
        this.jLabelTagsSelected = new JLabel();
        this.jLabelPath = new JLabel();
        this.jButtonBrowse = new JButton();
        this.jButtonAbout = new JButton();
        this.jButtonExit = new JButton();
        this.jButtonPreferences = new JButton();
        this.jLabelPathText = new JLabel();
        this.jButtonEditSelected = new JButton();
        this.jButtonEditAll = new JButton();
        this.jPanel1 = new JPanel();
        this.jRadioButtonOrTags = new JRadioButton();
        this.jRadioButtonAndBookTags = new JRadioButton();
        this.jRadioButtonAndSelectedTags = new JRadioButton();
        this.jPopupMenu.setFont(new Font("Tahoma", 0, 13));
        this.jMenuItemViewTags.setFont(new Font("Tahoma", 0, 13));
        this.jMenuItemViewTags.setText("View Tags");
        this.jMenuItemViewTags.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MobiTag.this.jMenuItemViewTagsActionPerformed(evt);
            }
        });
        this.jPopupMenu.add(this.jMenuItemViewTags);
        this.jPopupMenu.add(this.jSeparator1);
        this.jMenuItemEditTags.setFont(new Font("Tahoma", 0, 13));
        this.jMenuItemEditTags.setText("Edit Tags");
        this.jMenuItemEditTags.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MobiTag.this.jMenuItemEditTagsActionPerformed(evt);
            }
        });
        this.jPopupMenu.add(this.jMenuItemEditTags);
        this.jMenuItemClearTags.setFont(new Font("Tahoma", 0, 13));
        this.jMenuItemClearTags.setText("Clear Tags");
        this.jMenuItemClearTags.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MobiTag.this.jMenuItemClearTagsActionPerformed(evt);
            }
        });
        this.jPopupMenu.add(this.jMenuItemClearTags);
        this.setDefaultCloseOperation(3);
        this.setTitle("MobiTag");
        this.setSize(new Dimension(0, 0));
        this.jPanelBooks.setBorder(BorderFactory.createTitledBorder("Books"));
        this.jPanelBooks.setEnabled(false);
        this.jButtonRefresh.setText("Refresh");
        this.jButtonRefresh.setToolTipText("Refreshes the Books tree view. Select after changing the tags selected in the Tags list box.");
        this.jButtonRefresh.setEnabled(false);
        this.jButtonRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MobiTag.this.jButtonRefreshActionPerformed(evt);
            }
        });
        this.jTreeBooks.setEnabled(false);
        this.jTreeBooks.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MobiTag.this.jTreeBooksMouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                MobiTag.this.jTreeBooksMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                MobiTag.this.jTreeBooksMouseReleased(evt);
            }
        });
        this.jTreeBooks.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                MobiTag.this.jTreeBooksValueChanged(evt);
            }
        });
        this.jScrollPaneFiles.setViewportView(this.jTreeBooks);
        this.jButtonCollapseAll.setText("Collapse All");
        this.jButtonCollapseAll.setToolTipText("Collapses all elements in the Files tree.");
        this.jButtonCollapseAll.setEnabled(false);
        this.jButtonCollapseAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MobiTag.this.jButtonCollapseAllActionPerformed(evt);
            }
        });
        this.jButtonExpandAll.setText("Expand All");
        this.jButtonExpandAll.setToolTipText("Expands all elements in the Files tree.");
        this.jButtonExpandAll.setEnabled(false);
        this.jButtonExpandAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MobiTag.this.jButtonExpandAllActionPerformed(evt);
            }
        });
        this.jLabelBooks.setHorizontalAlignment(2);
        this.jLabelBooks.setText("jLabelBooks");
        this.jLabelSelected.setHorizontalAlignment(2);
        this.jLabelSelected.setText("jLabelSelected");
        this.jLabelShowing.setHorizontalAlignment(2);
        this.jLabelShowing.setText("jLabelShowing");
        GroupLayout jPanelBooksLayout = new GroupLayout(this.jPanelBooks);
        this.jPanelBooks.setLayout(jPanelBooksLayout);
        jPanelBooksLayout.setHorizontalGroup(jPanelBooksLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelBooksLayout.createSequentialGroup().addContainerGap().addGroup(jPanelBooksLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanelBooksLayout.createSequentialGroup().addGroup(jPanelBooksLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelShowing, -2, 318, -2).addComponent(this.jLabelSelected, -2, 318, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonRefresh).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonExpandAll).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCollapseAll)).addGroup(jPanelBooksLayout.createSequentialGroup().addGroup(jPanelBooksLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPaneFiles, -2, 604, -2).addComponent(this.jLabelBooks, -2, 604, -2)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanelBooksLayout.setVerticalGroup(jPanelBooksLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanelBooksLayout.createSequentialGroup().addComponent(this.jScrollPaneFiles, -1, 486, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelBooks).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelBooksLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanelBooksLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCollapseAll).addComponent(this.jButtonExpandAll).addComponent(this.jButtonRefresh)).addGroup(jPanelBooksLayout.createSequentialGroup().addComponent(this.jLabelShowing).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelSelected))).addContainerGap()));
        this.jPanelTags.setBorder(BorderFactory.createTitledBorder("Tags"));
        this.jPanelTags.setEnabled(false);
        this.jButtonSelectAll.setText("Select All");
        this.jButtonSelectAll.setToolTipText("Selects all elements in the Tags list.");
        this.jButtonSelectAll.setEnabled(false);
        this.jButtonSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MobiTag.this.jButtonSelectAllActionPerformed(evt);
            }
        });
        this.jButtonSelectNone.setText("Select None");
        this.jButtonSelectNone.setToolTipText("De-selects all elements in the Tags list.");
        this.jButtonSelectNone.setEnabled(false);
        this.jButtonSelectNone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MobiTag.this.jButtonSelectNoneActionPerformed(evt);
            }
        });
        this.checkBoxListTags.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.checkBoxListTags.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MobiTag.this.checkBoxListTagsMouseClicked(evt);
            }
        });
        this.checkBoxListTags.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                MobiTag.this.checkBoxListTagsKeyPressed(evt);
            }
        });
        this.jScrollPaneTags.setViewportView(this.checkBoxListTags);
        this.jLabelTagsSelected.setText("jLabelSelected");
        GroupLayout jPanelTagsLayout = new GroupLayout(this.jPanelTags);
        this.jPanelTags.setLayout(jPanelTagsLayout);
        jPanelTagsLayout.setHorizontalGroup(jPanelTagsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelTagsLayout.createSequentialGroup().addContainerGap().addGroup(jPanelTagsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelTagsLayout.createSequentialGroup().addComponent(this.jScrollPaneTags, -2, 210, -2).addContainerGap(-1, Short.MAX_VALUE)).addGroup(jPanelTagsLayout.createSequentialGroup().addGroup(jPanelTagsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelTagsSelected, -2, 209, -2).addGroup(jPanelTagsLayout.createSequentialGroup().addComponent(this.jButtonSelectNone).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSelectAll, -2, 101, -2))).addGap(0, 0, Short.MAX_VALUE)))));
        jPanelTagsLayout.setVerticalGroup(jPanelTagsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelTagsLayout.createSequentialGroup().addComponent(this.jScrollPaneTags).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelTagsSelected).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelTagsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonSelectNone).addComponent(this.jButtonSelectAll)).addContainerGap()));
        this.jLabelPath.setText("Path");
        this.jLabelPath.setEnabled(false);
        this.jButtonBrowse.setText("Browse");
        this.jButtonBrowse.setToolTipText("Select to change the folder in the path text field.");
        this.jButtonBrowse.setEnabled(false);
        this.jButtonBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MobiTag.this.jButtonBrowseActionPerformed(evt);
            }
        });
        this.jButtonAbout.setText("About");
        this.jButtonAbout.setEnabled(false);
        this.jButtonAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MobiTag.this.jButtonAboutActionPerformed(evt);
            }
        });
        this.jButtonExit.setText("Exit");
        this.jButtonExit.setEnabled(false);
        this.jButtonExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MobiTag.this.jButtonExitActionPerformed(evt);
            }
        });
        this.jButtonPreferences.setText("Preferences");
        this.jButtonPreferences.setEnabled(false);
        this.jButtonPreferences.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MobiTag.this.jButtonPreferencesActionPerformed(evt);
            }
        });
        this.jLabelPathText.setBackground(new Color(255, 255, 255));
        this.jLabelPathText.setToolTipText("Contains the path to the root folder of the eBook collection. All folders below this path will be scanned for .mobi files.");
        this.jLabelPathText.setBorder(BorderFactory.createEtchedBorder());
        this.jLabelPathText.setEnabled(false);
        this.jLabelPathText.setFocusable(false);
        this.jLabelPathText.setOpaque(true);
        this.jButtonEditSelected.setText("Edit Selected");
        this.jButtonEditSelected.setToolTipText("Select to edit all attributes of the selected book");
        this.jButtonEditSelected.setEnabled(false);
        this.jButtonEditSelected.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MobiTag.this.jButtonEditSelectedActionPerformed(evt);
            }
        });
        this.jButtonEditAll.setText("Edit All");
        this.jButtonEditAll.setToolTipText("Select to edit all attributes of all books");
        this.jButtonEditAll.setEnabled(false);
        this.jButtonEditAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MobiTag.this.jButtonEditAllActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Tag Use"));
        this.buttonGroupAndOr.add(this.jRadioButtonOrTags);
        this.jRadioButtonOrTags.setSelected(true);
        this.jRadioButtonOrTags.setText("OR tags");
        this.jRadioButtonOrTags.setToolTipText("If this is selected, then all books with any of the selected tags will be displayed");
        this.jRadioButtonOrTags.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MobiTag.this.jRadioButtonOrTagsActionPerformed(evt);
            }
        });
        this.buttonGroupAndOr.add(this.jRadioButtonAndBookTags);
        this.jRadioButtonAndBookTags.setText("AND book tags");
        this.jRadioButtonAndBookTags.setToolTipText("If this is selected, all books which have all of their tags in the selected tags will be shown");
        this.jRadioButtonAndBookTags.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MobiTag.this.jRadioButtonAndBookTagsActionPerformed(evt);
            }
        });
        this.buttonGroupAndOr.add(this.jRadioButtonAndSelectedTags);
        this.jRadioButtonAndSelectedTags.setText("AND selected tags");
        this.jRadioButtonAndSelectedTags.setToolTipText("If this is selected, then all books which have all of the selected tags will be shown");
        this.jRadioButtonAndSelectedTags.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MobiTag.this.jRadioButtonAndSelectedTagsActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonOrTags).addComponent(this.jRadioButtonAndBookTags).addComponent(this.jRadioButtonAndSelectedTags));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jRadioButtonOrTags).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonAndBookTags).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonAndSelectedTags)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(25, 25, 25).addComponent(this.jLabelPath).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelPathText, -2, 759, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonBrowse)).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jPanelBooks, -1, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelTags, -2, 245, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButtonExit, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonAbout, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonPreferences, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonEditSelected, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonEditAll, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -2, -1, -2)))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(13, 13, 13).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(4, 4, 4).addComponent(this.jLabelPath)).addComponent(this.jLabelPathText, -2, 25, -2).addComponent(this.jButtonBrowse)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanelBooks, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonEditAll).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonEditSelected).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonPreferences).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAbout).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonExit)).addComponent(this.jPanelTags, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void jButtonRefreshActionPerformed(ActionEvent evt) {
        this.readData(1);
    }

    private void jButtonBrowseActionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.jButtonBrowse) {
            int returnVal;
            JFileChooser fc = new JFileChooser();
            fc.setFileSelectionMode(1);
            File currentRootFolderFile = Utils.getRootFolderFile();
            if (null != currentRootFolderFile) {
                String currentRootFolderName = currentRootFolderFile.getAbsolutePath();
                fc.setCurrentDirectory(new File(currentRootFolderName));
            }
            if (0 == (returnVal = fc.showOpenDialog(this))) {
                Props.setRootFolderValue(fc.getSelectedFile().getAbsolutePath());
                Props.setProperties();
                this.jLabelPathText.setText(fc.getSelectedFile().getAbsolutePath());
                MobiSwingWorker worker = new MobiSwingWorker();
                worker.execute();
            }
        }
    }

    private void jButtonSelectNoneActionPerformed(ActionEvent evt) {
        this.checkBoxListTags.checkAll(false);
        if (Props.getAutoRefresh()) {
            this.readData(1);
        } else {
            this.createCheckedItemList();
        }
    }

    private void jButtonSelectAllActionPerformed(ActionEvent evt) {
        this.checkBoxListTags.checkAll(true);
        if (Props.getAutoRefresh()) {
            this.readData(1);
        } else {
            this.createCheckedItemList();
        }
    }

    private void jButtonCollapseAllActionPerformed(ActionEvent evt) {
        this.collapseTreeView();
    }

    private void jButtonExpandAllActionPerformed(ActionEvent evt) {
        this.expandTreeView();
    }

    private void jButtonExitActionPerformed(ActionEvent evt) {
        this.processWindowEvent(new WindowEvent(this, 201));
    }

    private void jButtonAboutActionPerformed(ActionEvent evt) {
        new About(this).setVisible(true);
    }

    private void jTreeBooksMouseClicked(MouseEvent evt) {
        this.mouseAction(evt);
    }

    private void mouseAction(MouseEvent evt) {
        Object nodeInfo;
        TreePath tp;
        DefaultMutableTreeNode node;
        int row = this.jTreeBooks.getClosestRowForLocation(evt.getX(), evt.getY());
        if (evt.isPopupTrigger() && null != (node = (DefaultMutableTreeNode)(tp = this.jTreeBooks.getPathForRow(row)).getLastPathComponent()) && node.isLeaf() && null != (nodeInfo = node.getUserObject()) && nodeInfo instanceof BookFile) {
            lastSelectedNode = (BookFile)nodeInfo;
            String tags = this.getTagStringFromTagList(lastSelectedNode);
            String text = null;
            text = null != tags && 0 < tags.length() ? "<html>" + lastSelectedNode.getShortName() + "<br>Current tags - " + tags + "</html>" : "<html>" + lastSelectedNode.getShortName() + "<br>Current tags - none</html>";
            this.jMenuItemViewTags.setText(text);
            this.showPopupMenu(evt);
        }
    }

    private void jButtonPreferencesActionPerformed(ActionEvent evt) {
        new Preferences(this).setVisible(true);
        this.readData(1);
        this.ableTooltips(Props.getShowTooltips());
    }

    private void jMenuItemViewTagsActionPerformed(ActionEvent evt) {
        this.popupMenuItemSelected(0);
    }

    private void jMenuItemEditTagsActionPerformed(ActionEvent evt) {
        this.popupMenuItemSelected(1);
    }

    private void popupMenuItemSelected(int command) {
        boolean confirmed = false;
        String dialogText = null;
        String currentTags = null;
        BookFile bFile = lastSelectedNode;
        switch (command) {
            case 0: {
                currentTags = this.getTagStringFromTagList(bFile);
                dialogText = null != currentTags ? bFile.getShortName() + "\n\nCurrent tags: " + currentTags : bFile.getShortName() + "\n\nCurrent tags: none";
                JOptionPane.showMessageDialog(null, dialogText, "MobiTag", 1, Utils.getImg());
                break;
            }
            case 1: {
                currentTags = this.getTagStringFromTagList(bFile);
                dialogText = null != currentTags ? bFile.getShortName() + "\n\nCurrent tags: " + currentTags + "\n\n(Enter new tags semi-colon separated)" : bFile.getShortName() + "\n\nCurrent tags: none" + "\n\n(Enter new tags semi-colon separated)";
                String newTags = null;
                newTags = (String)JOptionPane.showInputDialog(null, dialogText, "MobiTag", -1, Utils.getImg(), null, currentTags);
                if (null == newTags || 0 >= newTags.trim().length()) break;
                String[] tokens = newTags.trim().split(";");
                ArrayList<String> tags = new ArrayList<String>(Arrays.asList(tokens));
                bFile.setTags(tags);
                this.readData(2);
                break;
            }
            case 2: {
                currentTags = this.getTagStringFromTagList(bFile);
                if (null != currentTags) {
                    if (Props.getRequireConfirmation()) {
                        dialogText = bFile.getShortName() + "\n\nCurrent tags: " + currentTags + "\n\nAre you sure you want to clear these tags?";
                        if (0 == JOptionPane.showConfirmDialog(null, dialogText, "MobiTag", 0, 3, Utils.getImg())) {
                            confirmed = true;
                        }
                    } else {
                        confirmed = true;
                    }
                } else {
                    JOptionPane.showMessageDialog(null, bFile.getShortName() + "\n\nNo existing tags to clear!", "MobiTag", 1, Utils.getImg());
                }
                if (!confirmed) break;
                bFile.deleteBookFileTags();
                this.readData(2);
            }
        }
    }

    private String getTagStringFromTagList(BookFile bFile) {
        String value = null;
        if (null != bFile && null != bFile.getTags() && 0 < bFile.getTags().size()) {
            ArrayList<String> tags = new ArrayList<String>(bFile.getTags());
            for (String tag : tags) {
                if (null == value) {
                    value = tag.trim();
                    continue;
                }
                value = value + ";" + tag.trim();
            }
        }
        return value;
    }

    private ImageIcon createImageIcon(String path, String description) {
        ImageIcon img = null;
        URL imgURL = this.getClass().getResource(path);
        if (imgURL == null) {
            return null;
        }
        img = new ImageIcon(imgURL, description);
        return img;
    }

    private void jTreeBooksMousePressed(MouseEvent evt) {
        this.mouseAction(evt);
    }

    private void jTreeBooksMouseReleased(MouseEvent evt) {
        this.mouseAction(evt);
    }

    private void jMenuItemClearTagsActionPerformed(ActionEvent evt) {
        this.popupMenuItemSelected(2);
    }

    private void checkBoxListTagsMouseClicked(MouseEvent evt) {
        Object obj;
        int index = this.checkBoxListTags.locationToIndex(evt.getPoint());
        if (index != -1 && (obj = this.checkBoxListTags.getModel().getElementAt(index)) instanceof JCheckBox) {
            JCheckBox checkbox;
            checkbox.setSelected(!(checkbox = (JCheckBox)obj).isSelected());
            this.repaint();
            if (Props.getAutoRefresh()) {
                this.readData(1);
            } else {
                this.createCheckedItemList();
            }
        }
    }

    private void checkBoxListTagsKeyPressed(KeyEvent evt) {
        Object obj;
        int index;
        if (evt.getKeyCode() == 32 && (index = this.checkBoxListTags.getSelectedIndex()) != -1 && (obj = this.checkBoxListTags.getModel().getElementAt(index)) instanceof JCheckBox) {
            JCheckBox checkbox;
            checkbox.setSelected(!(checkbox = (JCheckBox)obj).isSelected());
            this.repaint();
            if (Props.getAutoRefresh()) {
                this.readData(1);
            }
        }
    }

    private void jButtonEditSelectedActionPerformed(ActionEvent evt) {
        ArrayList<BookFile> bookFiles = null;
        int numberSelected = this.getTreeSelectedCount();
        if (1 < numberSelected) {
            TreePath[] tp;
            for (TreePath treePath : tp = this.jTreeBooks.getSelectionPaths()) {
                Object nodeInfo;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                if (null == node || !node.isLeaf() || null == (nodeInfo = node.getUserObject()) || !(nodeInfo instanceof BookFile)) continue;
                if (null == bookFiles) {
                    bookFiles = new ArrayList<BookFile>();
                }
                bookFiles.add((BookFile)nodeInfo);
            }
            this.showEditDialog(bookFiles);
        } else {
            Object nodeInfo;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.jTreeBooks.getLastSelectedPathComponent();
            if (null != node && node.isLeaf() && null != (nodeInfo = node.getUserObject()) && nodeInfo instanceof BookFile) {
                this.showEditDialog((BookFile)nodeInfo);
            }
        }
    }

    private int getTreeSelectedCount() {
        int numberSelected = this.jTreeBooks.getSelectionCount();
        if (1 == numberSelected) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.jTreeBooks.getLastSelectedPathComponent();
            numberSelected = null != node && node.isLeaf() ? 1 : 0;
        } else if (1 < numberSelected) {
            TreePath[] tp;
            numberSelected = 0;
            for (TreePath treePath : tp = this.jTreeBooks.getSelectionPaths()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                if (null == node || !node.isLeaf()) continue;
                ++numberSelected;
            }
        }
        return numberSelected;
    }

    private void jButtonEditAllActionPerformed(ActionEvent evt) {
        this.showEditDialog((BookFile)null);
    }

    private void showEditDialog(BookFile bFile) {
        Edit edit = new Edit((Frame)this, bFile);
        edit.setVisible(true);
        boolean response = edit.getReturn();
        edit.dispose();
        if (response) {
            MobiSwingWorker worker = new MobiSwingWorker();
            worker.execute();
        }
    }

    private void showEditDialog(ArrayList<BookFile> bFiles) {
        Edit edit = new Edit((Frame)this, bFiles);
        edit.setVisible(true);
        boolean response = edit.getReturn();
        edit.dispose();
        if (response) {
            MobiSwingWorker worker = new MobiSwingWorker();
            worker.execute();
        }
    }

    private void jTreeBooksValueChanged(TreeSelectionEvent evt) {
        this.jButtonEditSelected.setEnabled(0 < this.getTreeSelectedCount());
        this.setBooksSelectedLabel();
    }

    private void jRadioButtonOrTagsActionPerformed(ActionEvent evt) {
        this.setAndOrTags();
    }

    private void jRadioButtonAndBookTagsActionPerformed(ActionEvent evt) {
        this.setAndOrTags();
    }

    private void jRadioButtonAndSelectedTagsActionPerformed(ActionEvent evt) {
        this.setAndOrTags();
    }

    private void setAndOrTags() {
        int andOrTags = 0;
        if (this.jRadioButtonAndBookTags.isSelected()) {
            andOrTags = 1;
        } else if (this.jRadioButtonAndSelectedTags.isSelected()) {
            andOrTags = 2;
        }
        Props.setAndOrTags(andOrTags);
        Props.setProperties();
        this.readData(1);
    }

    private void showPopupMenu(MouseEvent e) {
        this.jPopupMenu.show(this.jTreeBooks, e.getX(), e.getY());
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Windows".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            Logger.getLogger(MobiTag.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(() -> new MobiTag().setVisible(true));
    }

    public class MobiSwingWorker
    extends SwingWorker<Boolean, String> {
        @Override
        protected Boolean doInBackground() throws Exception {
            MobiTag.this.readData(3, Props.getRootFolderValue(), this);
            return true;
        }

        public final void mobiPublish(String text) {
            this.publish(text);
        }

        public final void readAnotherBook() {
            String text = null;
            numberOfBooksRead++;
            DecimalFormat formatter = new DecimalFormat("#,###,###");
            if (numberOfBooksRead <= numberOfBooks) {
                text = "Reading book " + formatter.format(numberOfBooksRead) + " out of " + formatter.format(numberOfBooks) + "...";
                this.mobiPublish(text);
            }
        }

        @Override
        protected void process(List<String> chunks) {
            String mostRecentValue = chunks.get(chunks.size() - 1);
            MobiTag.this.jLabelBooks.setText(mostRecentValue);
        }

        @Override
        protected final void done() {
            MobiTag.this.setBooksFoundLabel();
        }
    }
}

