/*
 * Decompiled with CFR 0.152.
 */
package mobitag;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import mobimeta.EXTHRecord;
import mobitag.AddRecordType;
import mobitag.BookFile;
import mobitag.BookFolder;
import mobitag.Counter;
import mobitag.RecordTypeChange;
import mobitag.Utils;

public class Edit
extends JDialog {
    ArrayList<EXTHRecord> records = null;
    TreeMap recordsMap = new TreeMap();
    BookFile bookFile = null;
    ArrayList<BookFile> bookFiles = null;
    ArrayList<RecordTypeChange> changes = null;
    int changedFile = 0;
    private boolean tagsChanged = false;
    private final int COLUMN_NAME = 0;
    private final int COLUMN_INDEX = 1;
    private final int COLUMN_VALUE = 2;
    private final int COLUMN_DELETE = 3;
    private final int COLUMN_APPLY = 4;
    SwingWorker<Boolean, String> worker = new SwingWorker<Boolean, String>(){

        @Override
        protected Boolean doInBackground() throws Exception {
            if (null == Edit.this.bookFiles) {
                this.storeChanges(Utils.getRootFolder(), Edit.this.changes);
            } else {
                this.storeChanges(Edit.this.bookFiles, Edit.this.changes);
            }
            return true;
        }

        private boolean storeChanges(ArrayList<BookFile> bookFiles, ArrayList<RecordTypeChange> changes) {
            boolean ok = true;
            for (BookFile bFile : bookFiles) {
                DecimalFormat formatter = new DecimalFormat("#,###,###");
                this.publish(formatter.format(++Edit.this.changedFile) + " of " + formatter.format(bookFiles.size()));
                ok = bFile.storeChanges(changes);
            }
            return ok;
        }

        private boolean storeChanges(BookFolder bookFolder, ArrayList<RecordTypeChange> changes) {
            boolean ok = true;
            if (null != bookFolder && null != bookFolder.getBookFolders()) {
                for (BookFolder folder : bookFolder.getBookFolders()) {
                    ok = this.storeChanges(folder, changes);
                }
            }
            if (null != bookFolder && null != bookFolder.getBookFiles()) {
                for (BookFile bFile : bookFolder.getBookFiles()) {
                    DecimalFormat formatter = new DecimalFormat("#,###,###");
                    this.publish(formatter.format(++Edit.this.changedFile) + " of " + formatter.format(Counter.getNumberOfBooks()));
                    ok = bFile.storeChanges(changes);
                }
            }
            return ok;
        }

        @Override
        protected void done() {
            try {
                boolean status = (Boolean)this.get();
                Edit.this.setSavingState(false);
                Edit.this.jLabelCurrentChange.setText(null);
                Edit.this.setVisible(false);
                Edit.this.dispose();
            }
            catch (InterruptedException | ExecutionException exception) {
                // empty catch block
            }
        }

        @Override
        protected void process(List<String> chunks) {
            String mostRecentValue = chunks.get(chunks.size() - 1);
            Edit.this.jLabelCurrentChange.setText("Storing changes for book " + mostRecentValue);
        }
    };
    private JButton jButtonAdd;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JLabel jLabelCurrentChange;
    private JLabel jLabelEditing;
    private JList jListBooks;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTable jTableEdit;

    public Edit(Frame parent) {
        this(parent, (BookFile)null);
    }

    public Edit(Frame parent, ArrayList bookFiles) {
        super(parent, true);
        this.bookFiles = bookFiles;
        this.processEdit(parent);
    }

    public Edit(Frame parent, BookFile bookFile) {
        super(parent, true);
        this.bookFile = bookFile;
        this.processEdit(parent);
    }

    private void processEdit(Frame parent) {
        DecimalFormat formatter;
        this.initComponents();
        this.jLabelCurrentChange.setText(null);
        DefaultListModel<String> booksModel = new DefaultListModel<String>();
        this.jListBooks.setModel(booksModel);
        if (null != this.bookFile) {
            this.jLabelEditing.setText("Editing the metadata of the following book:");
            booksModel.addElement(this.bookFile.getShortName());
        } else if (null != this.bookFiles) {
            formatter = new DecimalFormat("#,###,###");
            this.jLabelEditing.setText("Editing the metadata of the following " + formatter.format(this.bookFiles.size()) + " books:");
            for (int i = 0; i < this.bookFiles.size(); ++i) {
                BookFile bf = this.bookFiles.get(i);
                booksModel.addElement(bf.getShortName());
            }
        } else {
            formatter = new DecimalFormat("#,###,###");
            this.jLabelEditing.setText("Editing the metadata of the following " + formatter.format(Utils.getNumberOfFiles(Utils.getRootFolderFile())) + " books:");
            Edit.getFolderFileNames(Utils.getRootFolder(), booksModel);
        }
        this.jTableEdit.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                int column = e.getColumn();
                int row = e.getFirstRow();
                if (3 == column) {
                    boolean value = (Boolean)Edit.this.jTableEdit.getModel().getValueAt(row, column);
                    Edit.this.jTableEdit.getModel().setValueAt(value, row, 4);
                } else if (2 == column) {
                    String s = (String)Edit.this.jTableEdit.getModel().getValueAt(row, column);
                    if (null != s && 0 < s.length()) {
                        Edit.this.jTableEdit.getModel().setValueAt(true, row, 4);
                    } else {
                        Edit.this.jTableEdit.getModel().setValueAt(false, row, 4);
                    }
                }
            }
        });
        TableColumnModel columnModel = this.jTableEdit.getColumnModel();
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setHorizontalAlignment(0);
        this.pack();
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("images/book.png")));
        Rectangle parentBounds = parent.getBounds();
        Dimension size = this.getSize();
        int x = Math.max(0, parentBounds.x + (parentBounds.width - size.width) / 2);
        int y = Math.max(0, parentBounds.y + (parentBounds.height - size.height) / 2);
        this.setLocation(new Point(x, y));
        DefaultTableModel model = (DefaultTableModel)this.jTableEdit.getModel();
        TableCellRenderer rendererFromHeader = this.jTableEdit.getTableHeader().getDefaultRenderer();
        JLabel headerLabel = (JLabel)((Object)rendererFromHeader);
        headerLabel.setHorizontalAlignment(0);
        columnModel.getColumn(0).setMinWidth(this.jTableEdit.getWidth() * 1 / 4);
        columnModel.getColumn(1).setMinWidth(this.jTableEdit.getWidth() * 1 / 8);
        columnModel.getColumn(2).setMinWidth(this.jTableEdit.getWidth() * 3 / 8);
        columnModel.getColumn(3).setMinWidth(this.jTableEdit.getWidth() * 1 / 8);
        this.jTableEdit.getColumnModel().getColumn(1).setCellRenderer(renderer);
        this.recordsMap = new TreeMap();
        if (null != this.bookFile) {
            this.records = new ArrayList<EXTHRecord>(this.bookFile.getEXTHRecords());
            for (int i = 0; null != this.records && i < this.records.size(); ++i) {
                EXTHRecord record = this.records.get(i);
                this.recordsMap.put(record.getRecordTypeAsInt(), record.getRecordDataAsString());
            }
        } else if (null != this.bookFiles) {
            this.getRecordTypes(this.bookFiles);
        } else {
            this.getRecordTypes(Utils.getRootFolder());
        }
        for (Map.Entry entry : this.recordsMap.entrySet()) {
            int key = (Integer)entry.getKey();
            String value = (String)entry.getValue();
            model.addRow(new Object[]{Utils.getRecordTypeString(key), key, value, false, false});
        }
    }

    private static void getFolderFileNames(BookFolder root, DefaultListModel m) {
        int i;
        ArrayList<BookFile> bookFiles = root.getBookFiles();
        ArrayList<BookFolder> bookFolders = root.getBookFolders();
        for (i = 0; null != bookFolders && i < bookFolders.size(); ++i) {
            Edit.getFolderFileNames(bookFolders.get(i), m);
        }
        for (i = 0; null != bookFiles && i < bookFiles.size(); ++i) {
            m.addElement(bookFiles.get(i).getShortName());
        }
    }

    private void getRecordTypes(ArrayList<BookFile> bookFiles) {
        for (int i = 0; i < bookFiles.size(); ++i) {
            BookFile bFile = bookFiles.get(i);
            this.records = new ArrayList<EXTHRecord>(bFile.getEXTHRecords());
            for (int k = 0; null != this.records && k < this.records.size(); ++k) {
                int key = 0;
                String data = null;
                EXTHRecord record = this.records.get(k);
                key = record.getRecordTypeAsInt();
                data = record.getRecordDataAsString();
                String d = (String)this.recordsMap.get(key);
                if (null == d) {
                    this.recordsMap.put(key, data);
                    continue;
                }
                if (d.equalsIgnoreCase(data)) continue;
                this.recordsMap.put(key, "");
            }
        }
    }

    private void getRecordTypes(BookFolder bookFolder) {
        if (null != bookFolder && null != bookFolder.getBookFolders()) {
            for (BookFolder folder : bookFolder.getBookFolders()) {
                this.getRecordTypes(folder);
            }
        }
        if (null != bookFolder && null != bookFolder.getBookFiles()) {
            for (BookFile bFile : bookFolder.getBookFiles()) {
                this.records = new ArrayList<EXTHRecord>(bFile.getEXTHRecords());
                for (int k = 0; null != this.records && k < this.records.size(); ++k) {
                    int key = 0;
                    String data = null;
                    EXTHRecord record = this.records.get(k);
                    key = record.getRecordTypeAsInt();
                    data = record.getRecordDataAsString();
                    String d = (String)this.recordsMap.get(key);
                    if (null == d) {
                        this.recordsMap.put(key, data);
                        continue;
                    }
                    if (d.equalsIgnoreCase(data)) continue;
                    this.recordsMap.put(key, "");
                }
            }
        }
    }

    private void setSavingState(boolean saving) {
        this.jButtonAdd.setEnabled(!saving);
        this.jButtonCancel.setEnabled(!saving);
        this.jButtonOK.setEnabled(!saving);
        this.jTableEdit.setEnabled(!saving);
        this.setDefaultCloseOperation(saving ? 0 : 2);
        if (saving) {
            this.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private boolean saveChanges() {
        int i;
        boolean saved = true;
        for (i = 0; i < this.jTableEdit.getModel().getRowCount(); ++i) {
            if (!((Boolean)this.jTableEdit.getModel().getValueAt(i, 4)).booleanValue()) continue;
            int type = (Integer)this.jTableEdit.getModel().getValueAt(i, 1);
            String newValue = (String)this.jTableEdit.getModel().getValueAt(i, 2);
            boolean delete = (Boolean)this.jTableEdit.getModel().getValueAt(i, 3);
            if (null == this.changes) {
                this.changes = new ArrayList();
            }
            this.changes.add(new RecordTypeChange(type, newValue, delete));
        }
        if (null == this.changes) {
            JOptionPane.showMessageDialog(null, "No changes were made to store.", "MobiTag", 0, Utils.getImg());
            saved = false;
        } else {
            for (i = 0; !this.tagsChanged && i < this.changes.size(); ++i) {
                RecordTypeChange rtp = this.changes.get(i);
                this.tagsChanged = 105 == rtp.getType();
            }
            if (null != this.bookFile) {
                this.bookFile.storeChanges(this.changes);
            } else {
                this.setSavingState(true);
                this.changedFile = 0;
                this.worker.execute();
            }
        }
        return saved;
    }

    public TreeMap getRecordTypes() {
        TreeMap<Integer, String> allRecordsMap = new TreeMap<Integer, String>();
        allRecordsMap.put(1, "drm_server_id");
        allRecordsMap.put(2, "drm_commerce_id");
        allRecordsMap.put(3, "drm_ebookbase_book_id");
        allRecordsMap.put(100, "author");
        allRecordsMap.put(101, "publisher");
        allRecordsMap.put(102, "imprint");
        allRecordsMap.put(103, "description");
        allRecordsMap.put(104, "isbn");
        allRecordsMap.put(105, "tags");
        allRecordsMap.put(106, "publishingdate");
        allRecordsMap.put(107, "review");
        allRecordsMap.put(108, "contributor");
        allRecordsMap.put(109, "rights");
        allRecordsMap.put(110, "subjectcode");
        allRecordsMap.put(111, "type");
        allRecordsMap.put(112, "source");
        allRecordsMap.put(113, "asin");
        allRecordsMap.put(114, "versionnumber");
        allRecordsMap.put(115, "sample");
        allRecordsMap.put(116, "startreading");
        allRecordsMap.put(117, "adult");
        allRecordsMap.put(118, "retail price");
        allRecordsMap.put(119, "retail price currency");
        allRecordsMap.put(121, "KF8 BOUNDARY Offset");
        allRecordsMap.put(125, "count of resources");
        allRecordsMap.put(129, "KF8 cover URI");
        allRecordsMap.put(131, "Unknown");
        allRecordsMap.put(200, "Dictionary short name");
        allRecordsMap.put(201, "coveroffset");
        allRecordsMap.put(202, "thumboffset");
        allRecordsMap.put(203, "hasfakecover");
        allRecordsMap.put(204, "Creator Software");
        allRecordsMap.put(205, "Creator Major Version");
        allRecordsMap.put(206, "Creator Minor Version");
        allRecordsMap.put(207, "Creator Build Number");
        allRecordsMap.put(208, "watermark");
        allRecordsMap.put(209, "tamper proof keys");
        allRecordsMap.put(300, "fontsignature");
        allRecordsMap.put(401, "clippinglimit");
        allRecordsMap.put(402, "publisherlimit");
        allRecordsMap.put(403, "Unknown");
        allRecordsMap.put(404, "ttsflag");
        allRecordsMap.put(405, "Unknown");
        allRecordsMap.put(406, "Rent/Borrow Expiration Date");
        allRecordsMap.put(407, "Unknown");
        allRecordsMap.put(450, "Unknown");
        allRecordsMap.put(451, "Unknown");
        allRecordsMap.put(452, "Unknown");
        allRecordsMap.put(453, "Unknown");
        allRecordsMap.put(501, "cdetype");
        allRecordsMap.put(502, "lastupdatetime");
        allRecordsMap.put(503, "updatedtitle");
        allRecordsMap.put(504, "asin");
        allRecordsMap.put(524, "language");
        allRecordsMap.put(525, "alignment");
        allRecordsMap.put(535, "Creator Build Number");
        allRecordsMap.put(547, "InMemory");
        for (int i = 0; i < this.jTableEdit.getModel().getRowCount(); ++i) {
            int type = (Integer)this.jTableEdit.getModel().getValueAt(i, 1);
            allRecordsMap.remove(type);
        }
        return allRecordsMap;
    }

    public boolean getReturn() {
        return this.tagsChanged;
    }

    public JTable getEditTable() {
        return this.jTableEdit;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTableEdit = new JTable();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonAdd = new JButton();
        this.jLabelCurrentChange = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jListBooks = new JList();
        this.jLabelEditing = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("MobiTag Edit");
        this.setResizable(false);
        this.jTableEdit.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jTableEdit.setModel(new DefaultTableModel(new Object[0][], new String[]{"Record Type", "Index", "Value", "Delete", "Apply?"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, Integer.class, String.class, Boolean.class, Boolean.class};
                this.canEdit = new boolean[]{false, false, true, true, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTableEdit.setSelectionMode(0);
        this.jTableEdit.getTableHeader().setResizingAllowed(false);
        this.jTableEdit.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane1.setViewportView(this.jTableEdit);
        if (this.jTableEdit.getColumnModel().getColumnCount() > 0) {
            this.jTableEdit.getColumnModel().getColumn(0).setResizable(false);
            this.jTableEdit.getColumnModel().getColumn(1).setResizable(false);
        }
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Edit.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Edit.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonAdd.setText("Add Record");
        this.jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Edit.this.jButtonAddActionPerformed(evt);
            }
        });
        this.jLabelCurrentChange.setText("jLabelCurrentChange");
        this.jListBooks.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane2.setViewportView(this.jListBooks);
        this.jLabelEditing.setText("jLabelEditing");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabelEditing).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.jButtonAdd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jScrollPane2, GroupLayout.Alignment.LEADING).addComponent(this.jLabelCurrentChange, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 627, Short.MAX_VALUE))).addGap(23, 23, 23)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 460, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelCurrentChange).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 14, Short.MAX_VALUE).addComponent(this.jLabelEditing).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane2, -2, 109, -2).addContainerGap(-1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(131, 131, 131).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOK).addComponent(this.jButtonAdd)).addContainerGap()))));
        this.pack();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.saveChanges() && null != this.bookFile) {
            this.setVisible(false);
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        AddRecordType art = new AddRecordType((Frame)((JFrame)this.getParent()), this);
        art.setVisible(true);
        int response = art.getReturn();
        art.dispose();
        if (0 < response) {
            DefaultTableModel dtm = (DefaultTableModel)this.jTableEdit.getModel();
            dtm.addRow(new Object[]{Utils.getRecordTypeString(response), response, "", false, true});
            this.recordsMap.put(response, "");
        }
    }
}

